<?php
/**
 * The template to display the background video in the header
 *
 * @package WordPress
 * @subpackage ANUBIA
 * @since ANUBIA 1.0.14
 */
$anubia_header_video = anubia_get_header_video();
$anubia_embed_video = '';
if (!empty($anubia_header_video) && !anubia_is_from_uploads($anubia_header_video)) {
	if (anubia_is_youtube_url($anubia_header_video) && preg_match('/[=\/]([^=\/]*)$/', $anubia_header_video, $matches) && !empty($matches[1])) {
		?><div id="background_video" data-youtube-code="<?php echo esc_attr($matches[1]); ?>"></div><?php
	} else {
		global $wp_embed;
		if (false && is_object($wp_embed)) {
			$anubia_embed_video = do_shortcode($wp_embed->run_shortcode( '[embed]' . trim($anubia_header_video) . '[/embed]' ));
			$anubia_embed_video = anubia_make_video_autoplay($anubia_embed_video);
		} else {
			$anubia_header_video = str_replace('/watch?v=', '/embed/', $anubia_header_video);
			$anubia_header_video = anubia_add_to_url($anubia_header_video, array(
				'feature' => 'oembed',
				'controls' => 0,
				'autoplay' => 1,
				'showinfo' => 0,
				'modestbranding' => 1,
				'wmode' => 'transparent',
				'enablejsapi' => 1,
				'origin' => home_url(),
				'widgetid' => 1
			));
			$anubia_embed_video = '<iframe src="' . esc_url($anubia_header_video) . '" width="1170" height="658" allowfullscreen="0" frameborder="0"></iframe>';
		}
		?><div id="background_video"><?php anubia_show_layout($anubia_embed_video); ?></div><?php
	}
}
?>