<?php
/**
 * The template to display the widgets area in the header
 *
 * @package WordPress
 * @subpackage ANUBIA
 * @since ANUBIA 1.0
 */

// Header sidebar
$anubia_header_name = anubia_get_theme_option('header_widgets');
$anubia_header_present = !anubia_is_off($anubia_header_name) && is_active_sidebar($anubia_header_name);
if ($anubia_header_present) { 
	anubia_storage_set('current_sidebar', 'header');
	$anubia_header_wide = anubia_get_theme_option('header_wide');
	ob_start();
	if ( is_active_sidebar($anubia_header_name) ) {
		dynamic_sidebar($anubia_header_name);
	}
	$anubia_widgets_output = ob_get_contents();
	ob_end_clean();
	if (!empty($anubia_widgets_output)) {
		$anubia_widgets_output = preg_replace("/<\/aside>[\r\n\s]*<aside/", "</aside><aside", $anubia_widgets_output);
		$anubia_need_columns = strpos($anubia_widgets_output, 'columns_wrap')===false;
		if ($anubia_need_columns) {
			$anubia_columns = max(0, (int) anubia_get_theme_option('header_columns'));
			if ($anubia_columns == 0) $anubia_columns = min(6, max(1, substr_count($anubia_widgets_output, '<aside ')));
			if ($anubia_columns > 1)
				$anubia_widgets_output = preg_replace("/<aside([^>]*)class=\"widget/", "<aside$1class=\"column-1_".esc_attr($anubia_columns).' widget', $anubia_widgets_output);
			else
				$anubia_need_columns = false;
		}
		?>
		<div class="header_widgets_wrap widget_area<?php echo !empty($anubia_header_wide) ? ' header_fullwidth' : ' header_boxed'; ?>">
			<div class="header_widgets_inner widget_area_inner">
				<?php 
				if (!$anubia_header_wide) { 
					?><div class="content_wrap"><?php
				}
				if ($anubia_need_columns) {
					?><div class="columns_wrap"><?php
				}
				do_action( 'anubia_action_before_sidebar' );
				anubia_show_layout($anubia_widgets_output);
				do_action( 'anubia_action_after_sidebar' );
				if ($anubia_need_columns) {
					?></div>	<!-- /.columns_wrap --><?php
				}
				if (!$anubia_header_wide) {
					?></div>	<!-- /.content_wrap --><?php
				}
				?>
			</div>	<!-- /.header_widgets_inner -->
		</div>	<!-- /.header_widgets_wrap -->
		<?php
	}
}
?>