<?php
/**
 * The template to display posts in widgets and/or in the search results
 *
 * @package WordPress
 * @subpackage ANUBIA
 * @since ANUBIA 1.0
 */

$anubia_post_id    = get_the_ID();
$anubia_post_date  = anubia_get_date();
$anubia_post_title = get_the_title();
$anubia_post_link  = get_permalink();
$anubia_post_author_id   = get_the_author_meta('ID');
$anubia_post_author_name = get_the_author_meta('display_name');
$anubia_post_author_url  = get_author_posts_url($anubia_post_author_id, '');

$anubia_args = get_query_var('anubia_args_widgets_posts');
$anubia_show_date = isset($anubia_args['show_date']) ? (int) $anubia_args['show_date'] : 1;
$anubia_show_image = isset($anubia_args['show_image']) ? (int) $anubia_args['show_image'] : 1;
$anubia_show_author = isset($anubia_args['show_author']) ? (int) $anubia_args['show_author'] : 1;
$anubia_show_counters = isset($anubia_args['show_counters']) ? (int) $anubia_args['show_counters'] : 1;
$anubia_show_categories = isset($anubia_args['show_categories']) ? (int) $anubia_args['show_categories'] : 1;

$anubia_output = anubia_storage_get('anubia_output_widgets_posts');

$anubia_post_counters_output = '';
if ( $anubia_show_counters ) {
	$anubia_post_counters_output = '<span class="post_info_item post_info_counters">'
								. anubia_get_post_counters('comments')
							. '</span>';
}


$anubia_output .= '<article class="post_item with_thumb">';

if ($anubia_show_image) {
	$anubia_post_thumb = get_the_post_thumbnail($anubia_post_id, anubia_get_thumb_size('tiny'), array(
		'alt' => the_title_attribute( array( 'echo' => false ) )
	));
	if ($anubia_post_thumb) $anubia_output .= '<div class="post_thumb">' . ($anubia_post_link ? '<a href="' . esc_url($anubia_post_link) . '">' : '') . ($anubia_post_thumb) . ($anubia_post_link ? '</a>' : '') . '</div>';
}

$anubia_output .= '<div class="post_content">'
			. ($anubia_show_categories 
					? '<div class="post_categories">'
						. anubia_get_post_categories()
						. $anubia_post_counters_output
						. '</div>' 
					: '')
			. '<h6 class="post_title">' . ($anubia_post_link ? '<a href="' . esc_url($anubia_post_link) . '">' : '') . ($anubia_post_title) . ($anubia_post_link ? '</a>' : '') . '</h6>'
			. apply_filters('anubia_filter_get_post_info', 
								'<div class="post_info">'
									. ($anubia_show_date 
										? '<span class="post_info_item post_info_posted">'
											. ($anubia_post_link ? '<a href="' . esc_url($anubia_post_link) . '" class="post_info_date">' : '') 
											. esc_html($anubia_post_date) 
											. ($anubia_post_link ? '</a>' : '')
											. '</span>'
										: '')
									. ($anubia_show_author 
										? '<span class="post_info_item post_info_posted_by">' 
											. esc_html__('by', 'anubia') . ' ' 
											. ($anubia_post_link ? '<a href="' . esc_url($anubia_post_author_url) . '" class="post_info_author">' : '') 
											. esc_html($anubia_post_author_name) 
											. ($anubia_post_link ? '</a>' : '') 
											. '</span>'
										: '')
									. (!$anubia_show_categories && $anubia_post_counters_output
										? $anubia_post_counters_output
										: '')
								. '</div>')
		. '</div>'
	. '</article>';
anubia_storage_set('anubia_output_widgets_posts', $anubia_output);
?>