<?php
/**
 * Setup theme-specific fonts and colors
 *
 * @package WordPress
 * @subpackage ANUBIA
 * @since ANUBIA 1.0.22
 */

if (!defined("ANUBIA_THEME_FREE")) define("ANUBIA_THEME_FREE", false);
if (!defined("ANUBIA_THEME_FREE_WP")) define("ANUBIA_THEME_FREE_WP", false);

// Theme storage
$ANUBIA_STORAGE = array(
	
	// Theme-specific URLs (will be escaped in place of the output)
	'theme_demo_url'	=> '//anubia.ancorathemes.com',
	'theme_doc_url'		=> '//anubia.ancorathemes.com/doc',
    'theme_download_url'=> 'https://1.envato.market/c/1262870/275988/4415?subId1=ancora&u=themeforest.net/item/anubia-hookah-bar-wordpress-theme/21451392',

	'theme_support_url'	=> 'https://themerex.net/support/',

	'theme_video_url'	=> 'https://www.youtube.com/channel/UCdIjRh7-lPVHqTTKpaf8PLA',	// Ancora

	// Responsive resolutions
	// Parameters to create css media query: min, max, 
	'responsive' => array(
						// By device
						'desktop'	=> array('min' => 1680),
						'notebook'	=> array('min' => 1280, 'max' => 1679),
						'tablet'	=> array('min' =>  768, 'max' => 1279),
						'mobile'	=> array('max' =>  767),
						// By size
						'xxl'		=> array('max' => 1679),
						'xl'		=> array('max' => 1439),
						'lg'		=> array('max' => 1279),
						'md'		=> array('max' => 1023),
						'sm'		=> array('max' =>  767),
						'sm_wp'		=> array('max' =>  600),
						'xs'		=> array('max' =>  479)
						)
);

if ( ! function_exists( 'anubia_theme_required_plugins' ) ) {

	add_action( 'after_setup_theme', 'anubia_theme_required_plugins', -1 );
	/**
	 * Create the list of required plugins for the skin/theme.
	 * Priority -1 is used to create the list of plugins before the rest skin/theme actions.
	 * 
	 * @hooked 'after_setup_theme', -1
	 */
	function anubia_theme_required_plugins() {
		$anubia_required_plugins     = array(

			// List of plugins for both - FREE and PREMIUM versions
			//-----------------------------------------------------
			
				// Required plugins
				// DON'T COMMENT OR REMOVE NEXT LINES!
				'trx_addons'       => esc_html__( 'ThemeREX Addons', 'anubia' ),

				// Recommended (supported) plugins for both (lite and full) versions
				// If plugin not need - comment (or remove) it
				'contact-form-7'				=> esc_html__('Contact Form 7', 'anubia'),
				'date-time-picker-field'	=> esc_html__('Date & Time Picker', 'anubia'),
				'trx_updater'					=> esc_html__('ThemeREX Updater', 'anubia'),
				'woocommerce'					=> esc_html__('WooCommerce', 'anubia'),
				// Recommended (supported) plugins for the PRO (full) version
				// If plugin not need - comment (or remove) it
				'essential-grid'			=> esc_html__('Essential Grid', 'anubia'),
				'revslider'					=> esc_html__('Revolution Slider', 'anubia'),
				'the-events-calendar'	=> esc_html__('The Events Calendar', 'anubia'),
				'js_composer'				=> esc_html__('WPBakery Page Builder', 'anubia')

		);
		// List of plugins for the FREE version only
		//-----------------------------------------------------
		if ( ANUBIA_THEME_FREE ) {
			unset( $anubia_required_plugins['essential-grid'] );
			unset( $anubia_required_plugins['revslider'] );
			unset( $anubia_required_plugins['the-events-calendar'] );
			unset( $anubia_required_plugins['js_composer'] );

			$anubia_required_plugins['siteorigin-panels'] = esc_html__('SiteOrigin Panels', 'anubia');
		}
	
		// Add plugins list to the global storage
		anubia_storage_set( 'required_plugins', $anubia_required_plugins );
	}
}

// Theme init priorities:
// Action 'after_setup_theme'
// 1 - register filters to add/remove lists items in the Theme Options
// 2 - create Theme Options
// 3 - add/remove Theme Options elements
// 5 - load Theme Options. Attention! After this step you can use only basic options (not overriden)
// 9 - register other filters (for installer, etc.)
//10 - standard Theme init procedures (not ordered)
// Action 'wp_loaded'
// 1 - detect override mode. Attention! Only after this step you can use overriden options (separate values for the shop, courses, etc.)

if ( !function_exists('anubia_customizer_theme_setup1') ) {
	add_action( 'after_setup_theme', 'anubia_customizer_theme_setup1', 1 );
	function anubia_customizer_theme_setup1() {

		// -----------------------------------------------------------------
		// -- ONLY FOR PROGRAMMERS, NOT FOR CUSTOMER
		// -- Internal theme settings
		// -----------------------------------------------------------------
		anubia_storage_set('settings', array(
			
			'duplicate_options'		=> 'child',		// none  - use separate options for the main and the child-theme
													// child - duplicate theme options from the main theme to the child-theme only
													// both  - sinchronize changes in the theme options between main and child themes

			'customize_refresh'		=> 'auto',		// Refresh method for preview area in the Appearance - Customize:
													// auto - refresh preview area on change each field with Theme Options
													// manual - refresh only obn press button 'Refresh' at the top of Customize frame

			'max_load_fonts'		=> 5,			// Max fonts number to load from Google fonts or from uploaded fonts

			'comment_maxlength'		=> 1000,		// Max length of the message from contact form

			'comment_after_name'	=> true,		// Place 'comment' field before the 'name' and 'email'

			'socials_type'			=> 'icons',		// Type of socials:
													// icons - use font icons to present social networks
													// images - use images from theme's folder trx_addons/css/icons.png

			'icons_type'			=> 'icons',		// Type of other icons:
													// icons - use font icons to present icons
													// images - use images from theme's folder trx_addons/css/icons.png

			'icons_selector'		=> 'internal',	// Icons selector in the shortcodes:
													// vc (default) - standard VC icons selector (very slow and don't support images)
													// internal - internal popup with plugin's or theme's icons list (fast)
			'check_min_version'		=> true,		// Check if exists a .min version of .css and .js and return path to it
													// instead the path to the original file
													// (if debug_mode is off and modification time of the original file < time of the .min file)
			'autoselect_menu'		=> false,		// Show any menu if no menu selected in the location 'main_menu'
													// (for example, the theme is just activated)
			'disable_jquery_ui'		=> false,		// Prevent loading custom jQuery UI libraries in the third-party plugins
		
			'use_mediaelements'		=> true,		// Load script "Media Elements" to play video and audio
			
			'tgmpa_upload'			=> false,		// Allow upload not pre-packaged plugins via TGMPA
			
			'allow_no_image'		=> false		// Allow use image placeholder if no image present in the blog, related posts, post navigation, etc.
		));


		// -----------------------------------------------------------------
		// -- Theme fonts (Google and/or custom fonts)
		// -----------------------------------------------------------------
		
		// Fonts to load when theme start
		// It can be Google fonts or uploaded fonts, placed in the folder /css/font-face/font-name inside the theme folder
		// Attention! Font's folder must have name equal to the font's name, with spaces replaced on the dash '-'
		// For example: font name 'TeX Gyre Termes', folder 'TeX-Gyre-Termes'
		anubia_storage_set('load_fonts', array(
			// Google font
			array(
				'name'	 => 'Overpass',
				'family' => 'sans-serif',
				'styles' => '300,300i,400,600,700,800,900'		// Parameter 'style' used only for the Google fonts
				),
			// Font-face packed with theme
			array(
				'name'   => 'Yeseva One',
				'family' => 'cursive'
				)
		));
		
		// Characters subset for the Google fonts. Available values are: latin,latin-ext,cyrillic,cyrillic-ext,greek,greek-ext,vietnamese
		anubia_storage_set('load_fonts_subset', 'latin,latin-ext');
		
		// Settings of the main tags
		// Attention! Font name in the parameter 'font-family' will be enclosed in the quotes and no spaces after comma!
		// For example:	'font-family' => '"Overpass",sans-serif'	- is correct

		anubia_storage_set('theme_fonts', array(
			'p' => array(
				'title'				=> esc_html__('Main text', 'anubia'),
				'description'		=> esc_html__('Font settings of the main text of the site. Attention! For correct display of the site on mobile devices, use only units "rem", "em" or "ex"', 'anubia'),
				'font-family'		=> '"Overpass",sans-serif',
				'font-size' 		=> '17px',
				'font-weight'		=> '300',
				'font-style'		=> 'normal',
				'line-height'		=> '28px',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '',
				'margin-top'		=> '0em',
				'margin-bottom'		=> '1.65em'
				),
			'h1' => array(
				'title'				=> esc_html__('Heading 1', 'anubia'),
				'font-family'		=> '"Yeseva One",cursive',
				'font-size' 		=> '4.235em',
				'font-weight'		=> '400',
				'font-style'		=> 'normal',
				'line-height'		=> '1.05em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '0px',
				'margin-top'		=> '1.0417em',
				'margin-bottom'		=> '1.6rem'
				),
			'h2' => array(
				'title'				=> esc_html__('Heading 2', 'anubia'),
				'font-family'		=> '"Yeseva One",cursive',
				'font-size' 		=> '3.529em',
				'font-weight'		=> '400',
				'font-style'		=> 'normal',
				'line-height'		=> '1.06em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '0px',
				'margin-top'		=> '6.1rem',
				'margin-bottom'		=> '1.8rem'
				),
			'h3' => array(
				'title'				=> esc_html__('Heading 3', 'anubia'),
				'font-family'		=> '"Yeseva One",cursive',
				'font-size' 		=> '2.824em',
				'font-weight'		=> '400',
				'font-style'		=> 'normal',
				'line-height'		=> '1.2em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '0px',
				'margin-top'		=> '5.5rem',
				'margin-bottom'		=> '1.6rem'
				),
			'h4' => array(
				'title'				=> esc_html__('Heading 4', 'anubia'),
				'font-family'		=> '"Yeseva One",cursive',
				'font-size' 		=> '1.941em',
				'font-weight'		=> '400',
				'font-style'		=> 'normal',
				'line-height'		=> '1.12em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '0px',
				'margin-top'		=> '5.5rem',
				'margin-bottom'		=> '2rem'
				),
			'h5' => array(
				'title'				=> esc_html__('Heading 5', 'anubia'),
				'font-family'		=> '"Overpass",sans-serif',
				'font-size' 		=> '1.412em',
				'font-weight'		=> '800',
				'font-style'		=> 'normal',
				'line-height'		=> '1.2em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '0px',
				'margin-top'		=> '5rem',
				'margin-bottom'		=> '1.25rem'
				),
			'h6' => array(
				'title'				=> esc_html__('Heading 6', 'anubia'),
				'font-family'		=> '"Overpass",sans-serif',
				'font-size' 		=> '1em',
				'font-weight'		=> '800',
				'font-style'		=> 'normal',
				'line-height'		=> '1.34em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '0px',
				'margin-top'		=> '4.35rem',
				'margin-bottom'		=> '1rem'
				),
			'logo' => array(
				'title'				=> esc_html__('Logo text', 'anubia'),
				'description'		=> esc_html__('Font settings of the text case of the logo', 'anubia'),
				'font-family'		=> '"Yeseva One",cursive',
				'font-size' 		=> '2em',
				'font-weight'		=> '400',
				'font-style'		=> 'normal',
				'line-height'		=> '1.25em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '0px'
				),
			'button' => array(
				'title'				=> esc_html__('Buttons', 'anubia'),
				'font-family'		=> '"Overpass",sans-serif',
				'font-size' 		=> '15px',
				'font-weight'		=> '800',
				'font-style'		=> 'normal',
				'line-height'		=> '22px',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '0.5px'
				),
			'input' => array(
				'title'				=> esc_html__('Input fields', 'anubia'),
				'description'		=> esc_html__('Font settings of the input fields, dropdowns and textareas', 'anubia'),
				'font-family'		=> 'inherit',
				'font-size' 		=> '15px',
				'font-weight'		=> '600',
				'font-style'		=> 'normal',
				'line-height'		=> '1.5em',	// Attention! Firefox don't allow line-height less then 1.5em in the select
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '0px'
				),
			'info' => array(
				'title'				=> esc_html__('Post meta', 'anubia'),
				'description'		=> esc_html__('Font settings of the post meta: date, counters, share, etc.', 'anubia'),
				'font-family'		=> 'inherit',
				'font-size' 		=> '15px',
				'font-weight'		=> '800',
				'font-style'		=> 'normal',
				'line-height'		=> '1.5em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '0px',
				'margin-top'		=> '0.4em',
				'margin-bottom'		=> ''
				),
			'menu' => array(
				'title'				=> esc_html__('Main menu', 'anubia'),
				'description'		=> esc_html__('Font settings of the main menu items', 'anubia'),
				'font-family'		=> '"Overpass",sans-serif',
				'font-size' 		=> '18px',
				'font-weight'		=> '600',
				'font-style'		=> 'normal',
				'line-height'		=> '1.5em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '0.9px'
				),
			'submenu' => array(
				'title'				=> esc_html__('Dropdown menu', 'anubia'),
				'description'		=> esc_html__('Font settings of the dropdown menu items', 'anubia'),
				'font-family'		=> '"Overpass",sans-serif',
				'font-size' 		=> '18px',
				'font-weight'		=> '600',
				'font-style'		=> 'normal',
				'line-height'		=> '1.5em',
				'text-decoration'	=> 'none',
				'text-transform'	=> 'none',
				'letter-spacing'	=> '0.9px'
				)
		));
		
		
		// -----------------------------------------------------------------
		// -- Theme colors for customizer
		// -- Attention! Inner scheme must be last in the array below
		// -----------------------------------------------------------------
		anubia_storage_set('scheme_color_groups', array(
			'main'	=> array(
							'title'			=> esc_html__('Main', 'anubia'),
							'description'	=> esc_html__('Colors of the main content area', 'anubia')
							),
			'alter'	=> array(
							'title'			=> esc_html__('Alter', 'anubia'),
							'description'	=> esc_html__('Colors of the alternative blocks (sidebars, etc.)', 'anubia')
							),
			'extra'	=> array(
							'title'			=> esc_html__('Extra', 'anubia'),
							'description'	=> esc_html__('Colors of the extra blocks (dropdowns, price blocks, table headers, etc.)', 'anubia')
							),
			'inverse' => array(
							'title'			=> esc_html__('Inverse', 'anubia'),
							'description'	=> esc_html__('Colors of the inverse blocks - when link color used as background of the block (dropdowns, blockquotes, etc.)', 'anubia')
							),
			'input'	=> array(
							'title'			=> esc_html__('Input', 'anubia'),
							'description'	=> esc_html__('Colors of the form fields (text field, textarea, select, etc.)', 'anubia')
							),
			)
		);
		anubia_storage_set('scheme_color_names', array(
			'bg_color'	=> array(
							'title'			=> esc_html__('Background color', 'anubia'),
							'description'	=> esc_html__('Background color of this block in the normal state', 'anubia')
							),
			'bg_hover'	=> array(
							'title'			=> esc_html__('Background hover', 'anubia'),
							'description'	=> esc_html__('Background color of this block in the hovered state', 'anubia')
							),
			'bd_color'	=> array(
							'title'			=> esc_html__('Border color', 'anubia'),
							'description'	=> esc_html__('Border color of this block in the normal state', 'anubia')
							),
			'bd_hover'	=>  array(
							'title'			=> esc_html__('Border hover', 'anubia'),
							'description'	=> esc_html__('Border color of this block in the hovered state', 'anubia')
							),
			'text'		=> array(
							'title'			=> esc_html__('Text', 'anubia'),
							'description'	=> esc_html__('Color of the plain text inside this block', 'anubia')
							),
			'text_dark'	=> array(
							'title'			=> esc_html__('Text dark', 'anubia'),
							'description'	=> esc_html__('Color of the dark text (bold, header, etc.) inside this block', 'anubia')
							),
			'text_light'=> array(
							'title'			=> esc_html__('Text light', 'anubia'),
							'description'	=> esc_html__('Color of the light text (post meta, etc.) inside this block', 'anubia')
							),
			'text_link'	=> array(
							'title'			=> esc_html__('Link', 'anubia'),
							'description'	=> esc_html__('Color of the links inside this block', 'anubia')
							),
			'text_hover'=> array(
							'title'			=> esc_html__('Link hover', 'anubia'),
							'description'	=> esc_html__('Color of the hovered state of links inside this block', 'anubia')
							),
			'text_link2'=> array(
							'title'			=> esc_html__('Link 2', 'anubia'),
							'description'	=> esc_html__('Color of the accented texts (areas) inside this block', 'anubia')
							),
			'text_hover2'=> array(
							'title'			=> esc_html__('Link 2 hover', 'anubia'),
							'description'	=> esc_html__('Color of the hovered state of accented texts (areas) inside this block', 'anubia')
							),
			'text_link3'=> array(
							'title'			=> esc_html__('Link 3', 'anubia'),
							'description'	=> esc_html__('Color of the other accented texts (buttons) inside this block', 'anubia')
							),
			'text_hover3'=> array(
							'title'			=> esc_html__('Link 3 hover', 'anubia'),
							'description'	=> esc_html__('Color of the hovered state of other accented texts (buttons) inside this block', 'anubia')
							)
			)
		);
		anubia_storage_set('schemes', array(
		
			// Color scheme: 'default'
			'default' => array(
				'title'	 => esc_html__('Default', 'anubia'),
				'colors' => array(
					
					// Whole block border and background
					'bg_color'			=> '#ffffff',
					'bd_color'			=> '#d2d3d3',
		
					// Text and links colors
					'text'				=> '#797772',
					'text_light'		=> '#8f8f90',
					'text_dark'			=> '#1e2225',
					'text_link'			=> '#ed5034',
					'text_hover'		=> '#fe7259',
					'text_link2'		=> '#d94c33',
					'text_hover2'		=> '#8be77c',
					'text_link3'		=> '#ddb837',
					'text_hover3'		=> '#eec432',
		
					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'	=> '#fff3e8',
					'alter_bg_hover'	=> '#f7e5d8',
					'alter_bd_color'	=> '#fed8cb',
					'alter_bd_hover'	=> '#fed6ca',
					'alter_text'		=> '#333333',
					'alter_light'		=> '#615c5b',
					'alter_dark'		=> '#1d1d1d',
					'alter_link'		=> '#fe7259',
					'alter_hover'		=> '#72cfd5',
					'alter_link2'		=> '#8be77c',
					'alter_hover2'		=> '#80d572',
					'alter_link3'		=> '#eec432',
					'alter_hover3'		=> '#ddb837',
		
					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'	=> '#1e2225',
					'extra_bg_hover'	=> '#28272e',
					'extra_bd_color'	=> '#353a3d',
					'extra_bd_hover'	=> '#3d3d3d',
					'extra_text'		=> '#ffffff',
					'extra_light'		=> '#fff2e7',
					'extra_dark'		=> '#ffffff',
					'extra_link'		=> '#72cfd5',
					'extra_hover'		=> '#d0472e',
					'extra_link2'		=> '#80d572',
					'extra_hover2'		=> '#8be77c',
					'extra_link3'		=> '#ddb837',
					'extra_hover3'		=> '#eec432',
		
					// Input fields (form's fields and textarea)
					'input_bg_color'	=> '#f7e5d7',
					'input_bg_hover'	=> '#f7e5d7',
					'input_bd_color'	=> '#fed7cc',
					'input_bd_hover'	=> '#1e2225',
					'input_text'		=> '#797772',
					'input_light'		=> '#797772',
					'input_dark'		=> '#1e2225',
					
					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color'	=> '#67bcc1',
					'inverse_bd_hover'	=> '#5aa4a9',
					'inverse_text'		=> '#1e2225',
					'inverse_light'		=> '#333333',
					'inverse_dark'		=> '#000000',
					'inverse_link'		=> '#ffffff',
					'inverse_hover'		=> '#1d1d1d'
				)
			),
		
			// Color scheme: 'dark'
			'dark' => array(
				'title'  => esc_html__('Dark', 'anubia'),
				'colors' => array(
					
					// Whole block border and background
					'bg_color'			=> '#1e2225',
					'bd_color'			=> '#2e2c33',
		
					// Text and links colors
					'text'				=> '#8f8f90',
					'text_light'		=> '#5f5f5f',
					'text_dark'			=> '#ffffff',
					'text_link'			=> '#ed5034',
					'text_hover'		=> '#ed5034',
					'text_link2'		=> '#80d572',
					'text_hover2'		=> '#8be77c',
					'text_link3'		=> '#ddb837',
					'text_hover3'		=> '#eec432',

					// Alternative blocks (sidebar, tabs, alternative blocks, etc.)
					'alter_bg_color'	=> '#1e1d22',
					'alter_bg_hover'	=> '#333333',
					'alter_bd_color'	=> '#464646',
					'alter_bd_hover'	=> '#4a4a4a',
					'alter_text'		=> '#a6a6a6',
					'alter_light'		=> '#5f5f5f',
					'alter_dark'		=> '#ffffff',
					'alter_link'		=> '#ed5034',
					'alter_hover'		=> '#fe7259',
					'alter_link2'		=> '#8be77c',
					'alter_hover2'		=> '#80d572',
					'alter_link3'		=> '#eec432',
					'alter_hover3'		=> '#ddb837',

					// Extra blocks (submenu, tabs, color blocks, etc.)
					'extra_bg_color'	=> '#1e1d22',
					'extra_bg_hover'	=> '#28272e',
					'extra_bd_color'	=> '#464646',
					'extra_bd_hover'	=> '#4a4a4a',
					'extra_text'		=> '#a6a6a6',
					'extra_light'		=> '#5f5f5f',
					'extra_dark'		=> '#ffffff',
					'extra_link'		=> '#ed5034',
					'extra_hover'		=> '#d0472e',
					'extra_link2'		=> '#80d572',
					'extra_hover2'		=> '#8be77c',
					'extra_link3'		=> '#ddb837',
					'extra_hover3'		=> '#eec432',

					// Input fields (form's fields and textarea)
					'input_bg_color'	=> '#3b2f2e',
					'input_bg_hover'	=> '#3b2f2e',
					'input_bd_color'	=> '#434445',
					'input_bd_hover'	=> '#ffffff',
					'input_text'		=> '#8f8f90',
					'input_light'		=> '#8f8f90',
					'input_dark'		=> '#ffffff',
					
					// Inverse blocks (text and links on the 'text_link' background)
					'inverse_bd_color'	=> '#e36650',
					'inverse_bd_hover'	=> '#cb5b47',
					'inverse_text'		=> '#1e2225',
					'inverse_light'		=> '#5f5f5f',
					'inverse_dark'		=> '#000000',
					'inverse_link'		=> '#ffffff',
					'inverse_hover'		=> '#1d1d1d'
				)
			)
		
		));
		
		// Simple schemes substitution
		anubia_storage_set('schemes_simple', array(
			// Main color	// Slave elements and it's darkness koef.
			'text_link'		=> array('alter_hover' => 1,	'extra_link' => 1, 'inverse_bd_color' => 0.85, 'inverse_bd_hover' => 0.7),
			'text_hover'	=> array('alter_link' => 1,		'extra_hover' => 1),
			'text_link2'	=> array('alter_hover2' => 1,	'extra_link2' => 1),
			'text_hover2'	=> array('alter_link2' => 1,	'extra_hover2' => 1),
			'text_link3'	=> array('alter_hover3' => 1,	'extra_link3' => 1),
			'text_hover3'	=> array('alter_link3' => 1,	'extra_hover3' => 1)
		));

		// Additional colors for each scheme
		// Parameters:	'color' - name of the color from the scheme that should be used as source for the transformation
		//				'alpha' - to make color transparent (0.0 - 1.0)
		//				'hue', 'saturation', 'brightness' - inc/dec value for each color's component
		anubia_storage_set('scheme_colors_add', array(
			'bg_color_0'		=> array('color' => 'bg_color',			'alpha' => 0),
			'bg_color_02'		=> array('color' => 'bg_color',			'alpha' => 0.2),
			'bg_color_07'		=> array('color' => 'bg_color',			'alpha' => 0.7),
			'bg_color_08'		=> array('color' => 'bg_color',			'alpha' => 0.8),
			'bg_color_09'		=> array('color' => 'bg_color',			'alpha' => 0.9),
			'alter_bg_color_07'	=> array('color' => 'alter_bg_color',	'alpha' => 0.7),
			'alter_bg_color_04'	=> array('color' => 'alter_bg_color',	'alpha' => 0.4),
			'alter_bg_color_02'	=> array('color' => 'alter_bg_color',	'alpha' => 0.2),
			'alter_bd_color_02'	=> array('color' => 'alter_bd_color',	'alpha' => 0.2),
			'alter_link_02'		=> array('color' => 'alter_link',		'alpha' => 0.2),
			'alter_link_07'		=> array('color' => 'alter_link',		'alpha' => 0.7),
			'extra_bg_color_07'	=> array('color' => 'extra_bg_color',	'alpha' => 0.7),
			'extra_link_02'		=> array('color' => 'extra_link',		'alpha' => 0.2),
			'extra_link_07'		=> array('color' => 'extra_link',		'alpha' => 0.7),
			'text_dark_02'		=> array('color' => 'text_dark',		'alpha' => 0.2),
			'text_dark_03'		=> array('color' => 'text_dark',		'alpha' => 0.3),
			'text_dark_07'		=> array('color' => 'text_dark',		'alpha' => 0.7),
			'text_link_02'		=> array('color' => 'text_link',		'alpha' => 0.2),
			'text_link_07'		=> array('color' => 'text_link',		'alpha' => 0.7),
			'inverse_link_02'		=> array('color' => 'inverse_link',		'alpha' => 0.2),
			'inverse_link_05'		=> array('color' => 'inverse_link',		'alpha' => 0.5),
			'text_link_blend'	=> array('color' => 'text_link',		'hue' => 2, 'saturation' => -5, 'brightness' => 5),
			'alter_link_blend'	=> array('color' => 'alter_link',		'hue' => 2, 'saturation' => -5, 'brightness' => 5)
		));
		
		
		// -----------------------------------------------------------------
		// -- Theme specific thumb sizes
		// -----------------------------------------------------------------
		anubia_storage_set('theme_thumbs', apply_filters('anubia_filter_add_thumb_sizes', array(
			'anubia-thumb-huge'		=> array(
												'size'	=> array(1170, 658, true),
												'title' => esc_html__( 'Huge image', 'anubia' ),
												'subst'	=> 'trx_addons-thumb-huge'
												),
			'anubia-thumb-big' 		=> array(
												'size'	=> array( 770, 443, true),
												'title' => esc_html__( 'Large image', 'anubia' ),
												'subst'	=> 'trx_addons-thumb-big'
												),

			'anubia-thumb-med' 		=> array(
												'size'	=> array( 370, 208, true),
												'title' => esc_html__( 'Medium image', 'anubia' ),
												'subst'	=> 'trx_addons-thumb-medium'
												),
                'anubia-thumb-posts' 		=> array(
                    'size'	=> array( 230, 124, true),
                    'title' => esc_html__( 'Posts image', 'anubia' ),
                    'subst'	=> 'trx_addons-thumb-posts'
                ),
                'anubia-thumb-events' 		=> array(
                    'size'	=> array( 570, 328, true),
                    'title' => esc_html__( 'Events image', 'anubia' ),
                    'subst'	=> 'trx_addons-thumb-events'
                ),

			'anubia-thumb-tiny' 		=> array(
												'size'	=> array(  90,  90, true),
												'title' => esc_html__( 'Small square avatar', 'anubia' ),
												'subst'	=> 'trx_addons-thumb-tiny'
												),

			'anubia-thumb-masonry-big' => array(
												'size'	=> array( 760,   0, false),		// Only downscale, not crop
												'title' => esc_html__( 'Masonry Large (scaled)', 'anubia' ),
												'subst'	=> 'trx_addons-thumb-masonry-big'
												),

			'anubia-thumb-masonry'		=> array(
												'size'	=> array( 370,   0, false),		// Only downscale, not crop
												'title' => esc_html__( 'Masonry (scaled)', 'anubia' ),
												'subst'	=> 'trx_addons-thumb-masonry'
												)
			))
		);
	}
}



//------------------------------------------------------------------------
// One-click import support
//------------------------------------------------------------------------

// Set theme specific importer options
if ( !function_exists( 'anubia_importer_set_options' ) ) {
	add_filter( 'trx_addons_filter_importer_options', 'anubia_importer_set_options', 9 );
	function anubia_importer_set_options($options=array()) {
		if (is_array($options)) {
			// Save or not installer's messages to the log-file
			$options['debug'] = false;
			// Prepare demo data
			$options['demo_url'] = esc_url(anubia_get_protocol() . '://demofiles.ancorathemes.com/anubia/');
			// Required plugins
			$options['required_plugins'] = array_keys(anubia_storage_get('required_plugins'));
			// Set number of thumbnails to regenerate when its imported (if demo data was zipped without cropped images)
			// Set 0 to prevent regenerate thumbnails (if demo data archive is already contain cropped images)
			$options['regenerate_thumbnails'] = 3;
			// Default demo
			$options['files']['default']['title'] = esc_html__('Anubia Demo', 'anubia');
			$options['files']['default']['domain_dev'] = '';		// Developers domain
			$options['files']['default']['domain_demo']= esc_url(anubia_get_protocol() . '://anubia.ancorathemes.com');		// Demo-site domain

			// Banners
			$options['banners'] = array(
				array(
					'image' => anubia_get_file_url('theme-specific/theme-about/images/frontpage.png'),
					'title' => esc_html__('Front Page Builder', 'anubia'),
					'content' => wp_kses(__("Create your front page right in the WordPress Customizer. There's no need in WPBakery Page Builder, or any other builder. Simply enable/disable sections, fill them out with content, and customize to your liking.", 'anubia'), 'anubia_kses_content' ),
					'link_url' => esc_url('//www.youtube.com/watch?v=VT0AUbMl_KA'),
					'link_caption' => esc_html__('Watch Video Introduction', 'anubia'),
					'duration' => 20
					),
				array(
					'image' => anubia_get_file_url('theme-specific/theme-about/images/layouts.png'),
					'title' => esc_html__('Layouts Builder', 'anubia'),
					'content' => wp_kses(__('Use Layouts Bulder to create and customize header and footer styles for your website. With a flexible page builder interface and custom shortcodes, you can create as many header and footer layouts as you want with ease.', 'anubia'), 'anubia_kses_content' ),
					'link_url' => esc_url('//www.youtube.com/watch?v=pYhdFVLd7y4'),
					'link_caption' => esc_html__('Learn More', 'anubia'),
					'duration' => 20
					),
				array(
					'image' => anubia_get_file_url('theme-specific/theme-about/images/documentation.png'),
					'title' => esc_html__('Read full documentation', 'anubia'),
					'content' => wp_kses(__('Need more details? Please check our full online documentation for detailed information on how to use Anubia', 'anubia'), 'anubia_kses_content' ),
					'link_url' => esc_url(anubia_storage_get('theme_doc_url')),
					'link_caption' => esc_html__('Online documentation', 'anubia'),
					'duration' => 15
					),
				array(
					'image' => anubia_get_file_url('theme-specific/theme-about/images/video-tutorials.png'),
					'title' => esc_html__('Video tutorials', 'anubia'),
					'content' => wp_kses(__('No time for reading documentation? Check out our video tutorials and learn how to customize Anubia in detail.', 'anubia'), 'anubia_kses_content' ),
					'link_url' => esc_url(anubia_storage_get('theme_video_url')),
					'link_caption' => esc_html__('Video tutorials', 'anubia'),
					'duration' => 15
					),
				array(
					'image' => anubia_get_file_url('theme-specific/theme-about/images/studio.png'),
					'title' => esc_html__('Website Customization', 'anubia'),
					'content' => wp_kses(__("Need a website fast? Order our custom service, and we'll build a website based on this theme for a very fair price. We can also implement additional functionality such as website translation, setting up WPML, and many more.", 'anubia'), 'anubia_kses_content' ),
					'link_url' => esc_url('//themerex.net/offers/?utm_source=offers&utm_medium=click&utm_campaign=themedash'),
					'link_caption' => esc_html__('Contact Us', 'anubia'),
					'duration' => 25
					)
				);
		}
		return $options;
	}
}




// -----------------------------------------------------------------
// -- Theme options for customizer
// -----------------------------------------------------------------
if (!function_exists('anubia_create_theme_options')) {

	function anubia_create_theme_options() {

		// Message about options override. 
		// Attention! Not need esc_html() here, because this message put in wp_kses_data() below
		$msg_override = sprintf(esc_html__('%s Attention! %s Some of these options can be overridden in the following sections (Blog, Plugins settings, etc.) or in the settings of individual pages', 'anubia'), '<b>','</b>');

		anubia_storage_set('options', array(
		
			// 'Logo & Site Identity'
			'title_tagline' => array(
				"title" => esc_html__('Logo & Site Identity', 'anubia'),
				"desc" => '',
				"priority" => 10,
				"type" => "section"
				),
			'logo_info' => array(
				"title" => esc_html__('Logo in the header', 'anubia'),
				"desc" => '',
				"priority" => 20,
				"type" => "info",
				),
			'logo_text' => array(
				"title" => esc_html__('Use Site Name as Logo', 'anubia'),
				"desc" => wp_kses_data( __('Use the site title and tagline as a text logo if no image is selected', 'anubia') ),
				"class" => "anubia_column-1_2 anubia_new_row",
				"priority" => 30,
				"std" => 1,
				"type" => ANUBIA_THEME_FREE ? "hidden" : "checkbox"
				),
			'logo_retina_enabled' => array(
				"title" => esc_html__('Allow retina display logo', 'anubia'),
				"desc" => wp_kses_data( __('Show fields to select logo images for Retina display', 'anubia') ),
				"class" => "anubia_column-1_2",
				"priority" => 40,
				"refresh" => false,
				"std" => 0,
				"type" => ANUBIA_THEME_FREE ? "hidden" : "checkbox"
				),
			'logo_zoom' => array(
				"title" => esc_html__('Logo zoom', 'anubia'),
				"desc" => wp_kses_data( __("Zoom the logo. 1 - original size. Maximum size of logo depends on the actual size of the picture", 'anubia') ),
				"std" => 1,
				"min" => 0.2,
				"max" => 2,
				"step" => 0.1,
				"refresh" => false,
				"type" => ANUBIA_THEME_FREE ? "hidden" : "slider"
				),
			// Parameter 'logo' was replaced with standard WordPress 'custom_logo'
			'logo_retina' => array(
				"title" => esc_html__('Logo for Retina', 'anubia'),
				"desc" => wp_kses_data( __('Select or upload site logo used on Retina displays (if empty - use default logo from the field above)', 'anubia') ),
				"class" => "anubia_column-1_2",
				"priority" => 70,
				"dependency" => array(
					'logo_retina_enabled' => array(1)
				),
				"std" => '',
				"type" => ANUBIA_THEME_FREE ? "hidden" : "image"
				),
			'logo_mobile_header' => array(
				"title" => esc_html__('Logo for the mobile header', 'anubia'),
				"desc" => wp_kses_data( __('Select or upload site logo to display it in the mobile header (if enabled in the section "Header - Header mobile"', 'anubia') ),
				"class" => "anubia_column-1_2 anubia_new_row",
				"std" => '',
				"type" => "image"
				),
			'logo_mobile_header_retina' => array(
				"title" => esc_html__('Logo for the mobile header for Retina', 'anubia'),
				"desc" => wp_kses_data( __('Select or upload site logo used on Retina displays (if empty - use default logo from the field above)', 'anubia') ),
				"class" => "anubia_column-1_2",
				"dependency" => array(
					'logo_retina_enabled' => array(1)
				),
				"std" => '',
				"type" => ANUBIA_THEME_FREE ? "hidden" : "image"
				),
			'logo_mobile' => array(
				"title" => esc_html__('Logo mobile', 'anubia'),
				"desc" => wp_kses_data( __('Select or upload site logo to display it in the mobile menu', 'anubia') ),
				"class" => "anubia_column-1_2 anubia_new_row",
				"std" => '',
				"type" => "image"
				),
			'logo_mobile_retina' => array(
				"title" => esc_html__('Logo mobile for Retina', 'anubia'),
				"desc" => wp_kses_data( __('Select or upload site logo used on Retina displays (if empty - use default logo from the field above)', 'anubia') ),
				"class" => "anubia_column-1_2",
				"dependency" => array(
					'logo_retina_enabled' => array(1)
				),
				"std" => '',
				"type" => ANUBIA_THEME_FREE ? "hidden" : "image"
				),
			'logo_side' => array(
				"title" => esc_html__('Logo side', 'anubia'),
				"desc" => wp_kses_data( __('Select or upload site logo (with vertical orientation) to display it in the side menu', 'anubia') ),
				"class" => "anubia_column-1_2 anubia_new_row",
				"std" => '',
				"type" => "image"
				),
			'logo_side_retina' => array(
				"title" => esc_html__('Logo side for Retina', 'anubia'),
				"desc" => wp_kses_data( __('Select or upload site logo (with vertical orientation) to display it in the side menu on Retina displays (if empty - use default logo from the field above)', 'anubia') ),
				"class" => "anubia_column-1_2",
				"dependency" => array(
					'logo_retina_enabled' => array(1)
				),
				"std" => '',
				"type" => ANUBIA_THEME_FREE ? "hidden" : "image"
				),
			
		
		
			// 'General settings'
			'general' => array(
				"title" => esc_html__('General Settings', 'anubia'),
				"desc" => wp_kses_data( $msg_override ),
				"priority" => 20,
				"type" => "section",
				),

			'general_layout_info' => array(
				"title" => esc_html__('Layout', 'anubia'),
				"desc" => '',
				"type" => "info",
				),
			'body_style' => array(
				"title" => esc_html__('Body style', 'anubia'),
				"desc" => wp_kses_data( __('Select width of the body content', 'anubia') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Content', 'anubia')
				),
				"refresh" => false,
				"std" => 'wide',
				"options" => anubia_get_list_body_styles(),
				"type" => "select"
				),
			'boxed_bg_image' => array(
				"title" => esc_html__('Boxed bg image', 'anubia'),
				"desc" => wp_kses_data( __('Select or upload image, used as background in the boxed body', 'anubia') ),
				"dependency" => array(
					'body_style' => array('boxed')
				),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Content', 'anubia')
				),
				"std" => '',
				"hidden" => true,
				"type" => "image"
				),
			'remove_margins' => array(
				"title" => esc_html__('Remove margins', 'anubia'),
				"desc" => wp_kses_data( __('Remove margins above and below the content area', 'anubia') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Content', 'anubia')
				),
				"refresh" => false,
				"std" => 0,
				"type" => "checkbox"
				),

			'general_sidebar_info' => array(
				"title" => esc_html__('Sidebar', 'anubia'),
				"desc" => '',
				"type" => "info",
				),
			'sidebar_position' => array(
				"title" => esc_html__('Sidebar position', 'anubia'),
				"desc" => wp_kses_data( __('Select position to show sidebar', 'anubia') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Widgets', 'anubia')
				),
				"std" => 'right',
				"options" => array(),
				"type" => "switch"
				),
			'sidebar_widgets' => array(
				"title" => esc_html__('Sidebar widgets', 'anubia'),
				"desc" => wp_kses_data( __('Select default widgets to show in the sidebar', 'anubia') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Widgets', 'anubia')
				),
				"dependency" => array(
					'sidebar_position' => array('left', 'right')
				),
				"std" => 'sidebar_widgets',
				"options" => array(),
				"type" => "select"
				),
			'expand_content' => array(
				"title" => esc_html__('Expand content', 'anubia'),
				"desc" => wp_kses_data( __('Expand the content width if the sidebar is hidden', 'anubia') ),
				"refresh" => false,
				"std" => 1,
				"type" => "checkbox"
				),


			'general_widgets_info' => array(
				"title" => esc_html__('Additional widgets', 'anubia'),
				"desc" => '',
				"type" => ANUBIA_THEME_FREE ? "hidden" : "info",
				),
			'widgets_above_page' => array(
				"title" => esc_html__('Widgets at the top of the page', 'anubia'),
				"desc" => wp_kses_data( __('Select widgets to show at the top of the page (above content and sidebar)', 'anubia') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Widgets', 'anubia')
				),
				"std" => 'hide',
				"options" => array(),
				"type" => ANUBIA_THEME_FREE ? "hidden" : "select"
				),
			'widgets_above_content' => array(
				"title" => esc_html__('Widgets above the content', 'anubia'),
				"desc" => wp_kses_data( __('Select widgets to show at the beginning of the content area', 'anubia') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Widgets', 'anubia')
				),
				"std" => 'hide',
				"options" => array(),
				"type" => ANUBIA_THEME_FREE ? "hidden" : "select"
				),
			'widgets_below_content' => array(
				"title" => esc_html__('Widgets below the content', 'anubia'),
				"desc" => wp_kses_data( __('Select widgets to show at the ending of the content area', 'anubia') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Widgets', 'anubia')
				),
				"std" => 'hide',
				"options" => array(),
				"type" => ANUBIA_THEME_FREE ? "hidden" : "select"
				),
			'widgets_below_page' => array(
				"title" => esc_html__('Widgets at the bottom of the page', 'anubia'),
				"desc" => wp_kses_data( __('Select widgets to show at the bottom of the page (below content and sidebar)', 'anubia') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Widgets', 'anubia')
				),
				"std" => 'hide',
				"options" => array(),
				"type" => ANUBIA_THEME_FREE ? "hidden" : "select"
				),

			'general_effects_info' => array(
				"title" => esc_html__('Design & Effects', 'anubia'),
				"desc" => '',
				"type" => "info",
				),
			'border_radius' => array(
				"title" => esc_html__('Border radius', 'anubia'),
				"desc" => wp_kses_data( __('Specify the border radius of the form fields and buttons in pixels or other valid CSS units', 'anubia') ),
				"std" => 0,
				"type" => "text"
				),

			'general_misc_info' => array(
				"title" => esc_html__('Miscellaneous', 'anubia'),
				"desc" => '',
				"type" => ANUBIA_THEME_FREE ? "hidden" : "info",
				),
			'seo_snippets' => array(
				"title" => esc_html__('SEO snippets', 'anubia'),
				"desc" => wp_kses_data( __('Add structured data markup to the single posts and pages', 'anubia') ),
				"std" => 0,
				"type" => ANUBIA_THEME_FREE ? "hidden" : "checkbox"
				),
            'privacy_text' => array(
                "title" => esc_html__("Text with Privacy Policy link", 'anubia'),
                "desc"  => wp_kses_data( __("Specify text with Privacy Policy link for the checkbox 'I agree ...'", 'anubia') ),
                "std"   => wp_kses( __( 'I agree that my submitted data is being collected and stored.', 'anubia'), 'anubia_kses_content' ),
                "type"  => "text"
            ),
		
		
			// 'Header'
			'header' => array(
				"title" => esc_html__('Header', 'anubia'),
				"desc" => wp_kses_data( $msg_override ),
				"priority" => 30,
				"type" => "section"
				),

			'header_style_info' => array(
				"title" => esc_html__('Header style', 'anubia'),
				"desc" => '',
				"type" => "info"
				),
			'header_type' => array(
				"title" => esc_html__('Header style', 'anubia'),
				"desc" => wp_kses_data( __('Choose whether to use the default header or header Layouts (available only if the ThemeREX Addons is activated)', 'anubia') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Header', 'anubia')
				),
				"std" => 'default',
				"options" => anubia_get_list_header_footer_types(),
				"type" => ANUBIA_THEME_FREE || !anubia_exists_trx_addons() ? "hidden" : "switch"
				),
			'header_style' => array(
				"title" => esc_html__('Select custom layout', 'anubia'),
				"desc" => wp_kses( __("Select custom header from Layouts Builder", 'anubia'), 'anubia_kses_content' ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Header', 'anubia')
				),
				"dependency" => array(
					'header_type' => array('custom')
				),
				"std" => ANUBIA_THEME_FREE ? 'header-default' : 'header-default',
				"options" => array(),
				"type" => "select"
				),
			'header_position' => array(
				"title" => esc_html__('Header position', 'anubia'),
				"desc" => wp_kses_data( __('Select position to display the site header', 'anubia') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Header', 'anubia')
				),
				"std" => 'default',
				"options" => array(),
				"type" => ANUBIA_THEME_FREE ? "hidden" : "switch"
				),
			'header_fullheight' => array(
				"title" => esc_html__('Header fullheight', 'anubia'),
				"desc" => wp_kses_data( __("Enlarge header area to fill whole screen. Used only if header have a background image", 'anubia') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Header', 'anubia')
				),
				"std" => 0,
				"type" => ANUBIA_THEME_FREE ? "hidden" : "checkbox"
				),
			'header_zoom' => array(
				"title" => esc_html__('Header zoom', 'anubia'),
				"desc" => wp_kses_data( __("Zoom the header title. 1 - original size", 'anubia') ),
				"std" => 1,
				"min" => 0.3,
				"max" => 2,
				"step" => 0.1,
				"refresh" => false,
				"type" => ANUBIA_THEME_FREE ? "hidden" : "slider"
				),
			'header_wide' => array(
				"title" => esc_html__('Header fullwidth', 'anubia'),
				"desc" => wp_kses_data( __('Do you want to stretch the header widgets area to the entire window width?', 'anubia') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Header', 'anubia')
				),
				"dependency" => array(
					'header_type' => array('default')
				),
				"std" => 1,
				"type" => ANUBIA_THEME_FREE ? "hidden" : "checkbox"
				),

			'header_widgets_info' => array(
				"title" => esc_html__('Header widgets', 'anubia'),
				"desc" => wp_kses_data( __('Here you can place a widget slider, advertising banners, etc.', 'anubia') ),
				"type" => "info"
				),
			'header_widgets' => array(
				"title" => esc_html__('Header widgets', 'anubia'),
				"desc" => wp_kses_data( __('Select set of widgets to show in the header on each page', 'anubia') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Header', 'anubia'),
					"desc" => wp_kses_data( __('Select set of widgets to show in the header on this page', 'anubia') ),
				),
				"std" => 'hide',
				"options" => array(),
				"type" => "select"
				),
			'header_columns' => array(
				"title" => esc_html__('Header columns', 'anubia'),
				"desc" => wp_kses_data( __('Select number columns to show widgets in the Header. If 0 - autodetect by the widgets count', 'anubia') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Header', 'anubia')
				),
				"dependency" => array(
					'header_type' => array('default'),
					'header_widgets' => array('^hide')
				),
				"std" => 0,
				"options" => anubia_get_list_range(0,6),
				"type" => "select"
				),

			'menu_info' => array(
				"title" => esc_html__('Main menu', 'anubia'),
				"desc" => wp_kses_data( __('Select main menu style, position, color scheme and other parameters', 'anubia') ),
				"type" => ANUBIA_THEME_FREE ? "hidden" : "info"
				),
			'menu_style' => array(
				"title" => esc_html__('Menu position', 'anubia'),
				"desc" => wp_kses_data( __('Select position of the main menu', 'anubia') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Header', 'anubia')
				),
				"std" => 'top',
				"options" => array(
					'top'	=> esc_html__('Top',	'anubia'),
					'left'	=> esc_html__('Left',	'anubia'),
					'right'	=> esc_html__('Right',	'anubia')
				),
				"type" => ANUBIA_THEME_FREE || !anubia_exists_trx_addons() ? "hidden" : "switch"
				),
			'menu_side_stretch' => array(
				"title" => esc_html__('Stretch sidemenu', 'anubia'),
				"desc" => wp_kses_data( __('Stretch sidemenu to window height (if menu items number >= 5)', 'anubia') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Header', 'anubia')
				),
				"dependency" => array(
					'menu_style' => array('left', 'right')
				),
				"std" => 0,
				"type" => ANUBIA_THEME_FREE ? "hidden" : "checkbox"
				),
			'menu_side_icons' => array(
				"title" => esc_html__('Iconed sidemenu', 'anubia'),
				"desc" => wp_kses_data( __('Get icons from anchors and display it in the sidemenu or mark sidemenu items with simple dots', 'anubia') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Header', 'anubia')
				),
				"dependency" => array(
					'menu_style' => array('left', 'right')
				),
				"std" => 1,
				"type" => ANUBIA_THEME_FREE ? "hidden" : "checkbox"
				),
			'menu_mobile_fullscreen' => array(
				"title" => esc_html__('Mobile menu fullscreen', 'anubia'),
				"desc" => wp_kses_data( __('Display mobile and side menus on full screen (if checked) or slide narrow menu from the left or from the right side (if not checked)', 'anubia') ),
				"std" => 1,
				"type" => ANUBIA_THEME_FREE ? "hidden" : "checkbox"
				),

			'header_image_info' => array(
				"title" => esc_html__('Header image', 'anubia'),
				"desc" => '',
				"type" => ANUBIA_THEME_FREE ? "hidden" : "info"
				),
			'header_image_override' => array(
				"title" => esc_html__('Header image override', 'anubia'),
				"desc" => wp_kses_data( __("Allow override the header image with the page's/post's/product's/etc. featured image", 'anubia') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'anubia')
				),
				"std" => 0,
				"type" => ANUBIA_THEME_FREE ? "hidden" : "checkbox"
				),

			'header_mobile_info' => array(
				"title" => esc_html__('Mobile header', 'anubia'),
				"desc" => wp_kses_data( __("Configure the mobile version of the header", 'anubia') ),
				"priority" => 500,
				"dependency" => array(
					'header_type' => array('default')
				),
				"type" => ANUBIA_THEME_FREE ? "hidden" : "info"
				),
			'header_mobile_enabled' => array(
				"title" => esc_html__('Enable the mobile header', 'anubia'),
				"desc" => wp_kses_data( __("Use the mobile version of the header (if checked) or relayout the current header on mobile devices", 'anubia') ),
				"dependency" => array(
					'header_type' => array('default')
				),
				"std" => 0,
				"type" => ANUBIA_THEME_FREE ? "hidden" : "checkbox"
				),
			'header_mobile_additional_info' => array(
				"title" => esc_html__('Additional info', 'anubia'),
				"desc" => wp_kses_data( __('Additional info to show at the top of the mobile header', 'anubia') ),
				"std" => '',
				"dependency" => array(
					'header_type' => array('default'),
					'header_mobile_enabled' => array(1)
				),
				"refresh" => false,
				"teeny" => false,
				"rows" => 20,
				"type" => ANUBIA_THEME_FREE ? "hidden" : "text_editor"
				),
			'header_mobile_hide_info' => array(
				"title" => esc_html__('Hide additional info', 'anubia'),
				"std" => 0,
				"dependency" => array(
					'header_type' => array('default'),
					'header_mobile_enabled' => array(1)
				),
				"type" => ANUBIA_THEME_FREE ? "hidden" : "checkbox"
				),
			'header_mobile_hide_logo' => array(
				"title" => esc_html__('Hide logo', 'anubia'),
				"std" => 0,
				"dependency" => array(
					'header_type' => array('default'),
					'header_mobile_enabled' => array(1)
				),
				"type" => ANUBIA_THEME_FREE ? "hidden" : "checkbox"
				),
			'header_mobile_hide_login' => array(
				"title" => esc_html__('Hide login/logout', 'anubia'),
				"std" => 0,
				"dependency" => array(
					'header_type' => array('default'),
					'header_mobile_enabled' => array(1)
				),
				"type" => ANUBIA_THEME_FREE ? "hidden" : "checkbox"
				),
			'header_mobile_hide_search' => array(
				"title" => esc_html__('Hide search', 'anubia'),
				"std" => 0,
				"dependency" => array(
					'header_type' => array('default'),
					'header_mobile_enabled' => array(1)
				),
				"type" => ANUBIA_THEME_FREE ? "hidden" : "checkbox"
				),
			'header_mobile_hide_cart' => array(
				"title" => esc_html__('Hide cart', 'anubia'),
				"std" => 0,
				"dependency" => array(
					'header_type' => array('default'),
					'header_mobile_enabled' => array(1)
				),
				"type" => ANUBIA_THEME_FREE ? "hidden" : "checkbox"
				),


		
			// 'Footer'
			'footer' => array(
				"title" => esc_html__('Footer', 'anubia'),
				"desc" => wp_kses_data( $msg_override ),
				"priority" => 50,
				"type" => "section"
				),
			'footer_type' => array(
				"title" => esc_html__('Footer style', 'anubia'),
				"desc" => wp_kses_data( __('Choose whether to use the default footer or footer Layouts (available only if the ThemeREX Addons is activated)', 'anubia') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Footer', 'anubia')
				),
				"std" => 'default',
				"options" => anubia_get_list_header_footer_types(),
				"type" => ANUBIA_THEME_FREE || !anubia_exists_trx_addons() ? "hidden" : "switch"
				),
			'footer_style' => array(
				"title" => esc_html__('Select custom layout', 'anubia'),
				"desc" => wp_kses( __("Select custom footer from Layouts Builder", 'anubia'), 'anubia_kses_content' ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Footer', 'anubia')
				),
				"dependency" => array(
					'footer_type' => array('custom')
				),
				"std" => ANUBIA_THEME_FREE ? 'footer-default' : 'footer-default',
				"options" => array(),
				"type" => "select"
				),
			'footer_widgets' => array(
				"title" => esc_html__('Footer widgets', 'anubia'),
				"desc" => wp_kses_data( __('Select set of widgets to show in the footer', 'anubia') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Footer', 'anubia')
				),
				"dependency" => array(
					'footer_type' => array('default')
				),
				"std" => 'footer_widgets',
				"options" => array(),
				"type" => "select"
				),
			'footer_columns' => array(
				"title" => esc_html__('Footer columns', 'anubia'),
				"desc" => wp_kses_data( __('Select number columns to show widgets in the footer. If 0 - autodetect by the widgets count', 'anubia') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Footer', 'anubia')
				),
				"dependency" => array(
					'footer_type' => array('default'),
					'footer_widgets' => array('^hide')
				),
				"std" => 0,
				"options" => anubia_get_list_range(0,6),
				"type" => "select"
				),
			'footer_wide' => array(
				"title" => esc_html__('Footer fullwidth', 'anubia'),
				"desc" => wp_kses_data( __('Do you want to stretch the footer to the entire window width?', 'anubia') ),
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Footer', 'anubia')
				),
				"dependency" => array(
					'footer_type' => array('default')
				),
				"std" => 0,
				"type" => "checkbox"
				),
			'logo_in_footer' => array(
				"title" => esc_html__('Show logo', 'anubia'),
				"desc" => wp_kses_data( __('Show logo in the footer', 'anubia') ),
				'refresh' => false,
				"dependency" => array(
					'footer_type' => array('default')
				),
				"std" => 0,
				"type" => "checkbox"
				),
			'logo_footer' => array(
				"title" => esc_html__('Logo for footer', 'anubia'),
				"desc" => wp_kses_data( __('Select or upload site logo to display it in the footer', 'anubia') ),
				"dependency" => array(
					'footer_type' => array('default'),
					'logo_in_footer' => array(1)
				),
				"std" => '',
				"type" => "image"
				),
			'logo_footer_retina' => array(
				"title" => esc_html__('Logo for footer (Retina)', 'anubia'),
				"desc" => wp_kses_data( __('Select or upload logo for the footer area used on Retina displays (if empty - use default logo from the field above)', 'anubia') ),
				"dependency" => array(
					'footer_type' => array('default'),
					'logo_in_footer' => array(1),
					'logo_retina_enabled' => array(1)
				),
				"std" => '',
				"type" => ANUBIA_THEME_FREE ? "hidden" : "image"
				),
			'socials_in_footer' => array(
				"title" => esc_html__('Show social icons', 'anubia'),
				"desc" => wp_kses_data( __('Show social icons in the footer (under logo or footer widgets)', 'anubia') ),
				"dependency" => array(
					'footer_type' => array('default')
				),
				"std" => 0,
				"type" => !anubia_exists_trx_addons() ? "hidden" : "checkbox"
				),
			'copyright' => array(
				"title" => esc_html__('Copyright', 'anubia'),
				"desc" => wp_kses_data( __('Copyright text in the footer. Use {Y} to insert current year and press "Enter" to create a new line', 'anubia') ),
				"translate" => true,
				"std" => esc_html__('Copyright &copy; {Y} by AncoraThemes. All rights reserved.', 'anubia'),
				"dependency" => array(
					'footer_type' => array('default')
				),
				"refresh" => false,
				"type" => "textarea"
				),
			
		
		
			// 'Blog'
			'blog' => array(
				"title" => esc_html__('Blog', 'anubia'),
				"desc" => wp_kses_data( __('Options of the the blog archive', 'anubia') ),
				"priority" => 70,
				"type" => "panel",
				),
		
				// Blog - Posts page
				'blog_general' => array(
					"title" => esc_html__('Posts page', 'anubia'),
					"desc" => wp_kses_data( __('Style and components of the blog archive', 'anubia') ),
					"type" => "section",
					),
				'blog_general_info' => array(
					"title" => esc_html__('General settings', 'anubia'),
					"desc" => '',
					"type" => "info",
					),
				'blog_style' => array(
					"title" => esc_html__('Blog style', 'anubia'),
					"desc" => '',
					"override" => array(
						'mode' => 'page',
						'section' => esc_html__('Content', 'anubia')
					),
					"dependency" => array(
						'#page_template' => array('blog.php'),
                        '.editor-page-attributes__template select' => array( 'blog.php' ),
					),
					"std" => 'excerpt',
					"options" => array(),
					"type" => "select"
					),
				'first_post_large' => array(
					"title" => esc_html__('First post large', 'anubia'),
					"desc" => wp_kses_data( __('Make your first post stand out by making it bigger', 'anubia') ),
					"override" => array(
						'mode' => 'page',
						'section' => esc_html__('Content', 'anubia')
					),
					"dependency" => array(
						'#page_template' => array('blog.php'),
                        '.editor-page-attributes__template select' => array( 'blog.php' ),
						'blog_style' => array('classic', 'masonry')
					),
					"std" => 0,
					"type" => "checkbox"
					),
				"blog_content" => array( 
					"title" => esc_html__('Posts content', 'anubia'),
					"desc" => wp_kses_data( __("Display either post excerpts or the full post content", 'anubia') ),
					"std" => "excerpt",
					"dependency" => array(
						'blog_style' => array('excerpt')
					),
					"options" => array(
						'excerpt'	=> esc_html__('Excerpt',	'anubia'),
						'fullpost'	=> esc_html__('Full post',	'anubia')
					),
					"type" => "switch"
					),
				'excerpt_length' => array(
					"title" => esc_html__('Excerpt length', 'anubia'),
					"desc" => wp_kses_data( __("Length (in words) to generate excerpt from the post content. Attention! If the post excerpt is explicitly specified - it appears unchanged", 'anubia') ),
					"dependency" => array(
						'blog_style' => array('excerpt'),
						'blog_content' => array('excerpt')
					),
					"std" => 50,
					"type" => "text"
					),
				'blog_columns' => array(
					"title" => esc_html__('Blog columns', 'anubia'),
					"desc" => wp_kses_data( __('How many columns should be used in the blog archive (from 2 to 4)?', 'anubia') ),
					"std" => 2,
					"options" => anubia_get_list_range(2,4),
					"type" => "hidden"
					),
				'post_type' => array(
					"title" => esc_html__('Post type', 'anubia'),
					"desc" => wp_kses_data( __('Select post type to show in the blog archive', 'anubia') ),
					"override" => array(
						'mode' => 'page',
						'section' => esc_html__('Content', 'anubia')
					),
					"dependency" => array(
						'#page_template' => array('blog.php'),
                        '.editor-page-attributes__template select' => array( 'blog.php' ),
					),
					"linked" => 'parent_cat',
					"refresh" => false,
					"hidden" => true,
					"std" => 'post',
					"options" => array(),
					"type" => "select"
					),
				'parent_cat' => array(
					"title" => esc_html__('Category to show', 'anubia'),
					"desc" => wp_kses_data( __('Select category to show in the blog archive', 'anubia') ),
					"override" => array(
						'mode' => 'page',
						'section' => esc_html__('Content', 'anubia')
					),
					"dependency" => array(
						'#page_template' => array('blog.php'),
                        '.editor-page-attributes__template select' => array( 'blog.php' ),
					),
					"refresh" => false,
					"hidden" => true,
					"std" => '0',
					"options" => array(),
					"type" => "select"
					),
				'posts_per_page' => array(
					"title" => esc_html__('Posts per page', 'anubia'),
					"desc" => wp_kses_data( __('How many posts will be displayed on this page', 'anubia') ),
					"override" => array(
						'mode' => 'page',
						'section' => esc_html__('Content', 'anubia')
					),
					"dependency" => array(
						'#page_template' => array('blog.php'),
                        '.editor-page-attributes__template select' => array( 'blog.php' ),
					),
					"hidden" => true,
					"std" => '',
					"type" => "text"
					),
				"blog_pagination" => array( 
					"title" => esc_html__('Pagination style', 'anubia'),
					"desc" => wp_kses_data( __('Show Older/Newest posts or Page numbers below the posts list', 'anubia') ),
					"override" => array(
						'mode' => 'page',
						'section' => esc_html__('Content', 'anubia')
					),
					"std" => "pages",
					"dependency" => array(
						'#page_template' => array('blog.php'),
                        '.editor-page-attributes__template select' => array( 'blog.php' ),
					),
					"options" => array(
						'pages'	=> esc_html__("Page numbers", 'anubia'),
						'links'	=> esc_html__("Older/Newest", 'anubia'),
						'more'	=> esc_html__("Load more", 'anubia'),
						'infinite' => esc_html__("Infinite scroll", 'anubia')
					),
					"type" => "select"
					),
				'show_filters' => array(
					"title" => esc_html__('Show filters', 'anubia'),
					"desc" => wp_kses_data( __('Show categories as tabs to filter posts', 'anubia') ),
					"override" => array(
						'mode' => 'page',
						'section' => esc_html__('Content', 'anubia')
					),
					"dependency" => array(
						'#page_template' => array('blog.php'),
                        '.editor-page-attributes__template select' => array( 'blog.php' ),
						'blog_style' => array('portfolio', 'gallery')
					),
					"hidden" => true,
					"std" => 0,
					"type" => ANUBIA_THEME_FREE ? "hidden" : "checkbox"
					),
	
				'blog_sidebar_info' => array(
					"title" => esc_html__('Sidebar', 'anubia'),
					"desc" => '',
					"type" => "info",
					),
				'sidebar_position_blog' => array(
					"title" => esc_html__('Sidebar position', 'anubia'),
					"desc" => wp_kses_data( __('Select position to show sidebar', 'anubia') ),
					"std" => 'right',
					"options" => array(),
					"type" => "switch"
					),
				'sidebar_widgets_blog' => array(
					"title" => esc_html__('Sidebar widgets', 'anubia'),
					"desc" => wp_kses_data( __('Select default widgets to show in the sidebar', 'anubia') ),
					"dependency" => array(
						'sidebar_position_blog' => array('left', 'right')
					),
					"std" => 'sidebar_widgets',
					"options" => array(),
					"type" => "select"
					),
				'expand_content_blog' => array(
					"title" => esc_html__('Expand content', 'anubia'),
					"desc" => wp_kses_data( __('Expand the content width if the sidebar is hidden', 'anubia') ),
					"refresh" => false,
					"std" => 1,
					"type" => "checkbox"
					),
	
	
				'blog_widgets_info' => array(
					"title" => esc_html__('Additional widgets', 'anubia'),
					"desc" => '',
					"type" => ANUBIA_THEME_FREE ? "hidden" : "info",
					),
				'widgets_above_page_blog' => array(
					"title" => esc_html__('Widgets at the top of the page', 'anubia'),
					"desc" => wp_kses_data( __('Select widgets to show at the top of the page (above content and sidebar)', 'anubia') ),
					"std" => 'hide',
					"options" => array(),
					"type" => ANUBIA_THEME_FREE ? "hidden" : "select"
					),
				'widgets_above_content_blog' => array(
					"title" => esc_html__('Widgets above the content', 'anubia'),
					"desc" => wp_kses_data( __('Select widgets to show at the beginning of the content area', 'anubia') ),
					"std" => 'hide',
					"options" => array(),
					"type" => ANUBIA_THEME_FREE ? "hidden" : "select"
					),
				'widgets_below_content_blog' => array(
					"title" => esc_html__('Widgets below the content', 'anubia'),
					"desc" => wp_kses_data( __('Select widgets to show at the ending of the content area', 'anubia') ),
					"std" => 'hide',
					"options" => array(),
					"type" => ANUBIA_THEME_FREE ? "hidden" : "select"
					),
				'widgets_below_page_blog' => array(
					"title" => esc_html__('Widgets at the bottom of the page', 'anubia'),
					"desc" => wp_kses_data( __('Select widgets to show at the bottom of the page (below content and sidebar)', 'anubia') ),
					"std" => 'hide',
					"options" => array(),
					"type" => ANUBIA_THEME_FREE ? "hidden" : "select"
					),

				'blog_advanced_info' => array(
					"title" => esc_html__('Advanced settings', 'anubia'),
					"desc" => '',
					"type" => "info",
					),
				'no_image' => array(
					"title" => esc_html__('Image placeholder', 'anubia'),
					"desc" => wp_kses_data( __('Select or upload an image used as placeholder for posts without a featured image', 'anubia') ),
					"std" => '',
					"type" => "image"
					),
				'time_diff_before' => array(
					"title" => esc_html__('Easy Readable Date Format', 'anubia'),
					"desc" => wp_kses_data( __("For how many days to show the easy-readable date format (e.g. '3 days ago') instead of the standard publication date", 'anubia') ),
					"std" => 5,
					"type" => "text"
					),
				'sticky_style' => array(
					"title" => esc_html__('Sticky posts style', 'anubia'),
					"desc" => wp_kses_data( __('Select style of the sticky posts output', 'anubia') ),
					"std" => 'inherit',
					"options" => array(
						'inherit' => esc_html__('Decorated posts', 'anubia'),
						'columns' => esc_html__('Mini-cards',	'anubia')
					),
					"type" => ANUBIA_THEME_FREE ? "hidden" : "select"
					),
				"blog_animation" => array( 
					"title" => esc_html__('Animation for the posts', 'anubia'),
					"desc" => wp_kses_data( __('Select animation to show posts in the blog. Attention! Do not use any animation on pages with the "wheel to the anchor" behaviour (like a "Chess 2 columns")!', 'anubia') ),
					"override" => array(
						'mode' => 'page',
						'section' => esc_html__('Content', 'anubia')
					),
					"dependency" => array(
						'#page_template' => array('blog.php'),
                        '.editor-page-attributes__template select' => array( 'blog.php' ),
					),
					"std" => "none",
					"options" => array(),
					"type" => ANUBIA_THEME_FREE ? "hidden" : "select"
					),
				'meta_parts' => array(
					"title" => esc_html__('Post meta', 'anubia'),
					"desc" => wp_kses_data( __("If your blog page is created using the 'Blog archive' page template, set up the 'Post Meta' settings in the 'Theme Options' section of that page. Counters and Share Links are available only if plugin ThemeREX Addons is active", 'anubia') )
								. '<br>'
								. wp_kses_data( __("<b>Tip:</b> Drag items to change their order.", 'anubia') ),
					"override" => array(
						'mode' => 'page',
						'section' => esc_html__('Content', 'anubia')
					),
					"dependency" => array(
						'#page_template' => array('blog.php'),
                        '.editor-page-attributes__template select' => array( 'blog.php' ),
					),
					"dir" => 'vertical',
					"sortable" => true,
					"std" => 'categories=0|date=1|counters=0|author=0|share=0|edit=0',
					"options" => array(
						'categories' => esc_html__('Categories', 'anubia'),
						'date'		 => esc_html__('Post date', 'anubia'),
						'author'	 => esc_html__('Post author', 'anubia'),
						'counters'	 => esc_html__('Views, Likes and Comments', 'anubia'),
						'share'		 => esc_html__('Share links', 'anubia'),
						'edit'		 => esc_html__('Edit link', 'anubia')
					),
					"type" => ANUBIA_THEME_FREE ? "hidden" : "checklist"
				),
				'counters' => array(
					"title" => esc_html__('Views, Likes and Comments', 'anubia'),
					"desc" => wp_kses_data( __("Likes and Views are available only if ThemeREX Addons is active", 'anubia') ),
					"override" => array(
						'mode' => 'page',
						'section' => esc_html__('Content', 'anubia')
					),
					"dependency" => array(
						'#page_template' => array('blog.php'),
                        '.editor-page-attributes__template select' => array( 'blog.php' ),
					),
					"dir" => 'vertical',
					"sortable" => true,
					"std" => 'views=0|likes=0|comments=0',
					"options" => array(
						'views' => esc_html__('Views', 'anubia'),
						'likes' => esc_html__('Likes', 'anubia'),
						'comments' => esc_html__('Comments', 'anubia')
					),
					"type" => ANUBIA_THEME_FREE || !anubia_exists_trx_addons() ? "hidden" : "checklist"
				),

				
				// Blog - Single posts
				'blog_single' => array(
					"title" => esc_html__('Single posts', 'anubia'),
					"desc" => wp_kses_data( __('Settings of the single post', 'anubia') ),
					"type" => "section",
					),
				'hide_featured_on_single' => array(
					"title" => esc_html__('Hide featured image on the single post', 'anubia'),
					"desc" => wp_kses_data( __("Hide featured image on the single post's pages", 'anubia') ),
					"override" => array(
						'mode' => 'page,post',
						'section' => esc_html__('Content', 'anubia')
					),
					"std" => 0,
					"type" => "checkbox"
					),
				'hide_sidebar_on_single' => array(
					"title" => esc_html__('Hide sidebar on the single post', 'anubia'),
					"desc" => wp_kses_data( __("Hide sidebar on the single post's pages", 'anubia') ),
					"std" => 0,
					"type" => "checkbox"
					),
				'show_post_meta' => array(
					"title" => esc_html__('Show post meta', 'anubia'),
					"desc" => wp_kses_data( __("Display block with post's meta: date, categories, counters, etc.", 'anubia') ),
					"std" => 1,
					"type" => "checkbox"
					),
				'meta_parts_post' => array(
					"title" => esc_html__('Post meta', 'anubia'),
					"desc" => wp_kses_data( __("Meta parts for single posts. Counters and Share Links are available only if plugin ThemeREX Addons is active", 'anubia') )
								. '<br>'
								. wp_kses_data( __("<b>Tip:</b> Drag items to change their order.", 'anubia') ),
					"dependency" => array(
						'show_post_meta' => array(1)
					),
					"dir" => 'vertical',
					"sortable" => true,
					"std" => 'categories=0|date=1|counters=0|author=0|share=0|edit=0',
					"options" => array(
						'categories' => esc_html__('Categories', 'anubia'),
						'date'		 => esc_html__('Post date', 'anubia'),
						'author'	 => esc_html__('Post author', 'anubia'),
						'counters'	 => esc_html__('Views, Likes and Comments', 'anubia'),
						'share'		 => esc_html__('Share links', 'anubia'),
						'edit'		 => esc_html__('Edit link', 'anubia')
					),
					"type" => ANUBIA_THEME_FREE ? "hidden" : "checklist"
				),
				'counters_post' => array(
					"title" => esc_html__('Views, Likes and Comments', 'anubia'),
					"desc" => wp_kses_data( __("Likes and Views are available only if plugin ThemeREX Addons is active", 'anubia') ),
					"dependency" => array(
						'show_post_meta' => array(1)
					),
					"dir" => 'vertical',
					"sortable" => true,
					"std" => 'views=0|likes=0|comments=0',
					"options" => array(
						'views' => esc_html__('Views', 'anubia'),
						'likes' => esc_html__('Likes', 'anubia'),
						'comments' => esc_html__('Comments', 'anubia')
					),
					"type" => ANUBIA_THEME_FREE || !anubia_exists_trx_addons() ? "hidden" : "checklist"
				),
				'show_share_links' => array(
					"title" => esc_html__('Show share links', 'anubia'),
					"desc" => wp_kses_data( __("Display share links on the single post", 'anubia') ),
					"std" => 1,
					"type" => !anubia_exists_trx_addons() ? "hidden" : "checkbox"
					),
				'show_author_info' => array(
					"title" => esc_html__('Show author info', 'anubia'),
					"desc" => wp_kses_data( __("Display block with information about post's author", 'anubia') ),
					"std" => 1,
					"type" => "checkbox"
					),
				'blog_single_related_info' => array(
					"title" => esc_html__('Related posts', 'anubia'),
					"desc" => '',
					"type" => "info",
					),
				'show_related_posts' => array(
					"title" => esc_html__('Show related posts', 'anubia'),
					"desc" => wp_kses_data( __("Show section 'Related posts' on the single post's pages", 'anubia') ),
					"override" => array(
						'mode' => 'page,post',
						'section' => esc_html__('Content', 'anubia')
					),
					"std" => 0,
					"type" => "checkbox"
					),
				'related_posts' => array(
					"title" => esc_html__('Related posts', 'anubia'),
					"desc" => wp_kses_data( __('How many related posts should be displayed in the single post? If 0 - no related posts are shown.', 'anubia') ),
					"dependency" => array(
						'show_related_posts' => array(1)
					),
					"std" => 2,
					"options" => anubia_get_list_range(1,9),
					"type" => ANUBIA_THEME_FREE ? "hidden" : "select"
					),
				'related_columns' => array(
					"title" => esc_html__('Related columns', 'anubia'),
					"desc" => wp_kses_data( __('How many columns should be used to output related posts in the single page (from 2 to 4)?', 'anubia') ),
					"dependency" => array(
						'show_related_posts' => array(1)
					),
					"std" => 2,
					"options" => anubia_get_list_range(1,4),
					"type" => ANUBIA_THEME_FREE ? "hidden" : "switch"
					),
				'related_style' => array(
					"title" => esc_html__('Related posts style', 'anubia'),
					"desc" => wp_kses_data( __('Select style of the related posts output', 'anubia') ),
					"dependency" => array(
						'show_related_posts' => array(1)
					),
					"std" => 2,
					"options" => anubia_get_list_styles(1,2),
					"type" => ANUBIA_THEME_FREE ? "hidden" : "switch"
					),
			'blog_end' => array(
				"type" => "panel_end",
				),
			
		
		
			// 'Colors'
			'panel_colors' => array(
				"title" => esc_html__('Colors', 'anubia'),
				"desc" => '',
				"priority" => 300,
				"type" => "section"
				),

			'color_schemes_info' => array(
				"title" => esc_html__('Color schemes', 'anubia'),
				"desc" => wp_kses_data( __('Color schemes for various parts of the site. "Inherit" means that this block is used the Site color scheme (the first parameter)', 'anubia') ),
				"type" => "info",
				),
			'color_scheme' => array(
				"title" => esc_html__('Site Color Scheme', 'anubia'),
				"desc" => '',
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Colors', 'anubia')
				),
				"std" => 'default',
				"options" => array(),
				"refresh" => false,
				"type" => "switch"
				),
			'header_scheme' => array(
				"title" => esc_html__('Header Color Scheme', 'anubia'),
				"desc" => '',
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Colors', 'anubia')
				),
				"std" => 'dark',
				"options" => array(),
				"refresh" => false,
				"type" => "switch"
				),
			'menu_scheme' => array(
				"title" => esc_html__('Sidemenu Color Scheme', 'anubia'),
				"desc" => '',
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Colors', 'anubia')
				),
				"std" => 'inherit',
				"options" => array(),
				"refresh" => false,
				"type" => ANUBIA_THEME_FREE ? "hidden" : "switch"
				),
			'sidebar_scheme' => array(
				"title" => esc_html__('Sidebar Color Scheme', 'anubia'),
				"desc" => '',
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Colors', 'anubia')
				),
				"std" => 'default',
				"options" => array(),
				"refresh" => false,
				"type" => "switch"
				),
			'footer_scheme' => array(
				"title" => esc_html__('Footer Color Scheme', 'anubia'),
				"desc" => '',
				"override" => array(
					'mode' => 'page,cpt_team,cpt_services,cpt_dishes,cpt_competitions,cpt_rounds,cpt_matches,cpt_cars,cpt_properties,cpt_courses,cpt_portfolio',
					'section' => esc_html__('Colors', 'anubia')
				),
				"std" => 'dark',
				"options" => array(),
				"refresh" => false,
				"type" => "switch"
				),

			'color_scheme_editor_info' => array(
				"title" => esc_html__('Color scheme editor', 'anubia'),
				"desc" => wp_kses_data(__('Select color scheme to modify. Attention! Only those sections in the site will be changed which this scheme was assigned to', 'anubia') ),
				"type" => "info",
				),
			'scheme_storage' => array(
				"title" => esc_html__('Color scheme editor', 'anubia'),
				"desc" => '',
				"std" => '$anubia_get_scheme_storage',
				"refresh" => false,
				"colorpicker" => "tiny",
				"type" => "scheme_editor"
				),


			// 'Hidden'
			'media_title' => array(
				"title" => esc_html__('Media title', 'anubia'),
				"desc" => wp_kses_data( __('Used as title for the audio and video item in this post', 'anubia') ),
				"override" => array(
					'mode' => 'post',
					'section' => esc_html__('Content', 'anubia')
				),
				"hidden" => true,
				"std" => '',
				"type" => ANUBIA_THEME_FREE ? "hidden" : "text"
				),
			'media_author' => array(
				"title" => esc_html__('Media author', 'anubia'),
				"desc" => wp_kses_data( __('Used as author name for the audio and video item in this post', 'anubia') ),
				"override" => array(
					'mode' => 'post',
					'section' => esc_html__('Content', 'anubia')
				),
				"hidden" => true,
				"std" => '',
				"type" => ANUBIA_THEME_FREE ? "hidden" : "text"
				),


			// Internal options.
			// Attention! Don't change any options in the section below!
			// Use huge priority to call render this elements after all options!
			'reset_options' => array(
				"title" => '',
				"desc" => '',
				"std" => '0',
				"priority" => 10000,
				"type" => "hidden",
				),

			'last_option' => array(		// Need to manually call action to include Tiny MCE scripts
				"title" => '',
				"desc" => '',
				"std" => 1,
				"type" => "hidden",
				),

		));


		// Prepare panel 'Fonts'
		$fonts = array(
		
			// 'Fonts'
			'fonts' => array(
				"title" => esc_html__('Typography', 'anubia'),
				"desc" => '',
				"priority" => 200,
				"type" => "panel"
				),

			// Fonts - Load_fonts
			'load_fonts' => array(
				"title" => esc_html__('Load fonts', 'anubia'),
				"desc" => wp_kses_data( __('Specify fonts to load when theme start. You can use them in the base theme elements: headers, text, menu, links, input fields, etc.', 'anubia') )
						. '<br>'
						. wp_kses_data( __('<b>Attention!</b> Press "Refresh" button to reload preview area after the all fonts are changed', 'anubia') ),
				"type" => "section"
				),
			'load_fonts_subset' => array(
				"title" => esc_html__('Google fonts subsets', 'anubia'),
				"desc" => wp_kses_data( __('Specify comma separated list of the subsets which will be load from Google fonts', 'anubia') )
						. '<br>'
						. wp_kses_data( __('Available subsets are: latin,latin-ext,cyrillic,cyrillic-ext,greek,greek-ext,vietnamese', 'anubia') ),
				"class" => "anubia_column-1_3 anubia_new_row",
				"refresh" => false,
				"std" => '$anubia_get_load_fonts_subset',
				"type" => "text"
				)
		);

		for ($i=1; $i<=anubia_get_theme_setting('max_load_fonts'); $i++) {
			if (anubia_get_value_gp('page') != 'theme_options') {
				$fonts["load_fonts-{$i}-info"] = array(
					// Translators: Add font's number - 'Font 1', 'Font 2', etc
					"title" => esc_html(sprintf(esc_html__('Font %s', 'anubia'), $i)),
					"desc" => '',
					"type" => "info",
					);
			}
			$fonts["load_fonts-{$i}-name"] = array(
				"title" => esc_html__('Font name', 'anubia'),
				"desc" => '',
				"class" => "anubia_column-1_3 anubia_new_row",
				"refresh" => false,
				"std" => '$anubia_get_load_fonts_option',
				"type" => "text"
				);
			$fonts["load_fonts-{$i}-family"] = array(
				"title" => esc_html__('Font family', 'anubia'),
				"desc" => $i==1 
							? wp_kses_data( __('Select font family to use it if font above is not available', 'anubia') )
							: '',
				"class" => "anubia_column-1_3",
				"refresh" => false,
				"std" => '$anubia_get_load_fonts_option',
				"options" => array(
					'inherit' => esc_html__("Inherit", 'anubia'),
					'serif' => esc_html__('serif', 'anubia'),
					'sans-serif' => esc_html__('sans-serif', 'anubia'),
					'monospace' => esc_html__('monospace', 'anubia'),
					'cursive' => esc_html__('cursive', 'anubia'),
					'fantasy' => esc_html__('fantasy', 'anubia')
				),
				"type" => "select"
				);
			$fonts["load_fonts-{$i}-styles"] = array(
				"title" => esc_html__('Font styles', 'anubia'),
				"desc" => $i==1 
							? wp_kses_data( __('Font styles used only for the Google fonts. This is a comma separated list of the font weight and styles. For example: 400,400italic,700', 'anubia') )
								. '<br>'
								. wp_kses_data( __('<b>Attention!</b> Each weight and style increase download size! Specify only used weights and styles.', 'anubia') )
							: '',
				"class" => "anubia_column-1_3",
				"refresh" => false,
				"std" => '$anubia_get_load_fonts_option',
				"type" => "text"
				);
		}
		$fonts['load_fonts_end'] = array(
			"type" => "section_end"
			);

		// Fonts - H1..6, P, Info, Menu, etc.
		$theme_fonts = anubia_get_theme_fonts();
		foreach ($theme_fonts as $tag=>$v) {
			$fonts["{$tag}_section"] = array(
				"title" => !empty($v['title']) 
								? $v['title'] 
								// Translators: Add tag's name to make title 'H1 settings', 'P settings', etc.
								: esc_html(sprintf(esc_html__('%s settings', 'anubia'), $tag)),
				"desc" => !empty($v['description']) 
								? $v['description'] 
								// Translators: Add tag's name to make description
								: wp_kses( sprintf(__('Font settings of the "%s" tag.', 'anubia'), $tag), 'anubia_kses_content' ),
				"type" => "section",
				);
	
			foreach ($v as $css_prop=>$css_value) {
				if (in_array($css_prop, array('title', 'description'))) continue;
				$options = '';
				$type = 'text';
				$load_order = 1;
				$title = ucfirst(str_replace('-', ' ', $css_prop));
				if ($css_prop == 'font-family') {
					$type = 'select';
					$options = array();
					$load_order = 2;		// Load this option's value after all options are loaded (use option 'load_fonts' to build fonts list)
				} else if ($css_prop == 'font-weight') {
					$type = 'select';
					$options = array(
						'inherit' => esc_html__("Inherit", 'anubia'),
						'100' => esc_html__('100 (Light)', 'anubia'), 
						'200' => esc_html__('200 (Light)', 'anubia'), 
						'300' => esc_html__('300 (Thin)',  'anubia'),
						'400' => esc_html__('400 (Normal)', 'anubia'),
						'500' => esc_html__('500 (Semibold)', 'anubia'),
						'600' => esc_html__('600 (Semibold)', 'anubia'),
						'700' => esc_html__('700 (Bold)', 'anubia'),
						'800' => esc_html__('800 (Black)', 'anubia'),
						'900' => esc_html__('900 (Black)', 'anubia')
					);
				} else if ($css_prop == 'font-style') {
					$type = 'select';
					$options = array(
						'inherit' => esc_html__("Inherit", 'anubia'),
						'normal' => esc_html__('Normal', 'anubia'), 
						'italic' => esc_html__('Italic', 'anubia')
					);
				} else if ($css_prop == 'text-decoration') {
					$type = 'select';
					$options = array(
						'inherit' => esc_html__("Inherit", 'anubia'),
						'none' => esc_html__('None', 'anubia'), 
						'underline' => esc_html__('Underline', 'anubia'),
						'overline' => esc_html__('Overline', 'anubia'),
						'line-through' => esc_html__('Line-through', 'anubia')
					);
				} else if ($css_prop == 'text-transform') {
					$type = 'select';
					$options = array(
						'inherit' => esc_html__("Inherit", 'anubia'),
						'none' => esc_html__('None', 'anubia'), 
						'uppercase' => esc_html__('Uppercase', 'anubia'),
						'lowercase' => esc_html__('Lowercase', 'anubia'),
						'capitalize' => esc_html__('Capitalize', 'anubia')
					);
				}
				$fonts["{$tag}_{$css_prop}"] = array(
					"title" => $title,
					"desc" => '',
					"class" => "anubia_column-1_5",
					"refresh" => false,
					"load_order" => $load_order,
					"std" => '$anubia_get_theme_fonts_option',
					"options" => $options,
					"type" => $type
				);
			}
			
			$fonts["{$tag}_section_end"] = array(
				"type" => "section_end"
				);
		}

		$fonts['fonts_end'] = array(
			"type" => "panel_end"
			);

		// Add fonts parameters to Theme Options
		anubia_storage_set_array_before('options', 'panel_colors', $fonts);

		// Add Header Video if WP version < 4.7
		if (!function_exists('get_header_video_url')) {
			anubia_storage_set_array_after('options', 'header_image_override', 'header_video', array(
				"title" => esc_html__('Header video', 'anubia'),
				"desc" => wp_kses_data( __("Select video to use it as background for the header", 'anubia') ),
				"override" => array(
					'mode' => 'page',
					'section' => esc_html__('Header', 'anubia')
				),
				"std" => '',
				"type" => "video"
				)
			);
		}

		// Add option 'logo' if WP version < 4.5
		// or 'custom_logo' if current page is 'Theme Options'
		if (!function_exists('the_custom_logo') || (isset($_REQUEST['page']) && $_REQUEST['page']=='theme_options')) {
			anubia_storage_set_array_before('options', 'logo_retina', function_exists('the_custom_logo') ? 'custom_logo' : 'logo', array(
				"title" => esc_html__('Logo', 'anubia'),
				"desc" => wp_kses_data( __('Select or upload the site logo', 'anubia') ),
				"class" => "anubia_column-1_2 anubia_new_row",
				"priority" => 60,
				"std" => '',
				"type" => "image"
				)
			);
		}
	}
}


// Returns a list of options that can be overridden for CPT
if (!function_exists('anubia_options_get_list_cpt_options')) {
	function anubia_options_get_list_cpt_options($cpt, $title='') {
		if (empty($title)) $title = ucfirst($cpt);
		return array(
					"header_info_{$cpt}" => array(
						"title" => esc_html__('Header', 'anubia'),
						"desc" => '',
						"type" => "info",
						),
					"header_type_{$cpt}" => array(
						"title" => esc_html__('Header style', 'anubia'),
						"desc" => wp_kses_data( __('Choose whether to use the default header or header Layouts (available only if the ThemeREX Addons is activated)', 'anubia') ),
						"std" => 'inherit',
						"options" => anubia_get_list_header_footer_types(true),
						"type" => ANUBIA_THEME_FREE ? "hidden" : "switch"
						),
					"header_style_{$cpt}" => array(
						"title" => esc_html__('Select custom layout', 'anubia'),
						// Translators: Add CPT name to the description
						"desc" => wp_kses_data( sprintf(__('Select custom layout to display the site header on the %s pages', 'anubia'), $title) ),
						"dependency" => array(
							"header_type_{$cpt}" => array('custom')
						),
						"std" => 'inherit',
						"options" => array(),
						"type" => ANUBIA_THEME_FREE ? "hidden" : "select"
						),
					"header_position_{$cpt}" => array(
						"title" => esc_html__('Header position', 'anubia'),
						// Translators: Add CPT name to the description
						"desc" => wp_kses_data( sprintf(__('Select position to display the site header on the %s pages', 'anubia'), $title) ),
						"std" => 'inherit',
						"options" => array(),
						"type" => ANUBIA_THEME_FREE ? "hidden" : "switch"
						),
					"header_image_override_{$cpt}" => array(
						"title" => esc_html__('Header image override', 'anubia'),
						"desc" => wp_kses_data( __("Allow override the header image with the post's featured image", 'anubia') ),
						"std" => 0,
						"type" => ANUBIA_THEME_FREE ? "hidden" : "checkbox"
						),
					"header_widgets_{$cpt}" => array(
						"title" => esc_html__('Header widgets', 'anubia'),
						// Translators: Add CPT name to the description
						"desc" => wp_kses_data( sprintf(__('Select set of widgets to show in the header on the %s pages', 'anubia'), $title) ),
						"std" => 'hide',
						"options" => array(),
						"type" => "select"
						),
						
					"sidebar_info_{$cpt}" => array(
						"title" => esc_html__('Sidebar', 'anubia'),
						"desc" => '',
						"type" => "info",
						),
					"sidebar_position_{$cpt}" => array(
						"title" => esc_html__('Sidebar position', 'anubia'),
						// Translators: Add CPT name to the description
						"desc" => wp_kses_data( sprintf(__('Select position to show sidebar on the %s pages', 'anubia'), $title) ),
						"std" => 'left',
						"options" => array(),
						"type" => "switch"
						),
					"sidebar_widgets_{$cpt}" => array(
						"title" => esc_html__('Sidebar widgets', 'anubia'),
						// Translators: Add CPT name to the description
						"desc" => wp_kses_data( sprintf(__('Select sidebar to show on the %s pages', 'anubia'), $title) ),
						"dependency" => array(
							"sidebar_position_{$cpt}" => array('left', 'right')
						),
						"std" => 'hide',
						"options" => array(),
						"type" => "select"
						),
					"hide_sidebar_on_single_{$cpt}" => array(
						"title" => esc_html__('Hide sidebar on the single pages', 'anubia'),
						"desc" => wp_kses_data( __("Hide sidebar on the single page", 'anubia') ),
						"std" => 0,
						"type" => "checkbox"
						),
						
					"footer_info_{$cpt}" => array(
						"title" => esc_html__('Footer', 'anubia'),
						"desc" => '',
						"type" => "info",
						),
					"footer_type_{$cpt}" => array(
						"title" => esc_html__('Footer style', 'anubia'),
						"desc" => wp_kses_data( __('Choose whether to use the default footer or footer Layouts (available only if the ThemeREX Addons is activated)', 'anubia') ),
						"std" => 'inherit',
						"options" => anubia_get_list_header_footer_types(true),
						"type" => ANUBIA_THEME_FREE ? "hidden" : "switch"
						),
					"footer_style_{$cpt}" => array(
						"title" => esc_html__('Select custom layout', 'anubia'),
						"desc" => wp_kses_data( __('Select custom layout to display the site footer', 'anubia') ),
						"std" => 'inherit',
						"dependency" => array(
							"footer_type_{$cpt}" => array('custom')
						),
						"options" => array(),
						"type" => ANUBIA_THEME_FREE ? "hidden" : "select"
						),
					"footer_widgets_{$cpt}" => array(
						"title" => esc_html__('Footer widgets', 'anubia'),
						"desc" => wp_kses_data( __('Select set of widgets to show in the footer', 'anubia') ),
						"dependency" => array(
							"footer_type_{$cpt}" => array('default')
						),
						"std" => 'footer_widgets',
						"options" => array(),
						"type" => "select"
						),
					"footer_columns_{$cpt}" => array(
						"title" => esc_html__('Footer columns', 'anubia'),
						"desc" => wp_kses_data( __('Select number columns to show widgets in the footer. If 0 - autodetect by the widgets count', 'anubia') ),
						"dependency" => array(
							"footer_type_{$cpt}" => array('default'),
							"footer_widgets_{$cpt}" => array('^hide')
						),
						"std" => 0,
						"options" => anubia_get_list_range(0,6),
						"type" => "select"
						),
					"footer_wide_{$cpt}" => array(
						"title" => esc_html__('Footer fullwidth', 'anubia'),
						"desc" => wp_kses_data( __('Do you want to stretch the footer to the entire window width?', 'anubia') ),
						"dependency" => array(
							"footer_type_{$cpt}" => array('default')
						),
						"std" => 0,
						"type" => "checkbox"
						),
						
					"widgets_info_{$cpt}" => array(
						"title" => esc_html__('Additional panels', 'anubia'),
						"desc" => '',
						"type" => ANUBIA_THEME_FREE ? "hidden" : "info",
						),
					"widgets_above_page_{$cpt}" => array(
						"title" => esc_html__('Widgets at the top of the page', 'anubia'),
						"desc" => wp_kses_data( __('Select widgets to show at the top of the page (above content and sidebar)', 'anubia') ),
						"std" => 'hide',
						"options" => array(),
						"type" => ANUBIA_THEME_FREE ? "hidden" : "select"
						),
					"widgets_above_content_{$cpt}" => array(
						"title" => esc_html__('Widgets above the content', 'anubia'),
						"desc" => wp_kses_data( __('Select widgets to show at the beginning of the content area', 'anubia') ),
						"std" => 'hide',
						"options" => array(),
						"type" => ANUBIA_THEME_FREE ? "hidden" : "select"
						),
					"widgets_below_content_{$cpt}" => array(
						"title" => esc_html__('Widgets below the content', 'anubia'),
						"desc" => wp_kses_data( __('Select widgets to show at the ending of the content area', 'anubia') ),
						"std" => 'hide',
						"options" => array(),
						"type" => ANUBIA_THEME_FREE ? "hidden" : "select"
						),
					"widgets_below_page_{$cpt}" => array(
						"title" => esc_html__('Widgets at the bottom of the page', 'anubia'),
						"desc" => wp_kses_data( __('Select widgets to show at the bottom of the page (below content and sidebar)', 'anubia') ),
						"std" => 'hide',
						"options" => array(),
						"type" => ANUBIA_THEME_FREE ? "hidden" : "select"
						)
					);
	}
}


// Return lists with choises when its need in the admin mode
if (!function_exists('anubia_options_get_list_choises')) {
	add_filter('anubia_filter_options_get_list_choises', 'anubia_options_get_list_choises', 10, 2);
	function anubia_options_get_list_choises($list, $id) {
		if (is_array($list) && count($list)==0) {
			if (strpos($id, 'header_style')===0)
				$list = anubia_get_list_header_styles(strpos($id, 'header_style_')===0);
			else if (strpos($id, 'header_position')===0)
				$list = anubia_get_list_header_positions(strpos($id, 'header_position_')===0);
			else if (strpos($id, 'header_widgets')===0)
				$list = anubia_get_list_sidebars(strpos($id, 'header_widgets_')===0, true);
			else if (strpos($id, '_scheme') > 0)
				$list = anubia_get_list_schemes($id!='color_scheme');
			else if (strpos($id, 'sidebar_widgets')===0)
				$list = anubia_get_list_sidebars(strpos($id, 'sidebar_widgets_')===0, true);
			else if (strpos($id, 'sidebar_position')===0)
				$list = anubia_get_list_sidebars_positions(strpos($id, 'sidebar_position_')===0);
			else if (strpos($id, 'widgets_above_page')===0)
				$list = anubia_get_list_sidebars(strpos($id, 'widgets_above_page_')===0, true);
			else if (strpos($id, 'widgets_above_content')===0)
				$list = anubia_get_list_sidebars(strpos($id, 'widgets_above_content_')===0, true);
			else if (strpos($id, 'widgets_below_page')===0)
				$list = anubia_get_list_sidebars(strpos($id, 'widgets_below_page_')===0, true);
			else if (strpos($id, 'widgets_below_content')===0)
				$list = anubia_get_list_sidebars(strpos($id, 'widgets_below_content_')===0, true);
			else if (strpos($id, 'footer_style')===0)
				$list = anubia_get_list_footer_styles(strpos($id, 'footer_style_')===0);
			else if (strpos($id, 'footer_widgets')===0)
				$list = anubia_get_list_sidebars(strpos($id, 'footer_widgets_')===0, true);
			else if (strpos($id, 'blog_style')===0)
				$list = anubia_get_list_blog_styles(strpos($id, 'blog_style_')===0);
			else if (strpos($id, 'post_type')===0)
				$list = anubia_get_list_posts_types();
			else if (strpos($id, 'parent_cat')===0)
				$list = anubia_array_merge(array(0 => esc_html__('- Select category -', 'anubia')), anubia_get_list_categories());
			else if (strpos($id, 'blog_animation')===0)
				$list = anubia_get_list_animations_in();
			else if ($id == 'color_scheme_editor')
				$list = anubia_get_list_schemes();
			else if (strpos($id, '_font-family') > 0)
				$list = anubia_get_list_load_fonts(true);
		}
		return $list;
	}
}
?>