<?php
/**
 * The style "detailed" of the Events item
 *
 * @package WordPress
 * @subpackage ThemeREX Addons
 * @since v1.2
 */

$args = get_query_var('trx_addons_args_sc_events');

if ($args['slider']) {
	?><div class="slider-slide swiper-slide"><?php
} else if ((int)$args['columns'] > 1) {
	?><div class="<?php echo esc_attr(trx_addons_get_column_class(1, $args['columns'])); ?>"><?php
}

?><div class="sc_events_item"><?php
	// Event's time
	$time = tribe_get_start_time(null, 'g:i A');

    // Event's date
    $date = tribe_get_start_date(null, true, 'd-M');
    if (empty($date)) $date = get_the_date('d-M');
    $date = explode('-', $date);

	// Event's date
	?><span class="sc_events_item_date_wrap"><span class="sc_events_item_date">
		<span class="sc_events_item_day"><?php echo esc_html($date[0]); ?></span>
		<span class="sc_events_item_month"><?php echo esc_html($date[1]); ?></span>
	</span></span><?php
	// Event's title
	?><span class="sc_events_item_title_wrap"><span class="sc_events_item_title"><?php the_title(); ?></span></span><?php
	// Event's time
	?><span class="sc_events_item_time_wrap"><span class="sc_events_item_time"><?php echo trim($time ? esc_html($time) : esc_html__('All day', 'anubia')); ?></span></span><?php
	// Arrow (button)
    ?><span class="sc_events_item_button_wrap">
        <a href="<?php the_permalink(); ?>">
                <span class="sc_button sc_button_alternative"><?php esc_html_e('Details', 'anubia'); ?></span>
            </a>
    </span><?php
?></div><?php

if ($args['slider'] || (int)$args['columns'] > 1) {
	?></div><?php
}

?>