<?php
/**
 * The style "float" of the Dishes
 *
 * @package WordPress
 * @subpackage ThemeREX Addons
 * @since v1.6.09
 */

$args = get_query_var('trx_addons_args_sc_dishes');

$meta = get_post_meta(get_the_ID(), 'trx_addons_options', true);
$link = get_permalink();
$featured_position = !empty($args['featured_position']) ? str_replace('top', 'left', $args['featured_position']) : 'left';

$price_showed = false;

if (!empty($args['slider'])) {
	?><div class="slider-slide swiper-slide"><?php
} else if ((int)$args['columns'] > 1) {
	?><div class="<?php echo esc_attr(trx_addons_get_column_class(1, $args['columns'])); ?>"><?php
}
?>
<div class="sc_dishes_item with_image<?php
	if (isset($args['hide_excerpt']) && (int)$args['hide_excerpt']) echo ' without_content';
	echo ' sc_dishes_item_featured_'.esc_attr($featured_position);
	?>"<?php
	if (!empty($args['popup'])) {
		?> data-post_id="<?php echo esc_attr(get_the_ID()); ?>"<?php
		?> data-post_type="<?php echo esc_attr(TRX_ADDONS_CPT_DISHES_PT); ?>"<?php
	}
	?>>
	<div class="sc_dishes_item_header">
		<h5 class="sc_dishes_item_title<?php if (!$price_showed && trim($meta['price']) != '') echo ' with_price'; ?>"><a href="<?php echo esc_url($link); ?>"><?php
			the_title();
			// Price
			if (!$price_showed && trim($meta['price']) != '') {
                $sep = '.';
                $price = $meta['price'];
                $price = str_replace('$', '<span class="dish-currency">$</span>', $price);
				?><div class="sc_dishes_item_price"><?php echo wp_kses(preg_replace('/([0-9,]+)(\\'.trim($sep).')([0-9]{2})/', '\\1<span class="decimals">\\2\\3</span>', $price), 'anubia_kses_content'); ?></div><?php
			}
		?></a></h5>
	</div>
	<?php if (!isset($args['hide_excerpt']) || (int)$args['hide_excerpt']==0) { ?>
		<div class="sc_dishes_item_content"><?php the_excerpt(); ?></div>
	<?php } ?>
</div>
<?php
if (!empty($args['slider']) || (int)$args['columns'] > 1) {
	?></div><?php
}
?>