<?php
/*
Plugin Name: Arkito Core
Plugin URI: http://themeforest.net/user/helloexpert
Description: Plugin to contain shortcodes and custom post types of the arkito theme.
Author: helloexpert
Author URI: http://themeforest.net/user/helloexpert/portfolio
Version: 1.0
Text Domain: arkito-core
*/

if( ! function_exists( 'arkito_block_direct_access' ) ) {
	function arkito_block_direct_access() {
		if( ! defined( 'ABSPATH' ) ) {
			exit( 'Forbidden' );
		}
	}
}

// Plugin URL
define( 'ARKITO_PLUGIN_URL', plugins_url( '/', __FILE__ ) );

// Plugin PATH
define( 'ARKITO_PLUGIN_PATH', plugin_dir_path( __FILE__ ) );
define( 'ARKITO_PLUGIN_ASTS', ARKITO_PLUGIN_URL . 'assets' );
define( 'ARKITO_PLUGIN_IMGS', ARKITO_PLUGIN_ASTS . '/images' );
define( 'ARKITO_PLUGIN_INC', ARKITO_PLUGIN_PATH . 'include' );

// DIRECTORY SEPARATOR
define ( 'DS' , DIRECTORY_SEPARATOR );

// Arkito Elementor Shortcode Path
define( 'ARKITO_EM_SHORTCODE_BASE_PATH', ARKITO_PLUGIN_PATH . 'elementor/' );
define( 'ARKITO_EM_SHORTCODE_PATH', ARKITO_EM_SHORTCODE_BASE_PATH . 'widgets/' );

/**
 * Check if Codestar Framework is Active or Not!
 */
function arkito_framework_active() {
  return ( defined( 'CS_VERSION' ) ) ? true : false;
}

/* ARKITO_THEME_NAME_PLUGIN */
define('ARKITO_THEME_NAME_PLUGIN', 'Arkito' );

// Initial File
include_once( ABSPATH . 'wp-admin/includes/plugin.php' );
if (is_plugin_active('arkito-core/arkito-core.php')) {

	// Custom Post Type
  require_once( ARKITO_PLUGIN_INC . '/custom-post-type.php' );

  if ( is_plugin_active('kingcomposer/kingcomposer.php') ) {

    define( 'ARKITO_KC_SHORTCODE_BASE_PATH', ARKITO_PLUGIN_PATH . 'kc/' );
    define( 'ARKITO_KC_SHORTCODE_PATH', ARKITO_KC_SHORTCODE_BASE_PATH . 'shortcodes/' );
    // Shortcodes
    require_once( ARKITO_KC_SHORTCODE_BASE_PATH . '/kc-setup.php' );
    require_once( ARKITO_KC_SHORTCODE_BASE_PATH . '/library.php' );
  }

  // Theme Custom Shortcode
  require_once( ARKITO_PLUGIN_INC . '/custom-shortcodes/theme-shortcodes.php' );
  require_once( ARKITO_PLUGIN_INC . '/custom-shortcodes/custom-shortcodes.php' );

  // Importer
  require_once( ARKITO_PLUGIN_INC . '/demo/importer.php' );


  if (class_exists('WP_Widget') && is_plugin_active('codestar-framework/cs-framework.php') ) {
    // Widgets

    require_once( ARKITO_PLUGIN_INC . '/widgets/nav-widget.php' );
    require_once( ARKITO_PLUGIN_INC . '/widgets/recent-posts.php' );
    require_once( ARKITO_PLUGIN_INC . '/widgets/footer-posts.php' );
    require_once( ARKITO_PLUGIN_INC . '/widgets/text-widget.php' );
    require_once( ARKITO_PLUGIN_INC . '/widgets/widget-extra-fields.php' );

    // Elementor
    if(file_exists( ARKITO_EM_SHORTCODE_BASE_PATH . '/em-setup.php' ) ){
      require_once( ARKITO_EM_SHORTCODE_BASE_PATH . '/em-setup.php' );
      require_once( ARKITO_EM_SHORTCODE_BASE_PATH . 'lib/fields/icons.php' );
      require_once( ARKITO_EM_SHORTCODE_BASE_PATH . 'lib/icons-manager/icons-manager.php' );
    }
  }

  add_action('wp_enqueue_scripts', 'arkito_plugin_enqueue_scripts');
  function arkito_plugin_enqueue_scripts() {
    wp_enqueue_script('plugin-scripts', ARKITO_PLUGIN_ASTS.'/plugin-scripts.js', array('jquery'), '', true);
  }

}

// Extra functions
require_once( ARKITO_PLUGIN_INC . '/theme-functions.php' );