<?php
namespace Elementor;

defined( 'ABSPATH' ) || die();

class Arkito_Icons_Manager {

    public static function init() {
        add_filter( 'elementor/icons_manager/additional_tabs', [ __CLASS__, 'add_arkito_icons_tab' ] );
    }

    public static function add_arkito_icons_tab( $tabs ) {
        $tabs['arkito-icons'] = [
            'name' => 'arkito-icons',
            'label' => __( 'Arkito Icons', 'arkito-elementor-addons' ),
            'url' => ARKITO_PLUGIN_URL . 'elementor/assets/css/flaticon.css',
            'enqueue' => [ ARKITO_PLUGIN_URL . 'elementor/assets/css/flaticon.css' ],
            'prefix' => 'flaticon-',
            'displayPrefix' => 'fi',
            'labelIcon' => 'flaticon-standard',
            'ver' => '1.0.0',
            'fetchJson' => ARKITO_PLUGIN_URL . 'elementor/assets/js/arkito-icons.js?v=1.0.0',
            'native' => false,
        ];
        return $tabs;
    }

    /**
     * Get a list of arkito icons
     *
     * @return array
     */
    public static function get_arkito_icons() {
        return [
            'flaticon-search-interface-symbol' => 'search-interface-symbol',
            'flaticon-shopping-basket'  => 'shopping-basket',
            'flaticon-shopping-bag' => 'shopping-bag',
            'flaticon-bag' => 'bag',
            'flaticon-play-button' => 'play-button',
            'flaticon-quotation' => 'quotation',
        ];
    }
}

Arkito_Icons_Manager::init();