<?php
/*
 * Elementor Arkito Blog Widget
 * Author & Copyright: helloexpert
*/

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Arkito_Blog extends Widget_Base{

	/**
	 * Retrieve the widget name.
	*/
	public function get_name(){
		return 'tmx-arkito_blog';
	}

	/**
	 * Retrieve the widget title.
	*/
	public function get_title(){
		return esc_html__( 'Blog', 'arkito-core' );
	}

	/**
	 * Retrieve the widget icon.
	*/
	public function get_icon() {
		return 'fa fa-newspaper-o';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	*/
	public function get_categories() {
		return ['helloexpert-category'];
	}

	/**
	 * Retrieve the list of scripts the Arkito Blog widget depended on.
	 * Used to set scripts dependencies required to run the widget.
	*/
	public function get_script_depends() {
		return ['tmx-arkito_blog'];
	}
	
	/**
	 * Register Arkito Blog widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	*/
	protected function _register_controls(){

		$posts = get_posts( 'post_type="post"&numberposts=-1' );
    $PostID = array();
    if ( $posts ) {
      foreach ( $posts as $post ) {
        $PostID[ $post->ID ] = $post->ID;
      }
    } else {
      $PostID[ __( 'No ID\'s found', 'arkito' ) ] = 0;
    }
		
		
		$this->start_controls_section(
			'section_blog_metas',
			[
				'label' => esc_html__( 'Meta\'s Options', 'arkito-core' ),
			]
		);
		$this->add_control(
			'blog_image',
			[
				'label' => esc_html__( 'Image', 'arkito-core' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'arkito-core' ),
				'label_off' => esc_html__( 'Hide', 'arkito-core' ),
				'return_value' => 'true',
				'default' => 'true',
			]
		);
		$this->add_control(
			'blog_date',
			[
				'label' => esc_html__( 'Date', 'arkito-core' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'arkito-core' ),
				'label_off' => esc_html__( 'Hide', 'arkito-core' ),
				'return_value' => 'true',
				'default' => 'true',
			]
		);
		$this->add_control(
			'blog_comments',
			[
				'label' => esc_html__( 'Comments', 'arkito-core' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'arkito-core' ),
				'label_off' => esc_html__( 'Hide', 'arkito-core' ),
				'return_value' => 'true',
				'default' => 'true',
			]
		);
		$this->add_control(
			'blog_tags',
			[
				'label' => esc_html__( 'Tags', 'arkito-core' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'arkito-core' ),
				'label_off' => esc_html__( 'Hide', 'arkito-core' ),
				'return_value' => 'true',
				'default' => 'true',
			]
		);
		$this->add_control(
			'read_more_txt',
			[
				'label' => esc_html__( 'Read More Text', 'arkito-core' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'placeholder' => esc_html__( 'Type your Read More text here', 'arkito-core' ),
			]
		);
		$this->end_controls_section();// end: Section


		$this->start_controls_section(
			'section_blog_listing',
			[
				'label' => esc_html__( 'Listing Options', 'arkito-core' ),
			]
		);
		$this->add_control(
			'blog_limit',
			[
				'label' => esc_html__( 'Blog Limit', 'arkito-core' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 100,
				'step' => 1,
				'default' => 3,
				'description' => esc_html__( 'Enter the number of items to show.', 'arkito-core' ),
			]
		);
		$this->add_control(
			'blog_order',
			[
				'label' => __( 'Order', 'arkito-core' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'ASC' => esc_html__( 'Asending', 'arkito-core' ),
					'DESC' => esc_html__( 'Desending', 'arkito-core' ),
				],
				'default' => 'DESC',
			]
		);
		$this->add_control(
			'blog_orderby',
			[
				'label' => __( 'Order By', 'arkito-core' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'none' => esc_html__( 'None', 'arkito-core' ),
					'ID' => esc_html__( 'ID', 'arkito-core' ),
					'author' => esc_html__( 'Author', 'arkito-core' ),
					'title' => esc_html__( 'Title', 'arkito-core' ),
					'date' => esc_html__( 'Date', 'arkito-core' ),
				],
				'default' => 'date',
			]
		);
		$this->add_control(
			'blog_show_category',
			[
				'label' => __( 'Certain Categories?', 'arkito-core' ),
				'type' => Controls_Manager::SELECT2,
				'default' => [],
				'options' => Controls_Helper_Output::get_terms_names( 'category'),
				'multiple' => true,
			]
		);
		$this->add_control(
			'blog_show_id',
			[
				'label' => __( 'Certain ID\'s?', 'arkito-core' ),
				'type' => Controls_Manager::SELECT2,
				'default' => [],
				'options' => $PostID,
				'multiple' => true,
			]
		);
		$this->add_control(
			'short_content',
			[
				'label' => esc_html__( 'Excerpt Length', 'arkito-core' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 55,
				'description' => esc_html__( 'How many words you want in short content paragraph.', 'arkito-core' ),
			]
		);
		$this->add_control(
			'blog_pagination',
			[
				'label' => esc_html__( 'Pagination', 'arkito-core' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'arkito-core' ),
				'label_off' => esc_html__( 'Hide', 'arkito-core' ),
				'return_value' => 'true',
				'default' => 'true',
			]
		);
		
		$this->end_controls_section();// end: Section

		
		// Title
		$this->start_controls_section(
			'section_title_style',
			[
				'label' => esc_html__( 'Title', 'arkito-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__( 'Typography', 'arkito-core' ),
				'name' => 'sasban_title_typography',
				'selector' => '{{WRAPPER}} .blog-section h3 a,.blog-pg-section .post h3 a',
			]
		);
		$this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .blog-section h3 a,.blog-pg-section .post h3 a,.blog-pg-section .entry-meta li a,.blog-pg-section .entry-meta li' => 'color: {{VALUE}};'
				],
			]
		);
		$this->add_control(
			'title_padding',
			[
				'label' => __( 'Title Padding', 'arkito-core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .blog-section h3 a,.blog-pg-section .post h3 a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();// end: Section

		// Meta
		$this->start_controls_section(
			'section_meta_style',
			[
				'label' => esc_html__( 'Meta', 'arkito-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__( 'Typography', 'arkito-core' ),
				'name' => 'sasban_meta_typography',
				'selector' => '{{WRAPPER}} .blog-section .entry-meta ul li, .blog-section .entry-meta ul li a,.blog-pg-section .entry-meta li',
			]
		);
		$this->add_control(
			'meta_color',
			[
				'label' => esc_html__( 'Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .blog-section .entry-details .cat a, .blog-section-s2 .entry-details .cat a' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'meta_bg_color',
			[
				'label' => esc_html__( 'Background Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .blog-section .entry-details .cat, .blog-section-s2 .entry-details .cat' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'meta_padding',
			[
				'label' => __( 'Title Padding', 'arkito-core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .blog-section .entry-details .cat, .blog-section-s2 .entry-details .cat' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();// end: Section


		// Button
		$this->start_controls_section(
			'section_button_style',
			[
				'label' => esc_html__( 'Read More', 'arkito-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
	
		$this->add_control(
			'button_color',
			[
				'label' => esc_html__( 'Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .blog-section .entry-details .read-more, .blog-section-s2 .entry-details .read-more' => 'color: {{VALUE}};',
					'{{WRAPPER}} .blog-section .entry-details .read-more:before, .blog-section-s2 .entry-details .read-more:before' => 'background-color: {{VALUE}};'
				],
			]
		);
		
		$this->add_control(
			'button_hover_color',
			[
				'label' => esc_html__( 'Hover Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .blog-section .entry-details .read-more:hover, .blog-section-s2 .entry-details .read-more:hover' => 'color: {{VALUE}};',
					'{{WRAPPER}} .blog-section .entry-details .read-more:hover:before, .blog-section-s2 .entry-details .read-more:hover:before' => 'background-color: {{VALUE}};'
				],
			]
		);
		
		$this->end_controls_section();// end: Section




		// Blog Title
		$this->start_controls_section(
			'blog_section_icon_style',
			[
				'label' => esc_html__( 'Title Icon', 'arkito-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'blog_icon_color',
			[
				'label' => esc_html__( 'Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .blog-section .section-title-s4 .icon .fi:before' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'blog_icon_border_color',
			[
				'label' => esc_html__( 'Border Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .blog-section .section-title-s4 .icon' => 'box-shadow: 0 0 0 5px {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'blog_icon_bg_color',
			[
				'label' => esc_html__( 'Background Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .blog-section .section-title-s4 .icon' => 'background-color: {{VALUE}};',
				],
			]
		);
	
		$this->end_controls_section();// end: Section

		// Sub Title
		$this->start_controls_section(
			'blog_section_subtitle_style',
			[
				'label' => esc_html__( 'Sub Title', 'arkito-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__( 'Typography', 'arkito-core' ),
				'name' => 'blog_sub_title_typography',
				'selector' => '{{WRAPPER}} .blog-section .section-title-s4 span',
			]
		);
		$this->add_control(
			'blog_subtitle_color',
			[
				'label' => esc_html__( 'Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .blog-section .section-title-s4 span' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'blog_subtitle_padding',
			[
				'label' => __( 'Sub Title Padding', 'arkito-core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .blog-section .section-title-s4 span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();// end: Section
	
		// Title
		$this->start_controls_section(
			'blog_section_title_style',
			[
				'label' => esc_html__( 'Title', 'arkito-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__( 'Typography', 'arkito-core' ),
				'name' => 'blog_arkito_title_typography',
				'selector' => '{{WRAPPER}} .blog-section .section-title-s4 h2',
			]
		);
		$this->add_control(
			'blog_title_color',
			[
				'label' => esc_html__( 'Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .blog-section .section-title-s4 h2' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'blog_title_padding',
			[
				'label' => esc_html__( 'Title Padding', 'arkito-core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .blog-section .section-title-s4 h2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();// end: Section

		// Content
		$this->start_controls_section(
			'blog_section_content_style',
			[
				'label' => esc_html__( 'Content', 'arkito-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__( 'Typography', 'arkito-core' ),
				'name' => 'blog_section_content_typography',
				'selector' => '{{WRAPPER}} .blog-section .section-title-s4 > p',
			]
		);
		$this->add_control(
			'blog_content_color',
			[
				'label' => esc_html__( 'Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .blog-section .section-title-s4 > p' => 'color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section();// end: Section

		
	}

	/**
	 * Render Blog widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	*/
	protected function render() {
		$settings = $this->get_settings_for_display();

		$read_more_txt = !empty( $settings['read_more_txt'] ) ? $settings['read_more_txt'] : '';

		$blog_limit = !empty( $settings['blog_limit'] ) ? $settings['blog_limit'] : '';
		$blog_image  = ( isset( $settings['blog_image'] ) && ( 'true' == $settings['blog_image'] ) ) ? true : false;
		$blog_date  = ( isset( $settings['blog_date'] ) && ( 'true' == $settings['blog_date'] ) ) ? true : false;
		$blog_comments  = ( isset( $settings['blog_comments'] ) && ( 'true' == $settings['blog_comments'] ) ) ? true : false;
		$blog_tags  = ( isset( $settings['blog_tags'] ) && ( 'true' == $settings['blog_tags'] ) ) ? true : false;

		$blog_order = !empty( $settings['blog_order'] ) ? $settings['blog_order'] : '';
		$blog_orderby = !empty( $settings['blog_orderby'] ) ? $settings['blog_orderby'] : '';
		$blog_show_category = !empty( $settings['blog_show_category'] ) ? $settings['blog_show_category'] : [];
		$blog_show_id = !empty( $settings['blog_show_id'] ) ? $settings['blog_show_id'] : [];
		$short_content = !empty( $settings['short_content'] ) ? $settings['short_content'] : '';
		$blog_pagination  = ( isset( $settings['blog_pagination'] ) && ( 'true' == $settings['blog_pagination'] ) ) ? true : false;
	
		
		$excerpt_length = $short_content ? $short_content : '55';
		$read_more_txt = $read_more_txt ? $read_more_txt : esc_html__( 'Read More', 'arkito-core' );

		// Turn output buffer on
		ob_start();


		// Pagination
		global $paged;
		if( get_query_var( 'paged' ) )
		  $my_page = get_query_var( 'paged' );
		else {
		  if( get_query_var( 'page' ) )
			$my_page = get_query_var( 'page' );
		  else
			$my_page = 1;
		  set_query_var( 'paged', $my_page );
		  $paged = $my_page;
		}

    if ($blog_show_id) {
			$blog_show_id = json_encode( $blog_show_id );
			$blog_show_id = str_replace(array( '[', ']' ), '', $blog_show_id);
			$blog_show_id = str_replace(array( '"', '"' ), '', $blog_show_id);
      $blog_show_id = explode(',',$blog_show_id);
    } else {
      $blog_show_id = '';
    }

		$args = array(
		  // other query params here,
		  'paged' => $my_page,
		  'post_type' => 'post',
		  'posts_per_page' => (int)$blog_limit,
		  'category_name' => implode(',', $blog_show_category),
		  'orderby' => $blog_orderby,
		  'order' => $blog_order,
      'post__in' => $blog_show_id,
		);

		$arkito_post = new \WP_Query( $args ); ?>

		<div class="arkito-blog-section">
    	<div class="arkito-blog-grids">
				<?php 
				  if ($arkito_post->have_posts()) : while ($arkito_post->have_posts()) : $arkito_post->the_post();
				  $large_image =  wp_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'fullsize', false, '' );
				  $large_alt = get_post_meta( get_post_thumbnail_id(get_the_ID()) , '_wp_attachment_image_alt', true); 
				  $large_image = $large_image ? $large_image[0] : ''; 

				  $post_options = get_post_meta( get_the_ID(), 'post_options', true );
					$grid_image = isset( $post_options['grid_image'] ) ? $post_options['grid_image'] : '';
					$image_url = wp_get_attachment_url( $grid_image );
          $image_alt = get_post_meta( $grid_image , '_wp_attachment_image_alt', true); 

          ?>
	        	<div class="arkito-grid">
		            <div class="entry-media">
		              <?php if ( $image_url ) { ?>
                    <img class="img-responsive" src="<?php echo esc_url($image_url); ?>" alt="<?php echo esc_attr( $image_alt); ?>">
                  <?php } ?>
		            </div>
		            <div class="entry-details">
		                <div class="date"><?php echo esc_html( get_the_date() );  ?></div>
		                <h3><a href="<?php echo esc_url( get_permalink() ); ?>"><?php echo esc_html(get_the_title()); ?></a></h3>
		                <a href="<?php echo esc_url( get_permalink() ); ?>" class="read-more"><?php echo esc_html( $read_more_txt ); ?></a>
		            </div>
		        </div>
						<?php 
					 	endwhile;
					  endif;
					  wp_reset_postdata();
						if ( $blog_pagination ) { ?>
						  <div class="page-pagination-wrap">
						  <?php 	echo '<div class="paginations">';
								$big = 999999999;
								echo paginate_links( array(
	                'base'      => str_replace( $big, '%#%', get_pagenum_link( $big ) ),
	                'format'    => '?paged=%#%',
	                'total'     => $arkito_post->max_num_pages,
	                'show_all'  => false,
	                'current'   => max( 1, $my_page ),
									'prev_text'    => '<div class="fi flaticon-back"></div>',
									'next_text'    => '<div class="fi flaticon-next"></div>',
	                'mid_size'  => 1,
	                'type'      => 'list'
	              ) );
		        	echo '</div>'; ?>
						  </div>
						<?php } ?>
	    </div>
		</div>
		<?php
			// Return outbut buffer
			echo ob_get_clean();	
		}
	/**
	 * Render Blog widget output in the editor.
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	*/
	
	//protected function _content_template(){}
	
}
Plugin::instance()->widgets_manager->register_widget_type( new Arkito_Blog() );