<?php
/*
 * Elementor Arkito Contact Form 7 Widget
 * Author & Copyright: helloexpert
*/

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Arkito_Contact_Form extends Widget_Base{

	/**
	 * Retrieve the widget name.
	*/
	public function get_name(){
		return 'tmx-arkito_contact_form';
	}

	/**
	 * Retrieve the widget title.
	*/
	public function get_title(){
		return esc_html__( 'Contact Form', 'arkito-core' );
	}

	/**
	 * Retrieve the widget icon.
	*/
	public function get_icon() {
		return 'fa fa-wpforms';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	*/
	public function get_categories() {
		return ['helloexpert-category'];
	}

	/**
	 * Retrieve the list of scripts the Arkito Contact Form widget depended on.
	 * Used to set scripts dependencies required to run the widget.
	*/
	/*
	public function get_script_depends() {
		return ['tmx-arkito_contact_form'];
	}
	 */
	
	/**
	 * Register Arkito Contact Form widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	*/
	protected function _register_controls(){
		
		$this->start_controls_section(
			'section_contact_form',
			[
				'label' => esc_html__( 'Form Options', 'arkito-core' ),
			]
		);
		$this->add_control(
			'form_subtitle',
			[
				'label' => esc_html__( 'Sub Title', 'arkito-core' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => esc_html__( 'Default Sub title', 'arkito-core' ),
				'placeholder' => esc_html__( 'Type your Sub title here', 'arkito-core' ),
			]
		);	
		$this->add_control(
			'form_title',
			[
				'label' => esc_html__( 'Title', 'arkito-core' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => esc_html__( 'Default title', 'arkito-core' ),
				'placeholder' => esc_html__( 'Type your title here', 'arkito-core' ),
			]
		);
		$this->add_control(
			'form_id',
			[
				'label' => esc_html__( 'Select contact form', 'arkito-core' ),
				'type' => Controls_Manager::SELECT,
				'options' => Controls_Helper_Output::get_posts('wpcf7_contact_form'),
			]
		);
		$this->add_control(
			'bg_shape',
			[
				'label' => esc_html__( 'Select BG Shape', 'arkito-core' ),
				'type' => Controls_Manager::MEDIA,
				'frontend_available' => true,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
				'description' => esc_html__( 'Set your image.', 'arkito-core'),
			]
		);
		$this->end_controls_section();// end: Section

		$this->start_controls_section(
			'section_contact_form_content',
			[
				'label' => esc_html__( 'Sction Content', 'arkito-core' ),
			]
		);
		$this->add_control(
			'section_image',
			[
				'label' => esc_html__( 'Select Image', 'arkito-core' ),
				'type' => Controls_Manager::MEDIA,
				'frontend_available' => true,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
				'description' => esc_html__( 'Set your image.', 'arkito-core'),
			]
		);
		$this->add_control(
			'section_image2',
			[
				'label' => esc_html__( 'Select Image 2', 'arkito-core' ),
				'type' => Controls_Manager::MEDIA,
				'frontend_available' => true,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
				'description' => esc_html__( 'Set your image.', 'arkito-core'),
			]
		);
		$this->end_controls_section();// end: Section

		// Sub Title Style

		$this->start_controls_section(
			'section_subtitle_style',
			[
				'label' => esc_html__( 'Sub Title', 'arkito-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'arkito_title_typography',
				'selector' => '{{WRAPPER}} .get-in-touch-contact-area .section-title>span',
			]
		);
		$this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .get-in-touch-contact-area .section-title>span,.get-in-touch-contact-area  .section-title>span::before,.get-in-touch-contact-area  .section-title>span::after' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'title_pad',
			[
				'label' => __( 'Padding', 'arkito-core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .get-in-touch-contact-area .section-title>span ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();// end: Section

		// Content Style

		$this->start_controls_section(
			'section_content_style',
			[
				'label' => esc_html__( 'Content', 'arkito-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'arkito_content_typography',
				'selector' => '{{WRAPPER}} .get-in-touch-contact-area .section-title h2',
			]
		);
		$this->add_control(
			'content_color',
			[
				'label' => esc_html__( 'Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .get-in-touch-contact-area .section-title h2' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'content_pad',
			[
				'label' => __( 'Padding', 'arkito-core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .track-contact .track-trace p,.contact-pg-section .section-title-s3 p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();// end: Section

		$this->start_controls_section(
			'section_form_style',
			[
				'label' => esc_html__( 'Form', 'arkito-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'form_typography',
				'selector' => '{{WRAPPER}} .arkito-get-in-touch .get-contact-form input[type="text"], 
				{{WRAPPER}} .arkito-get-in-touch .get-contact-form input[type="email"], 
				{{WRAPPER}} .arkito-get-in-touch .get-contact-form input[type="date"], 
				{{WRAPPER}} .arkito-get-in-touch .get-contact-form input[type="time"], 
				{{WRAPPER}} .arkito-get-in-touch .get-contact-form input[type="number"], 
				{{WRAPPER}} .arkito-get-in-touch .get-contact-form textarea, 
				{{WRAPPER}} .arkito-get-in-touch .get-contact-form select, 
				{{WRAPPER}} .arkito-get-in-touch .get-contact-form .form-control, 
				{{WRAPPER}} .track-contact .track-trace select, 
				{{WRAPPER}} .track-contact .track-trace input',
			]
		);
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'form_border',
				'label' => esc_html__( 'Border', 'arkito-core' ),
				'selector' => '{{WRAPPER}} .arkito-get-in-touch .get-contact-form input[type="text"], 
				{{WRAPPER}} .arkito-get-in-touch .get-contact-form input[type="email"], 
				{{WRAPPER}} .arkito-get-in-touch .get-contact-forminput[type="date"], 
				{{WRAPPER}} .arkito-get-in-touch .get-contact-form input[type="time"], 
				{{WRAPPER}} .arkito-get-in-touch .get-contact-form input[type="number"], 
				{{WRAPPER}} .arkito-get-in-touch .get-contact-form textarea, 
				{{WRAPPER}} .arkito-get-in-touch .get-contact-form select, 
				{{WRAPPER}} .arkito-get-in-touch .get-contact-form .form-control, 
				{{WRAPPER}} .arkito-get-in-touch .get-contact-form .nice-select,
				{{WRAPPER}} .track-contact .track-trace select, 
				{{WRAPPER}} .track-contact .track-trace input',

			]
		);
		$this->add_control(
			'placeholder_text_color',
			[
				'label' => __( 'Placeholder Text Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .arkito-get-in-touch .get-contact-form input:not([type="submit"])::-webkit-input-placeholder' => 'color: {{VALUE}} !important;',
					'{{WRAPPER}} .arkito-get-in-touch .get-contact-form input:not([type="submit"])::-moz-placeholder' => 'color: {{VALUE}} !important;',
					'{{WRAPPER}} .arkito-get-in-touch .get-contact-form input:not([type="submit"])::-ms-input-placeholder' => 'color: {{VALUE}} !important;',
					'{{WRAPPER}} .arkito-get-in-touch .get-contact-form input:not([type="submit"])::-o-placeholder' => 'color: {{VALUE}} !important;',
					'{{WRAPPER}} .arkito-get-in-touch .get-contact-form textarea::-webkit-input-placeholder' => 'color: {{VALUE}} !important;',
					'{{WRAPPER}} .arkito-get-in-touch .get-contact-form textarea::-moz-placeholder' => 'color: {{VALUE}} !important;',
					'{{WRAPPER}} .arkito-get-in-touch .get-contact-form textarea::-ms-input-placeholder' => 'color: {{VALUE}} !important;',
					'{{WRAPPER}} .arkito-get-in-touch .get-contact-form textarea::-o-placeholder' => 'color: {{VALUE}} !important;',
					'{{WRAPPER}} .track-contact .track-trace input::-webkit-input-placeholder' => 'color: {{VALUE}} !important;',
					'{{WRAPPER}} .track-contact .track-trace select::-webkit-input-placeholder' => 'color: {{VALUE}} !important;',
				],
			]
		);
		$this->add_control(
			'label_color',
			[
				'label' => __( 'Label Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .arkito-get-in-touch .get-contact-form label' => 'color: {{VALUE}} !important;',
				],
			]
		);
		$this->add_control(
			'text_color',
			[
				'label' => __( 'Text Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .arkito-get-in-touch .get-contact-form input[type="text"], 
					{{WRAPPER}} .arkito-get-in-touch .get-contact-form input[type="email"], 
					{{WRAPPER}} .arkito-get-in-touch .get-contact-form input[type="date"], 
					{{WRAPPER}} .arkito-get-in-touch .get-contact-form input[type="time"], 
					{{WRAPPER}} .arkito-get-in-touch .get-contact-form input[type="number"], 
					{{WRAPPER}} .arkito-get-in-touch .get-contact-form textarea, 
					{{WRAPPER}} .arkito-get-in-touch .get-contact-form select, 
					{{WRAPPER}} .arkito-get-in-touch .get-contact-form .form-control, 
					{{WRAPPER}} .track-contact .track-trace input, 
					{{WRAPPER}} .arkito-get-in-touch .get-contact-form .nice-select' => 'color: {{VALUE}} !important;',
				],
			]
		);
		$this->end_controls_section();// end: Section
		
		$this->start_controls_section(
			'section_button_style',
			[
				'label' => esc_html__( 'Button', 'arkito-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'button_typography',
				'selector' => '{{WRAPPER}} .arkito-get-in-touch .get-contact-form .wpcf7-form-control.wpcf7-submit',
			]
		);
		$this->add_responsive_control(
			'btn_width',
			[
				'label' => esc_html__( 'Width', 'arkito-core' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
				],
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .arkito-get-in-touch .get-contact-form .wpcf7-form-control.wpcf7-submit' => 'min-width: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'btn_margin',
			[
				'label' => __( 'Margin', 'arkito-core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .arkito-get-in-touch .get-contact-form .wpcf7-form-control.wpcf7-submit' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'button_border_radius',
			[
				'label' => __( 'Border Radius', 'arkito-core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .arkito-get-in-touch .get-contact-form .wpcf7-form-control.wpcf7-submit' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->start_controls_tabs( 'button_style' );
			$this->start_controls_tab(
				'button_normal',
				[
					'label' => esc_html__( 'Normal', 'arkito-core' ),
				]
			);
			$this->add_control(
				'button_color',
				[
					'label' => esc_html__( 'Color', 'arkito-core' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .arkito-get-in-touch .get-contact-form .wpcf7-form-control.wpcf7-submit' => 'color: {{VALUE}};',
					],
				]
			);
			$this->add_control(
				'button_bg_color',
				[
					'label' => esc_html__( 'Background Color', 'arkito-core' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .arkito-get-in-touch .get-contact-form .wpcf7-form-control.wpcf7-submit' => 'background-color: {{VALUE}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name' => 'button_border',
					'label' => esc_html__( 'Border', 'arkito-core' ),
					'selector' => '{{WRAPPER}} .arkito-get-in-touch .get-contact-form .wpcf7-form-control.wpcf7-submit',
				]
			);
			$this->end_controls_tab();  // end:Normal tab
			
			$this->start_controls_tab(
				'button_hover',
				[
					'label' => esc_html__( 'Hover', 'arkito-core' ),
				]
			);
			$this->add_control(
				'button_hover_color',
				[
					'label' => esc_html__( 'Color', 'arkito-core' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .arkito-get-in-touch .get-contact-form .wpcf7-form-control.wpcf7-submit:hover' => 'color: {{VALUE}};',
					],
				]
			);
			$this->add_control(
				'button_bg_hover_color',
				[
					'label' => esc_html__( 'Background Color', 'arkito-core' ),
					'type' => Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .arkito-get-in-touch .get-contact-form .wpcf7-form-control.wpcf7-submit:hover' => 'background-color: {{VALUE}};',
					],
				]
			);
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name' => 'button_hover_border',
					'label' => esc_html__( 'Border', 'arkito-core' ),
					'selector' => '{{WRAPPER}} .arkito-get-in-touch .get-contact-form .wpcf7-form-control.wpcf7-submit:hover',
				]
			);
			$this->end_controls_tab();  // end:Hover tab
		$this->end_controls_tabs(); // end tabs
		
		$this->end_controls_section();// end: Section

	}

	/**
	 * Render Contact Form widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	*/
	protected function render() {
		$settings = $this->get_settings_for_display();
		$form_id = !empty( $settings['form_id'] ) ? $settings['form_id'] : '';
		$form_title = !empty( $settings['form_title'] ) ? $settings['form_title'] : '';
		$form_subtitle = !empty( $settings['form_subtitle'] ) ? $settings['form_subtitle'] : '';

		$bg_shape_image = !empty( $settings['bg_shape']['id'] ) ? $settings['bg_shape']['id'] : '';	
		$section_image = !empty( $settings['section_image']['id'] ) ? $settings['section_image']['id'] : '';	
		$section_image2 = !empty( $settings['section_image2']['id'] ) ? $settings['section_image2']['id'] : '';	

	// Image
		$image_url = wp_get_attachment_url( $bg_shape_image );

		$section_url = wp_get_attachment_url( $section_image );
		$section_alt = get_post_meta( $settings['section_image']['id'], '_wp_attachment_image_alt', true);
		$section2_url = wp_get_attachment_url( $section_image2 );
		$section2_alt = get_post_meta( $settings['section_image2']['id'], '_wp_attachment_image_alt', true);

   	$e_uniqid       = uniqid();
    $inline_style   = '';

	  if ( $image_url ) {
	    $inline_style .= '.arkito-get-in-touch-'.$e_uniqid .' .get-in-touch-contact-area:before {';
	    $inline_style .= ( $image_url ) ? 'background-image: url( '. $image_url .' );' : '';
	    $inline_style .= '}';
	   }
	    // add inline style
	  add_inline_style( $inline_style );
	  $styled_class  = 'arkito-get-in-touch-'.$e_uniqid.' ';


		// Turn output buffer on
		ob_start(); ?>
		<div class="arkito-get-in-touch <?php echo esc_attr( $styled_class ); ?>">
		    <div class="row">
		        <div class="col-lg-7 col-md-7">
		            <div class="get-in-touch-contact-area">
		                <div class="section-title">
		                	<?php 
	                      if( $form_subtitle ) { echo '<span>'.esc_html( $form_subtitle ).'</span>'; } 
	                    	if( $form_title ) { echo '<h2>'.esc_html( $form_title ).'</h2>'; } 
	                   ?>
		                </div>
		                <div class="get-contact-form">
		                		<?php echo do_shortcode( '[contact-form-7 id="'. $form_id .'"]' ); ?>
		                </div>
		            </div>
		        </div>
		        <div class="col-lg-5 col-md-5">
	            <div class="right-image">
	              <?php if( $section_url ) { echo '<img src="'.esc_url( $section_url ).'" alt="'.esc_url( $section_alt ).'">'; } ?>
                <div class="quote">
                	<?php if( $section2_url ) { echo '<img src="'.esc_url( $section2_url ).'" alt="'.esc_url( $section2_alt ).'">'; } ?>
                </div>
		          </div>
		        </div>
		    </div>
		</div>
		<?php
		// Return outbut buffer
		echo ob_get_clean();
		
		} 
		


	/**
	 * Render Contact Form widget output in the editor.
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	*/
	
	//protected function _content_template(){}
	
}
Plugin::instance()->widgets_manager->register_widget_type( new Arkito_Contact_Form() );