<?php
/*
 * Elementor Arkito Funfact Widget
 * Author & Copyright: helloexpert
*/

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Arkito_Funfact extends Widget_Base{

	/**
	 * Retrieve the widget name.
	*/
	public function get_name(){
		return 'tmx-arkito_funfact';
	}

	/**
	 * Retrieve the widget title.
	*/
	public function get_title(){
		return esc_html__( 'Funfact', 'arkito-core' );
	}

	/**
	 * Retrieve the widget icon.
	*/
	public function get_icon() {
		return 'fa fa-sort-numeric-asc';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	*/
	public function get_categories() {
		return ['helloexpert-category'];
	}

	/**
	 * Retrieve the list of scripts the Arkito Funfact widget depended on.
	 * Used to set scripts dependencies required to run the widget.
	*/
	public function get_script_depends() {
		return ['tmx-arkito_funfact'];
	}
	
	/**
	 * Register Arkito Funfact widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	*/
	protected function _register_controls(){
		
		$this->start_controls_section(
			'section_funfact',
			[
				'label' => esc_html__( 'Funfact Options', 'arkito-core' ),
			]
		);
		$this->add_control(
			'section_title',
			[
				'label' => esc_html__( 'Title Text', 'arkito-core' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'We do big things with big ideas.', 'arkito-core' ),
				'placeholder' => esc_html__( 'Type title text here', 'arkito-core' ),
				'label_block' => true,
			]
		);
		$this->add_control(
			'video_link',
			[
				'label' => esc_html__( 'Video/Link', 'arkito-core' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( '#', 'arkito-core' ),
				'placeholder' => esc_html__( 'Type Video Link here', 'arkito-core' ),
				'label_block' => true,
			]
		);
		$this->add_control(
			'btn_text',
			[
				'label' => esc_html__( 'Button/Link Text', 'arkito-core' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Button Text', 'arkito-core' ),
				'placeholder' => esc_html__( 'Type btn text here', 'arkito-core' ),
				'label_block' => true,
			]
		);
		$this->add_control(
			'btn_link',
			[
				'label' => esc_html__( 'Button Link', 'arkito-core' ),
				'type' => Controls_Manager::URL,
				'placeholder' => 'https://your-link.com',
				'default' => [
					'url' => '',
				],
				'label_block' => true,
			]
		);
		$this->add_control(
			'icon_image',
			[
				'label' => esc_html__( 'Icon Image', 'arkito-core' ),
				'type' => Controls_Manager::MEDIA,
				'frontend_available' => true,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
				'description' => esc_html__( 'Set your icon image.', 'arkito-core'),
			]
		);
		$this->add_control(
			'right_image',
			[
				'label' => esc_html__( 'Right Image', 'arkito-core' ),
				'type' => Controls_Manager::MEDIA,
				'frontend_available' => true,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
				'description' => esc_html__( 'Set your right image.', 'arkito-core'),
			]
		);
		$repeater = new Repeater();
		$repeater->add_control(
			'funfact_title',
			[
				'label' => esc_html__( 'Title Text', 'arkito-core' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Title Text', 'arkito-core' ),
				'placeholder' => esc_html__( 'Type title text here', 'arkito-core' ),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'funfact_number',
			[
				'label' => esc_html__( 'Funfact Number', 'arkito-core' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( '250', 'arkito-core' ),
				'placeholder' => esc_html__( 'Type funfact Number here', 'arkito-core' ),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'funfact_plus',
			[
				'label' => esc_html__( 'Funfact Plus/Percentage', 'arkito-core' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( '+', 'arkito-core' ),
				'placeholder' => esc_html__( 'Type funfact Plus/Percentage here', 'arkito-core' ),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'funfact_image',
			[
				'label' => esc_html__( 'funfact Image', 'arkito-core' ),
				'type' => Controls_Manager::MEDIA,
				'frontend_available' => true,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
				'description' => esc_html__( 'Set your funfact image.', 'arkito-core'),
			]
		);
		$repeater->add_control(
			'funfact_image2',
			[
				'label' => esc_html__( 'funfact Image 2', 'arkito-core' ),
				'type' => Controls_Manager::MEDIA,
				'frontend_available' => true,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
				'description' => esc_html__( 'Set your icon image.', 'arkito-core'),
			]
		);
		$this->add_control(
			'funfactItems_groups',
			[
				'label' => esc_html__( 'Funfact Items', 'arkito-core' ),
				'type' => Controls_Manager::REPEATER,
				'default' => [
					[
						'funfact_title' => esc_html__( 'Funfact', 'arkito-core' ),
					],
					
				],
				'fields' =>  $repeater->get_controls(),
				'title_field' => '{{{ funfact_title }}}',
			]
		);
		$this->end_controls_section();// end: Section
		

		// Funfact Items
		$this->start_controls_section(
			'funfact_sction_style',
			[
				'label' => esc_html__( 'Funfact', 'arkito-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'funfact_box_color',
			[
				'label' => esc_html__( 'BG Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .arkit-status .single-status' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'funfact_box_bg_hover_color',
			[
				'label' => esc_html__( 'BG Hover Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .arkit-status .single-status:hover' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section();// end: Section

		// Funfact Number
		$this->start_controls_section(
			'funfact_number_style',
			[
				'label' => esc_html__( 'Number', 'arkito-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__( 'Typography', 'arkito-core' ),
				'name' => 'arkito_number_typography',
				'selector' => '{{WRAPPER}} .arkit-status .single-status h3',
			]
		);
		$this->add_control(
			'funfact_number_color',
			[
				'label' => esc_html__( 'Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .arkit-status .single-status h3' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'funfact_number_padding',
			[
				'label' => __( 'Number Padding', 'arkito-core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .arkit-status .single-status h3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();// end: Section

		// Funfact Title
		$this->start_controls_section(
			'funfact_title_style',
			[
				'label' => esc_html__( 'Funfact Title', 'arkito-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__( 'Typography', 'arkito-core' ),
				'name' => 'ntrsvt_funfact_title_typography',
				'selector' => '{{WRAPPER}} .arkit-status .single-status p',
			]
		);
		$this->add_control(
			'funfact_title',
			[
				'label' => esc_html__( 'Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .arkit-status .single-status p' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'funfact_title_padding',
			[
				'label' => __( 'Number Padding', 'arkito-core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .arkit-status .single-status p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();// end: Section


		// Funfact Plus
		$this->start_controls_section(
			'funfact_plus_style',
			[
				'label' => esc_html__( 'Funfact Plus', 'arkito-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__( 'Typography', 'arkito-core' ),
				'name' => 'arkito_funfact_plus_typography',
				'selector' => '{{WRAPPER}} .arkit-status .single-status h3 .plus',
			]
		);
		$this->add_control(
			'funfact_plus',
			[
				'label' => esc_html__( 'Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .arkit-status .single-status h3 .plus' => 'color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section();// end: Section


		// Funfact Contact
		$this->start_controls_section(
			'funfact_contact_style',
			[
				'label' => esc_html__( 'Contact', 'arkito-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'funfact_contac_bg',
			[
				'label' => esc_html__( 'BG Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .arkit-status .status-note' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'funfact_contac_title',
			[
				'label' => esc_html__( 'Title Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .arkit-status .status-note h3' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'funfact_btn_color',
			[
				'label' => esc_html__( 'Btn Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .arkit-status .status-note .read-more-btn' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'funfact_btn_br_color',
			[
				'label' => esc_html__( 'Btn Border Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .arkit-status .status-note .read-more-btn' => 'border-color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section();// end: Section


		// Funfact Video Btn
		$this->start_controls_section(
			'funfact_video_btn_style',
			[
				'label' => esc_html__( 'Video', 'arkito-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'funfact_video_btn_bg',
			[
				'label' => esc_html__( 'BG Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .arkit-status .play-btn a' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section();// end: Section

		
	}

	/**
	 * Render Funfact widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	*/
	protected function render() {
		$settings = $this->get_settings_for_display();
		$funfactItems_groups = !empty( $settings['funfactItems_groups'] ) ? $settings['funfactItems_groups'] : [];

		$section_title = !empty( $settings['section_title'] ) ? $settings['section_title'] : '';
		$video_link = !empty( $settings['video_link'] ) ? $settings['video_link'] : '';
		$icon_bg = !empty( $settings['icon_image']['id'] ) ? $settings['icon_image']['id'] : '';	

		// Image
		$icon_url = wp_get_attachment_url( $icon_bg );
		$icon_alt = get_post_meta( $settings['icon_image']['id'], '_wp_attachment_image_alt', true);

		$right_bg = !empty( $settings['right_image']['id'] ) ? $settings['right_image']['id'] : '';	
		// Image
		$right_url = wp_get_attachment_url( $right_bg );
		$right_alt = get_post_meta( $settings['right_image']['id'], '_wp_attachment_image_alt', true);

		$btn_text = !empty( $settings['btn_text'] ) ? $settings['btn_text'] : '';
		$btn_paragraph = !empty( $settings['btn_paragraph'] ) ? $settings['btn_paragraph'] : '';
		$btn_icon = !empty( $settings['btn_icon'] ) ? $settings['btn_icon'] : '';

		$btn_link = !empty( $settings['btn_link']['url'] ) ? $settings['btn_link']['url'] : '';
		$btn_external = !empty( $settings['btn_link']['is_external'] ) ? 'target="_blank"' : '';
		$btn_nofollow = !empty( $settings['btn_link']['nofollow'] ) ? 'rel="nofollow"' : '';
		$btn_link_attr = !empty( $btn_link ) ?  $btn_external.' '.$btn_nofollow : '';

		$button = $btn_link ? '<a href="'.esc_url($btn_link).'" '.esc_attr( $btn_link_attr ).'  class="read-more-btn" >'.esc_html( $btn_text ).'</a>' : '';

		$e_uniqid        = uniqid();
		$inline_style  = '';

		if ( $right_url ) {
		 $inline_style .= '.arkit-status-'.$e_uniqid .'.arkit-status:before {';
		  $inline_style .= $right_url ? 'background-image: url( '.$right_url.' ); ' : '';
		 $inline_style .= '}';
		}

		// add inline style
		add_inline_style( $inline_style );
		$styled_class  = ' arkit-status-'.$e_uniqid;

		// Turn output buffer on
		ob_start();
		?>
		<div class="arkit-status section-padding<?php echo esc_attr( $styled_class ); ?>">
	    <div class="container">
	        <div class="row">
	            <div class="col-lg-6 col-md-6 col-xl-12">
	                <div class="row">
	                  <?php 	// Group Param Output
										if( is_array( $funfactItems_groups ) && !empty( $funfactItems_groups ) ){
										foreach ( $funfactItems_groups as $each_item ) { 

										$funfact_title = !empty( $each_item['funfact_title'] ) ? $each_item['funfact_title'] : '';
										$funfact_number = !empty( $each_item['funfact_number'] ) ? $each_item['funfact_number'] : '';
										$funfact_plus = !empty( $each_item['funfact_plus'] ) ? $each_item['funfact_plus'] : '';

										$bg_image = !empty( $each_item['funfact_image']['id'] ) ? $each_item['funfact_image']['id'] : '';	
										// Image
										$image_url = wp_get_attachment_url( $bg_image );
										$image_alt = get_post_meta( $each_item['funfact_image']['id'], '_wp_attachment_image_alt', true);

										$bg_image2 = !empty( $each_item['funfact_image2']['id'] ) ? $each_item['funfact_image2']['id'] : '';	
										// Image
										$image2_url = wp_get_attachment_url( $bg_image2 );
										$image2_alt = get_post_meta( $each_item['funfact_image2']['id'], '_wp_attachment_image_alt', true);

										?>
	                    <!--/col-->
	                    <div class="col-lg-6 col-sm-6 col-xs-12">
	                        <div class="single-status">
	                            <div class="icon">
	                            <?php 
		                            if( $image_url ) { echo '<img class="img-fluid normal" src="'.esc_url( $image_url ).'" alt="'.esc_url( $image_alt ).'">'; }
		                            if( $image2_url ) { echo '<img class="img-fluid hover" src="'.esc_url( $image2_url ).'" alt="'.esc_url( $image2_alt ).'">'; }
		                           ?>
	                            </div>
	                            <h3>
	                              <?php  
	                                if( $funfact_number ) { 
		           											echo ' <span class="odometer" data-count="'.esc_html( $funfact_number ).'">'.esc_html__( '00','arkito-core' ).'</span>'; } 
	                                if( $funfact_plus ) { echo '<sup><span class="plus">'.esc_html( $funfact_plus ).'</span></sup>';
	                              } ?>
	                            </h3>
	                            <?php if( $funfact_title ) { echo '<p>'.esc_html( $funfact_title ).'</p>'; } ?>
	                        </div>
	                    </div>
	                    <!--/col-->
										<?php }
										} ?>
	                </div>
	                <!--/Row-->
	            </div>
	            <!--/Col-->
	            <div class="col-lg-6 col-md-6 col-xs-12">
	                <div class="status-right">
	                    <div class="play-btn video-btn">
	                    	<?php if ( $video_link ) { ?>
	                    		<a href="<?php echo esc_url( $video_link ); ?>" class="video-btn" data-type="iframe">
	                            <svg height="23px" width="21px" xmlns="http://www.w3.org/2000/svg">
	                                <path d="M17.356,14.514 C13.594,16.657 9.844,18.822 6.106,21.009 C2.369,23.196 0.512,22.124 0.537,17.794 C0.562,13.464 0.562,9.133 0.537,4.803 C0.512,0.473 2.369,-0.598 6.106,1.588 C9.844,3.775 13.594,5.940 17.356,8.083 C21.119,10.227 21.119,12.370 17.356,14.514 Z" fill="rgb(255, 255, 255)" fill-rule="evenodd" />
	                            </svg>
	                        </a>
	                    	<?php } ?>
	                    </div>
	                </div>
	            </div>
	            <!--/Col-->
	        </div>
	        <!--/Row-->
	    </div>
	    <!--/container-->
	    <div class="status-note">
	         <?php if( $section_title ) { echo '<h3>'.esc_html( $section_title ).'</h3>'; } ?>
	        <div class="bottom">
	            <?php echo $button; ?>
	            <div class="icon">
	               <?php if( $icon_url ) { echo '<img src="'.esc_url( $icon_url ).'" alt="'.esc_url( $icon_alt ).'">'; } ?>
	            </div>
	        </div>
	    </div>
	</div>
		<?php
			// Return outbut buffer
			echo ob_get_clean();	
		}
	/**
	 * Render Funfact widget output in the editor.
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	*/
	
	//protected function _content_template(){}
	
}
Plugin::instance()->widgets_manager->register_widget_type( new Arkito_Funfact() );