<?php
/*
 * Arkito Theme's Functions
 * Author & Copyright:helloexpert
 * URL: http://themeforest.net/user/helloexpert
 */

/**
 * Define - Folder Paths
 */

define( 'ARKITO_THEMEROOT_URI', get_template_directory_uri() );
define( 'ARKITO_CSS', ARKITO_THEMEROOT_URI . '/assets/css' );
define( 'ARKITO_IMAGES', ARKITO_THEMEROOT_URI . '/assets/images' );
define( 'ARKITO_SCRIPTS', ARKITO_THEMEROOT_URI . '/assets/js' );
define( 'ARKITO_FRAMEWORK', get_template_directory() . '/includes' );
define( 'ARKITO_LAYOUT', get_template_directory() . '/theme-layouts' );
define( 'ARKITO_CS_IMAGES', ARKITO_THEMEROOT_URI . '/includes/theme-options/framework-extend/images' );
define( 'ARKITO_CS_FRAMEWORK', get_template_directory() . '/includes/theme-options/framework-extend' ); // Called in Icons field *.json
define( 'ARKITO_ADMIN_PATH', get_template_directory() . '/includes/theme-options/cs-framework' ); // Called in Icons field *.json

/**
 * Define - Global Theme Info's
 */
if (is_child_theme()) { // If Child Theme Active
	$arkito_theme_child = wp_get_theme();
	$arkito_get_parent = $arkito_theme_child->Template;
	$arkito_theme = wp_get_theme($arkito_get_parent);
} else { // Parent Theme Active
	$arkito_theme = wp_get_theme();
}
define('ARKITO_NAME', $arkito_theme->get( 'Name' ));
define('ARKITO_VERSION', $arkito_theme->get( 'Version' ));
define('ARKITO_BRAND_URL', $arkito_theme->get( 'AuthorURI' ));
define('ARKITO_BRAND_NAME', $arkito_theme->get( 'Author' ));


/**
 * All Main Files Include
 */

add_action('after_setup_theme', 'arkio_theme_options_setup', 20);
function arkio_theme_options_setup()
{
	require_once(ARKITO_FRAMEWORK . '/init.php');
}