<?php
/*
 * The template for displaying all pages.
 * Author & Copyright: helloexpert
 * URL: http://themeforest.net/user/helloexpert
 */
$arkito_id    = ( isset( $post ) ) ? $post->ID : 0;
$arkito_id    = ( is_home() ) ? get_option( 'page_for_posts' ) : $arkito_id;
$arkito_meta  = get_post_meta( $arkito_id, 'page_type_metabox', true );
if ( $arkito_meta ) {
	$arkito_content_padding = $arkito_meta['content_spacings'];
} else { $arkito_content_padding = 'section-padding'; }
// Top and Bottom Padding
if ( $arkito_content_padding && $arkito_content_padding !== 'padding-default' ) {
	$arkito_content_top_spacings = isset( $arkito_meta['content_top_spacings'] ) ? $arkito_meta['content_top_spacings'] : '';
	$arkito_content_bottom_spacings = isset( $arkito_meta['content_bottom_spacings'] ) ? $arkito_meta['content_bottom_spacings'] : '';
	if ( $arkito_content_padding === 'padding-custom' ) {
		$arkito_content_top_spacings = $arkito_content_top_spacings ? 'padding-top:'. arkito_check_px( $arkito_content_top_spacings ) .';' : '';
		$arkito_content_bottom_spacings = $arkito_content_bottom_spacings ? 'padding-bottom:'. arkito_check_px($arkito_content_bottom_spacings) .';' : '';
		$arkito_custom_padding = $arkito_content_top_spacings . $arkito_content_bottom_spacings;
	} else {
		$arkito_custom_padding = '';
	}
	$padding_class = '';
} else {
	$arkito_custom_padding = '';
	$padding_class = '';
}

// Page Layout
$page_layout_options = get_post_meta( get_the_ID(), 'page_layout_options', true );
if ( $page_layout_options ) {
	$arkito_page_layout = $page_layout_options['page_layout'];
	$page_sidebar_widget = $page_layout_options['page_sidebar_widget'];
} else {
	$arkito_page_layout = 'right-sidebar';
	$page_sidebar_widget = '';
}
$page_sidebar_widget = $page_sidebar_widget ? $page_sidebar_widget : 'sidebar-1';
if ( $arkito_page_layout === 'extra-width' ) {
	$arkito_page_column = 'extra-width';
	$arkito_page_container = 'container-fluid';
} elseif ( $arkito_page_layout === 'full-width' ) {
	$arkito_page_column = 'col-md-12';
	$arkito_page_container = 'container ';
} elseif( ( $arkito_page_layout === 'left-sidebar' || $arkito_page_layout === 'right-sidebar' ) && is_active_sidebar( $page_sidebar_widget ) ) {
	if( $arkito_page_layout === 'left-sidebar' ){
		$arkito_page_column = 'col-md-8 order-12';
	} else {
		$arkito_page_column = 'col-md-8';
	}
	$arkito_page_container = 'container ';
} else {
	$arkito_page_column = 'col-md-12';
	$arkito_page_container = 'container ';
}
$arkito_theme_page_comments = cs_get_option( 'theme_page_comments' );
get_header();
?>
<div class="page-wrap <?php echo esc_attr( $padding_class ); ?>">
	<div class="<?php echo esc_attr( $arkito_page_container.''.$arkito_content_padding.' '.$arkito_page_layout ); ?>" style="<?php echo esc_attr( $arkito_custom_padding ); ?>">
		<div class="row">
			<div class="<?php echo esc_attr( $arkito_page_column ); ?>">
				<div class="page-wraper clearfix">
				<?php
				while ( have_posts() ) : the_post();
					the_content();
					if ( !$arkito_theme_page_comments && ( comments_open() || get_comments_number() ) ) :
						comments_template();
					endif;
				endwhile; // End of the loop.
				?>
				</div>
				<div class="page-link-wrap">
					<?php arkito_wp_link_pages(); ?>
				</div>
			</div>
			<?php
			// Sidebar
			if( ($arkito_page_layout === 'left-sidebar' || $arkito_page_layout === 'right-sidebar') && is_active_sidebar( $page_sidebar_widget )  ) {
				get_sidebar();
			}
			?>
		</div>
	</div>
</div>
<?php
get_footer();