<?php
/*
 * The template for displaying all single posts.
 * Author & Copyright: helloexpert
 * URL: http://themeforest.net/user/helloexpert
 */
get_header();
	// Metabox
	$arkito_id    = ( isset( $post ) ) ? $post->ID : 0;
	$arkito_id    = ( is_home() ) ? get_option( 'page_for_posts' ) : $arkito_id;
	$arkito_id    = ( is_woocommerce_shop() ) ? wc_get_page_id( 'shop' ) : $arkito_id;
	$arkito_meta  = get_post_meta( $arkito_id, 'page_type_metabox', true );
	if ( $arkito_meta ) {
		$arkito_content_padding = $arkito_meta['content_spacings'];
	} else { $arkito_content_padding = ''; }
	// Padding - Metabox
	if ( $arkito_content_padding && $arkito_content_padding !== 'padding-default' ) {
		$arkito_content_top_spacings = $arkito_meta['content_top_spacings'];
		$arkito_content_bottom_spacings = $arkito_meta['content_bottom_spacings'];
		if ( $arkito_content_padding === 'padding-custom' ) {
			$arkito_content_top_spacings = $arkito_content_top_spacings ? 'padding-top:'. arkito_check_px($arkito_content_top_spacings) .';' : '';
			$arkito_content_bottom_spacings = $arkito_content_bottom_spacings ? 'padding-bottom:'. arkito_check_px($arkito_content_bottom_spacings) .';' : '';
			$arkito_custom_padding = $arkito_content_top_spacings . $arkito_content_bottom_spacings;
		} else {
			$arkito_custom_padding = '';
		}
	} else {
		$arkito_custom_padding = '';
	}
	// Theme Options
	$arkito_sidebar_position = cs_get_option( 'project_sidebar_position' );
	$arkito_single_comment = cs_get_option( 'project_comment_form' );
	$arkito_sidebar_position = $arkito_sidebar_position ? $arkito_sidebar_position : 'sidebar-hide';
	// Sidebar Position
	if ( $arkito_sidebar_position === 'sidebar-hide' ) {
		$arkito_layout_class = 'col col-lg-10 col-lg-offset-1';
		$arkito_sidebar_class = 'hide-sidebar';
	} elseif ( $arkito_sidebar_position === 'sidebar-left' ) {
		$arkito_layout_class = 'col col-lg-9 col-lg-push-3';
		$arkito_sidebar_class = 'left-sidebar';
	} else {
		$arkito_layout_class = 'col-lg-9';
		$arkito_sidebar_class = 'right-sidebar';
	} ?>
<div class="project-single-section section-padding <?php echo esc_attr( $arkito_content_padding .' '. $arkito_sidebar_class ); ?>" style="<?php echo esc_attr( $arkito_custom_padding ); ?>">
	<div class="container">
		<div class="row">
			<div class="<?php echo esc_attr( $arkito_layout_class ); ?>">
				<div class="project-single-content">
					<?php
					if ( have_posts() ) :
						/* Start the Loop */
						while ( have_posts() ) : the_post();
							if ( post_password_required() ) {
									echo '<div class="password-form">'.get_the_password_form().'</div>';
								} else {
									get_template_part( 'theme-layouts/post/project', 'content' );
									$arkito_single_comment = !$arkito_single_comment ? comments_template() : '';

								}
						endwhile;
					else :
						get_template_part( 'theme-layouts/post/content', 'none' );
					endif; ?>
				</div><!-- Blog Div -->
				<?php
		    wp_reset_postdata(); ?>
			</div><!-- Content Area -->
				<?php
				if ( $arkito_sidebar_position !== 'sidebar-hide' ) {
					get_sidebar(); // Sidebar
				} ?>
		</div>
	</div>
</div>
<?php
get_footer();