<?php
// Metabox
global $post;
$arkito_id    = ( isset( $post ) ) ? $post->ID : false;
$arkito_id    = ( is_home() ) ? get_option( 'page_for_posts' ) : $arkito_id;
$arkito_id    = ( is_woocommerce_shop() ) ? wc_get_page_id( 'shop' ) : $arkito_id;
$arkito_id    = ( ! is_tag() && ! is_archive() && ! is_search() && ! is_404() && ! is_singular('service') ) ? $arkito_id : false;
$arkito_meta  = get_post_meta( $arkito_id, 'page_type_metabox', true );
// Header Style
if ( $arkito_meta ) {
  $arkito_header_design  = $arkito_meta['select_header_design'];
} else {
  $arkito_header_design  = cs_get_option( 'select_header_design' );
}

if ( $arkito_header_design === 'default' ) {
  $arkito_header_design_actual  = cs_get_option( 'select_header_design' );
} else {
  $arkito_header_design_actual = ( $arkito_header_design ) ? $arkito_header_design : cs_get_option('select_header_design');
}
$arkito_header_design_actual = $arkito_header_design_actual ? $arkito_header_design_actual : 'style_two';

$arkito_logo = cs_get_option( 'arkito_logo' );
$arkito_trlogo = cs_get_option( 'arkito_trlogo' );

$logo_url = wp_get_attachment_url( $arkito_logo );
$logo_alt = get_post_meta( $arkito_logo, '_wp_attachment_image_alt', true );

$trlogo_url = wp_get_attachment_url( $arkito_trlogo );
$trlogo_alt = get_post_meta( $arkito_trlogo, '_wp_attachment_image_alt', true );

if ( $logo_url ) {
  $logo_url = $logo_url;
} else {
 $logo_url = ARKITO_IMAGES.'/logo.png';
}

if ( $trlogo_url ) {
  $trlogo_url = $trlogo_url;
} else {
 $trlogo_url = ARKITO_IMAGES.'/tr-logo.png';
}


if ( $arkito_header_design_actual == 'style_one' ) {
  $arkito_logo_url = $trlogo_url;
  $arkito_logo_alt = $trlogo_alt;
} else {
  $arkito_logo_url = $logo_url;
  $arkito_logo_alt = $logo_alt;
}

if ( has_nav_menu( 'primary' ) ) {
  $logo_padding = ' has_menu ';
}
else {
   $logo_padding = ' dont_has_menu ';
}


// Logo Spacings
// Logo Spacings
$arkito_brand_logo_top = cs_get_option( 'arkito_logo_top' );
$arkito_brand_logo_bottom = cs_get_option( 'arkito_logo_bottom' );
if ( $arkito_brand_logo_top ) {
  $arkito_brand_logo_top = 'padding-top:'. arkito_check_px( $arkito_brand_logo_top ) .';';
} else { $arkito_brand_logo_top = ''; }
if ( $arkito_brand_logo_bottom ) {
  $arkito_brand_logo_bottom = 'padding-bottom:'. arkito_check_px( $arkito_brand_logo_bottom ) .';';
} else { $arkito_brand_logo_bottom = ''; }
?>
<div class="site-logo <?php echo esc_attr( $logo_padding ); ?>"  style="<?php echo esc_attr( $arkito_brand_logo_top ); echo esc_attr( $arkito_brand_logo_bottom ); ?>">
   <?php if ( $arkito_logo ) {
    ?>
      <a class="navbar-brand" href="<?php echo esc_url( home_url( '/' ) ); ?>">
       <img src="<?php echo esc_url( $arkito_logo_url ); ?>" alt=" <?php echo esc_attr( $arkito_logo_alt ); ?>">
     </a>
   <?php } elseif( has_custom_logo() ) {
      the_custom_logo();
    } else {
    ?>
    <a class="navbar-brand" href="<?php echo esc_url( home_url( '/' ) ); ?>">
       <img src="<?php echo esc_url( $arkito_logo_url ); ?>" alt="<?php echo get_bloginfo('name'); ?>">
     </a>
   <?php
  } ?>
</div>