<?php
  // Metabox
  $arkito_id    = ( isset( $post ) ) ? $post->ID : 0;
  $arkito_id    = ( is_home() ) ? get_option( 'page_for_posts' ) : $arkito_id;
  $arkito_id    = ( is_woocommerce_shop() ) ? wc_get_page_id( 'shop' ) : $arkito_id;
  $arkito_id    = ( ! is_tag() && ! is_archive() && ! is_search() && ! is_404() && ! is_singular('testimonial') ) ? $arkito_id : false;
  $arkito_meta  = get_post_meta( $arkito_id, 'page_type_metabox', true );

  // Header Style
  if ( $arkito_meta ) {
    $arkito_header_design  = $arkito_meta['select_header_design'];
    $arkito_sticky_header = isset( $arkito_meta['sticky_header'] ) ? $arkito_meta['sticky_header'] : '' ;
    $arkito_search = isset( $arkito_meta['arkito_search'] ) ? $arkito_meta['arkito_search'] : '';
  } else {
    $arkito_header_design  = cs_get_option( 'select_header_design' );
    $arkito_sticky_header  = cs_get_option( 'sticky_header' );
    $arkito_search  = cs_get_option( 'arkito_search' );
  }

  $arkito_cart_widget  = cs_get_option( 'arkito_cart_widget' );

  if ( $arkito_header_design === 'default' ) {
    $arkito_header_design_actual  = cs_get_option( 'select_header_design' );
  } else {
    $arkito_header_design_actual = ( $arkito_header_design ) ? $arkito_header_design : cs_get_option('select_header_design');
  }
  $arkito_header_design_actual = $arkito_header_design_actual ? $arkito_header_design_actual : 'style_two';

  if ( $arkito_meta && $arkito_header_design !== 'default') {
   $arkito_search = isset( $arkito_meta['arkito_search'] ) ? $arkito_meta['arkito_search'] : '';
  } else {
    $arkito_search  = cs_get_option( 'arkito_search' );
  }

  if ( $arkito_header_design_actual == 'style_two' ) { 
    $menu_container = 'container-fluid';
  } else {
    $menu_container = 'container-fluid';
  }

  if ( $arkito_cart_widget ) {
    $cart_class = 'has-cart ';
  } else {
    $cart_class = 'not-has-cart ';
  }
  if ( $arkito_search ) {
   $search_class = 'not-has-search ';
  } else {
    $search_class = 'has-search ';
  }
  if ( has_nav_menu( 'primary' ) ) {
     $menu_padding = ' has-menu ';
  } else {
     $menu_padding = ' dont-has-menu ';
  }
  if ($arkito_meta) {
    $arkito_choose_menu = $arkito_meta['choose_menu'];
  } else { $arkito_choose_menu = ''; }
  $arkito_choose_menu = $arkito_choose_menu ? $arkito_choose_menu : '';

?>
<!-- Navigation & Search -->
 <div class="<?php echo esc_attr( $menu_container ); ?>">
    <div class="navbar-header">
        <button type="button" class="open-btn">
            <span class="sr-only"><?php echo esc_html__( 'Toggle navigation','arkito' ) ?></span>
            <span class="icon-bar"></span>
            <span class="icon-bar"></span>
            <span class="icon-bar"></span>
        </button>
        <?php get_template_part( 'theme-layouts/header/logo' ); ?>
    </div>
    <div id="navbar" class="navbar-collapse collapse navigation-holder navbar-left <?php echo esc_attr( $menu_padding.$cart_class.$search_class ); ?>">
     <button class="close-navbar"><i class="ti-close"></i></button>
       <?php
          wp_nav_menu(
            array(
              'menu'              => 'primary',
              'theme_location'    => 'primary',
              'container'         => '',
              'container_class'   => '',
              'container_id'      => '',
              'menu'              => $arkito_choose_menu,
              'menu_class'        => 'nav navbar-nav menu nav-menu',
              'fallback_cb'       => '__return_false',
            )
          );
        ?>
      </div><!-- end of nav-collapse -->
      <?php get_template_part( 'theme-layouts/header/search','bar' ); ?>
  </div><!-- end of container -->


