/*
Template Name: Arkito
Author: helloexpert
Version: 1.0
*/

(function($){
'use strict';

/*----- ELEMENTOR LOAD FUNTION CALL ---*/

$( window ).on( 'elementor/frontend/init', function() {

	var swiper_slide = function(){
	 
     // SLIDER
    var menu = [];
    jQuery('.swiper-slide').each(function (index) {
        menu.push(jQuery(this).find('.slide-inner').attr("data-text"));
    });
    var interleaveOffset = 0.5;
    var swiperOptions = {
        loop: true,
        speed: 1000,
        parallax: true,
        autoplay: {
            delay: 6500,
            disableOnInteraction: false,
        },

        watchSlidesProgress: true,

        pagination: {
            el: '.swiper-pagination',
            clickable: true,
        },

        navigation: {
            nextEl: '.swiper-button-next',
            prevEl: '.swiper-button-prev',
        },

        on: {
            progress: function () {
                var swiper = this;
                for (var i = 0; i < swiper.slides.length; i++) {
                    var slideProgress = swiper.slides[i].progress;
                    var innerOffset = swiper.width * interleaveOffset;
                    var innerTranslate = slideProgress * innerOffset;
                    swiper.slides[i].querySelector(".slide-inner").style.transform =
                        "translate3d(" + innerTranslate + "px, 0, 0)";
                }
            },

            touchStart: function () {
                var swiper = this;
                for (var i = 0; i < swiper.slides.length; i++) {
                    swiper.slides[i].style.transition = "";
                }
            },

            setTransition: function (speed) {
                var swiper = this;
                for (var i = 0; i < swiper.slides.length; i++) {
                    swiper.slides[i].style.transition = speed + "ms";
                    swiper.slides[i].querySelector(".slide-inner").style.transition =
                        speed + "ms";
                }
            }
        }
    };

    var swiper = new Swiper(".swiper-container", swiperOptions);

	}; // end



    // sliderBgSetting

    var sliderBgSetting = function(){
        // DATA BACKGROUND IMAGE
        var sliderBgSetting = $(".slide-bg-image");
        sliderBgSetting.each(function (indx) {
            if ($(this).attr("data-background")) {
                $(this).css("background-image", "url(" + $(this).data("background") + ")");
            }
        });

        

    }; // end



    var service_slider = function(){

       /*------------------------------------------
        = PARTNERS SLIDER
        -------------------------------------------*/
        if ($(".service-slider").length) {
            $(".service-slider").owlCarousel({
                autoplay: true,
                smartSpeed: 1200,
                margin: 30,
                loop: true,
                autoplayHoverPause: true,
                nav: false,
                dots: true,
                responsive: {
                    0: {
                        items: 1
                    },

                    550: {
                        items: 2
                    },

                    992: {
                        items: 3
                    },
                }
            });
        }
    }; // end



    var portfolio_slider = function(){

        /*------------------------------------------
        = PORTFOLIO SLIDER
        -------------------------------------------*/
        if ($(".work-portfolio-slider").length) {
            $(".work-portfolio-slider").owlCarousel({
                autoplay: true,
                smartSpeed: 1200,
                margin: 30,
                loop: true,
                autoplayHoverPause: true,
                nav: true,
                navText: ['<i class="ti-angle-left"></i> <span>PREVIOUS PROJECT</span>', '<span>NEXT PROJECT</span> <i class="ti-angle-right"></i>'],
                dots: false,
                responsive: {
                    0: {
                        items: 1
                    },

                    550: {
                        items: 2
                    },

                    992: {
                        items: 3
                    },

                    1200: {
                        items: 4
                    },
                }
            });
        }

    }; // end



    var testimonials_slider = function(){
     
         /*------------------------------------------
        = TESTIMONIAL SLIDER
        -------------------------------------------*/
        if ($(".testimonial-slider").length) {
            $(".testimonial-slider").owlCarousel({
                autoplay: true,
                smartSpeed: 1200,
                margin: 30,
                loop: true,
                nav: false,
                dots: true,
                items: 1,
            });
        }



    }; // end


    
    var odometer = function(){

       /*------------------------------------------
        = FUNFACT
        -------------------------------------------*/
        if ($(".odometer").length) {
            $('.odometer').appear();
            $(document.body).on('appear', '.odometer', function(e) {
                var odo = $(".odometer");
                odo.each(function() {
                    var countNumber = $(this).attr("data-count");
                    $(this).html(countNumber);
                });
            });
        }



    }; // end


    var team_slider = function(){

       /*------------------------------------------
        = TEAM SLIDER
        -------------------------------------------*/
        if ($(".team-slider").length) {
            $(".team-slider").owlCarousel({
                autoplay: false,
                smartSpeed: 300,
                margin: 0,
                loop:true,
                autoplayHoverPause:true,
                dots: false,
                nav: true,
                navText: ['<i class="fi flaticon-back"></i>','<i class="fi flaticon-next-1"></i>'],
                responsive: {
                    0 : {
                        items: 1
                    },

                    600 : {
                        items: 2
                    },

                    768 : {
                        items: 3
                    },

                    1200 : {
                        items: 4
                    }
                }
            });
        }



    }; // end


    var partners_slider = function(){

        if ($(".clents-slider").length) {
            $('.clents-slider').owlCarousel({
                loop: true,
                margin: 0,
                nav: false,
                dots:false,
                autoplay: true,
                smartSpeed:1200,
                autoplayHoverPause: true,
                responsive: {
                    0: {
                        items: 1
                    },
                    600: {
                        items: 3
                    },
                    1000: {
                        items: 6
                    }
                }
            })
        }

    }; // end




    


	//Slider
	elementorFrontend.hooks.addAction( 'frontend/element_ready/tmx-arkito_slider.default', function($scope, $){
		swiper_slide();
	} );


    //sliderBgSetting
    elementorFrontend.hooks.addAction( 'frontend/element_ready/tmx-arkito_slider.default', function($scope, $){
        sliderBgSetting();
    } );


    //service_slider
    elementorFrontend.hooks.addAction( 'frontend/element_ready/tmx-arkito_service.default', function($scope, $){
        service_slider();
    } );

    //portfolio_slider
    elementorFrontend.hooks.addAction( 'frontend/element_ready/tmx-arkito_project.default', function($scope, $){
        portfolio_slider();
    } );


    //team_slider
    elementorFrontend.hooks.addAction( 'frontend/element_ready/tmx-arkito_team.default', function($scope, $){
        team_slider();
    } );


    //testimonial
    elementorFrontend.hooks.addAction( 'frontend/element_ready/tmx-arkito_testimonial.default', function($scope, $){
        testimonials_slider();
    } );

    //odometer
    elementorFrontend.hooks.addAction( 'frontend/element_ready/tmx-arkito_funfact.default', function($scope, $){
        odometer();
    } );


    //partners_slider
    elementorFrontend.hooks.addAction( 'frontend/element_ready/tmx-arkito_client.default', function($scope, $){
        partners_slider();
    } );


    
	
	
} );


})(jQuery);  