<?php
/*
 * Elementor Arkito About Widget
 * Author & Copyright: helloexpert
*/

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Arkito_About extends Widget_Base{

	/**
	 * Retrieve the widget name.
	*/
	public function get_name(){
		return 'tmx-arkito_about';
	}

	/**
	 * Retrieve the widget title.
	*/
	public function get_title(){
		return esc_html__( 'About', 'arkito-core' );
	}

	/**
	 * Retrieve the widget icon.
	*/
	public function get_icon() {
		return 'fa fa-address-card';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	*/
	public function get_categories() {
		return ['helloexpert-category'];
	}

	/**
	 * Retrieve the list of scripts the Arkito About widget depended on.
	 * Used to set scripts dependencies required to run the widget.
	*/
	public function get_script_depends() {
		return ['tmx-arkito_about'];
	}
	
	/**
	 * Register Arkito About widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	*/
	protected function _register_controls(){
		
		$this->start_controls_section(
			'section_about',
			[
				'label' => esc_html__( 'About Options', 'arkito-core' ),
			]
		);
		$this->add_control(
			'about_subtitle',
			[
				'label' => esc_html__( 'Sub Title Text', 'arkito-core' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'About Our Company', 'arkito-core' ),
				'placeholder' => esc_html__( 'Sub Type title text here', 'arkito-core' ),
				'label_block' => true,
			]
		);
		$this->add_control(
			'about_title',
			[
				'label' => esc_html__( 'Title Text', 'arkito-core' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Title Text', 'arkito-core' ),
				'placeholder' => esc_html__( 'Type title text here', 'arkito-core' ),
				'label_block' => true,
			]
		);
		$this->add_control(
			'about_content',
			[
				'label' => esc_html__( 'Content', 'arkito-core' ),
				'default' => esc_html__( 'your content text', 'arkito-core' ),
				'placeholder' => esc_html__( 'Type your content here', 'arkito-core' ),
				'type' => Controls_Manager::TEXTAREA,
				'label_block' => true,
			]
		);
		$this->add_control(
			'about_image',
			[
				'label' => esc_html__( 'About Image', 'arkito-core' ),
				'type' => Controls_Manager::MEDIA,
				'frontend_available' => true,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
				'description' => esc_html__( 'Set your image.', 'arkito-core'),
			]
		);
		$this->add_control(
			'contact_info',
			[
				'label' => esc_html__( 'Contact Info', 'arkito-core' ),
				'default' => esc_html__( 'Call Us Now:', 'arkito-core' ),
				'placeholder' => esc_html__( 'Type your info here', 'arkito-core' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);
		$this->add_control(
			'contact_number',
			[
				'label' => esc_html__( 'Contact Number', 'arkito-core' ),
				'default' => esc_html__( '+00 864 695 734', 'arkito-core' ),
				'placeholder' => esc_html__( 'Type your Number here', 'arkito-core' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);
		$this->add_control(
			'contact_image',
			[
				'label' => esc_html__( 'Icon Image', 'arkito-core' ),
				'type' => Controls_Manager::MEDIA,
				'frontend_available' => true,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
				'description' => esc_html__( 'Set your icon image.', 'arkito-core'),
			]
		);
	 $this->end_controls_section();// end: Section


		// Sub Title
		$this->start_controls_section(
			'section_subtitle_style',
			[
				'label' => esc_html__( 'Sub Title', 'arkito-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__( 'Typography', 'arkito-core' ),
				'name' => 'sub_title_typography',
				'selector' => '{{WRAPPER}} .arkit-about-inner > span',
			]
		);
		$this->add_control(
			'subtitle_color',
			[
				'label' => esc_html__( 'Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .arkit-about-inner > span' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'subtitle_padding',
			[
				'label' => __( 'Sub Title Padding', 'arkito-core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .arkit-about-inner > span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();// end: Section
	
		// Title
		$this->start_controls_section(
			'section_title_style',
			[
				'label' => esc_html__( 'Title', 'arkito-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__( 'Typography', 'arkito-core' ),
				'name' => 'arkito_title_typography',
				'selector' => '{{WRAPPER}} .arkit-about-inner h2',
			]
		);
		$this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .arkit-about-inner h2' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'title_padding',
			[
				'label' => esc_html__( 'Title Padding', 'arkito-core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .arkit-about-inner h2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();// end: Section

		// Content
		$this->start_controls_section(
			'section_content_style',
			[
				'label' => esc_html__( 'Content', 'arkito-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__( 'Typography', 'arkito-core' ),
				'name' => 'section_content_typography',
				'selector' => '{{WRAPPER}} .arkit-about-inner p',
			]
		);
		$this->add_control(
			'content_color',
			[
				'label' => esc_html__( 'Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .arkit-about-inner p' => 'color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section();// end: Section

		// Info Title
		$this->start_controls_section(
			'section_info_title_style',
			[
				'label' => esc_html__( 'Info Title', 'arkito-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__( 'Typography', 'arkito-core' ),
				'name' => 'arkito_info_title_typography',
				'selector' => '{{WRAPPER}} .arkit-about-inner .contact-number span',
			]
		);
		$this->add_control(
			'info_title_color',
			[
				'label' => esc_html__( 'Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .arkit-about-inner .contact-number span' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'info_title_padding',
			[
				'label' => esc_html__( 'Title Padding', 'arkito-core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .arkit-about-inner .contact-number span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();// end: Section


		// Content
		$this->start_controls_section(
			'section_number_style',
			[
				'label' => esc_html__( 'number', 'arkito-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__( 'Typography', 'arkito-core' ),
				'name' => 'section_number_typography',
				'selector' => '{{WRAPPER}} .arkit-about-inner .contact-number h4',
			]
		);
		$this->add_control(
			'number_color',
			[
				'label' => esc_html__( 'Number Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .arkit-about-inner .contact-number h4' => 'color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section();// end: Section


		// Info 
		$this->start_controls_section(
			'section_info_icon_style',
			[
				'label' => esc_html__( 'Info', 'arkito-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'info_icon_line_color',
			[
				'label' => esc_html__( 'Info BG Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .arkit-about-inner .contact-number' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section();// end: Section

	}

	/**
	 * Render About widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	*/
	protected function render() {
		$settings = $this->get_settings_for_display();

		$about_subtitle = !empty( $settings['about_subtitle'] ) ? $settings['about_subtitle'] : '';
		$about_title = !empty( $settings['about_title'] ) ? $settings['about_title'] : '';
		$about_content = !empty( $settings['about_content'] ) ? $settings['about_content'] : '';
		$bg_image = !empty( $settings['about_image']['id'] ) ? $settings['about_image']['id'] : '';	
		$icon_image = !empty( $settings['contact_image']['id'] ) ? $settings['contact_image']['id'] : '';	
  
		// Image
		$image_url = wp_get_attachment_url( $bg_image );
		$image_alt = get_post_meta( $settings['about_image']['id'], '_wp_attachment_image_alt', true);

		// Icon
		$icon_url = wp_get_attachment_url( $icon_image );
		$icon_alt = get_post_meta( $settings['contact_image']['id'], '_wp_attachment_image_alt', true);

		$contact_info = !empty( $settings['contact_info'] ) ? $settings['contact_info'] : '';
		$contact_number = !empty( $settings['contact_number'] ) ? $settings['contact_number'] : '';


		// Turn output buffer on
		ob_start(); ?>
		<div class="arkit-about">
	    <div class="row display-flex">
	        <div class="col-lg-5 col-md-6 col-xs-12">
	            <div class="arkit-about-inner">
	                <?php 
			            	if( $about_subtitle ) { echo '<span>'.esc_html( $about_subtitle ).'</span>'; }
			            	if( $about_title ) { echo '<h2>'.esc_html( $about_title ).'</h2>'; }
			            	if( $about_content ) { echo '<p>'.esc_html( $about_content ).'</p>'; }
			             ?>
	                <div class="contact-number">
	                    <div class="content">
	                       <?php 
						            	if( $contact_info ) { echo '<span>'.esc_html( $contact_info ).'</span>'; }
						            	if( $contact_number ) { echo '<h4>'.esc_html( $contact_number ).'</h4>'; }
						             ?>
	                    </div>
	                    <div class="icon">
	                        <?php if( $icon_url ) { echo '<img src="'.esc_url( $icon_url ).'" alt="'.esc_url( $icon_alt ).'">'; } ?>
	                    </div>
	                </div>
	            </div>
	        </div>
	        <!--/col-->
	        <div class="col-lg-7 col-md-6 col-xl-12">
	            <div class="about-img">
	                <?php if( $image_url ) { echo '<img src="'.esc_url( $image_url ).'" alt="'.esc_url( $image_alt ).'">'; } ?>
	            </div>
	        </div>
	    </div>
	</div>
	<?php
			echo ob_get_clean();	
		}
	/**
	 * Render About widget output in the editor.
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	*/
	
	//protected function _content_template(){}
	
}
Plugin::instance()->widgets_manager->register_widget_type( new Arkito_About() );