<?php
/*
 * Elementor Arkito Feature Widget
 * Author & Copyright: helloexpert
*/

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Arkito_Feature extends Widget_Base{

	/**
	 * Retrieve the widget name.
	*/
	public function get_name(){
		return 'tmx-arkito_feature';
	}

	/**
	 * Retrieve the widget title.
	*/
	public function get_title(){
		return esc_html__( 'Feature', 'arkito-core' );
	}

	/**
	 * Retrieve the widget icon.
	*/
	public function get_icon() {
		return 'fa fa-file-signature';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	*/
	public function get_categories() {
		return ['helloexpert-category'];
	}

	/**
	 * Retrieve the list of scripts the Arkito Feature widget depended on.
	 * Used to set scripts dependencies required to run the widget.
	*/
	public function get_script_depends() {
		return ['tmx-arkito_feature'];
	}
	
	/**
	 * Register Arkito Feature widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	*/
	protected function _register_controls(){
		
		$this->start_controls_section(
			'section_feature',
			[
				'label' => esc_html__( 'Feature Options', 'arkito-core' ),
			]
		);
		$repeater = new Repeater();
		$repeater->add_control(
			'feature_subtitle',
			[
				'label' => esc_html__( 'Sub Title Text', 'arkito-core' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( '24/07 support', 'arkito-core' ),
				'placeholder' => esc_html__( 'Type title text here', 'arkito-core' ),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'feature_title',
			[
				'label' => esc_html__( 'Title Text', 'arkito-core' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( '24/7 customer support.', 'arkito-core' ),
				'placeholder' => esc_html__( 'Type title text here', 'arkito-core' ),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'feature_content',
			[
				'label' => esc_html__( 'Content', 'arkito-core' ),
				'default' => esc_html__( 'your content text', 'arkito-core' ),
				'placeholder' => esc_html__( 'Type your content here', 'arkito-core' ),
				'type' => Controls_Manager::TEXTAREA,
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'feature_link',
			[
				'label' => esc_html__( 'link', 'arkito-core' ),
				'default' => esc_html__( '#', 'arkito-core' ),
				'placeholder' => esc_html__( 'Type your link here', 'arkito-core' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
			]
		);
		$this->add_control(
			'featureItems_groups',
			[
				'label' => esc_html__( 'Feature Icons', 'arkito-core' ),
				'type' => Controls_Manager::REPEATER,
				'default' => [
					[
						'feature_title' => esc_html__( 'Feature', 'arkito-core' ),
					],
					
				],
				'fields' =>  $repeater->get_controls(),
				'title_field' => '{{{ feature_title }}}',
			]
		);
		$this->end_controls_section();// end: Section
		

		$this->start_controls_section(
			'section_feature_section_style',
			[
				'label' => esc_html__( 'Feature Hover BG', 'arkito-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]

		);
		$this->add_control(
			'feature_item_color',
			[
				'label' => esc_html__( 'Border Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .arkit-service-info-single' => 'border-color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'feature_item_hover_br_color',
			[
				'label' => esc_html__( 'Hover Border Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .arkit-service-info-single:hover' => 'border-color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'feature_bg_hover_color',
			[
				'label' => esc_html__( 'BG Hover Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .arkit-service-info-single:hover' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section();// end: Section
		
		// Subtitle
		$this->start_controls_section(
			'section_subtitle_style',
			[
				'label' => esc_html__( 'SubTitle', 'arkito-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__( 'Typography', 'arkito-core' ),
				'name' => 'arkito_sub_typography',
				'selector' => '{{WRAPPER}} .arkit-service-info-single span',
			]
		);
		$this->add_control(
			'subtitle_color',
			[
				'label' => esc_html__( 'Subtitle Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .arkit-service-info-single span' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'subtitle_bg_color',
			[
				'label' => esc_html__( 'Subtitle BG Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .arkit-service-info-single span' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'icon_hover_color',
			[
				'label' => esc_html__( 'Icon Hover Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
				'{{WRAPPER}} .arkit-service-info-single:hover span' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'icon_bg_hover_color',
			[
				'label' => esc_html__( 'Icon BG Hover Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .arkit-service-info-single:hover span' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section();// end: Section
		
		// Title
		$this->start_controls_section(
			'section_title_style',
			[
				'label' => esc_html__( 'Title', 'arkito-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__( 'Typography', 'arkito-core' ),
				'name' => 'arkito_title_typography',
				'selector' => '{{WRAPPER}} .arkit-service-info-single h2',
			]
		);
		$this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .arkit-service-info-single h2 a' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'title_padding',
			[
				'label' => __( 'Title Padding', 'arkito-core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .arkit-service-info-single h2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();// end: Section

	// Content
		$this->start_controls_section(
			'section_content_style',
			[
				'label' => esc_html__( 'Content', 'arkito-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__( 'Typography', 'arkito-core' ),
				'name' => 'section_content_typography',
				'selector' => '{{WRAPPER}} .arkit-service-info-single p',
			]
		);
		$this->add_control(
			'content_color',
			[
				'label' => esc_html__( 'Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .arkit-service-info-single p' => 'color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section();// end: Section
		
	}

	/**
	 * Render Feature widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	*/
	protected function render() {
		$settings = $this->get_settings_for_display();
		$featureItems_groups = !empty( $settings['featureItems_groups'] ) ? $settings['featureItems_groups'] : [];

		// Turn output buffer on
		ob_start(); ?>
		<div class="arkit-service-info">
	    <div class="row">
		      <?php
		      	$id = 0;
        		// Group Param Output
						if( is_array( $featureItems_groups ) && !empty( $featureItems_groups ) ){
						foreach ( $featureItems_groups as $each_item ) { 	
						$id++;
						$feature_subtitle = !empty( $each_item['feature_subtitle'] ) ? $each_item['feature_subtitle'] : '';
						$feature_title = !empty( $each_item['feature_title'] ) ? $each_item['feature_title'] : '';
						$feature_content = !empty( $each_item['feature_content'] ) ? $each_item['feature_content'] : '';
						$feature_link = !empty( $each_item['feature_link'] ) ? $each_item['feature_link'] : '';
						

						if ( $feature_link ) {
				      $link_o = '<a href="'. $feature_link .'" class="more">';
				      $link_c = '</a>';
				    } else {
				      $link_o = '';
				      $link_c = '';
				    }
			    
					?>
		      <div class="col-lg-4 col-md-6 col-xl-12">
	            <div class="arkit-service-info-single" data-number="0<?php echo esc_attr( $id ); ?>">
	            	<?php 
		            	if( $feature_subtitle ) { echo '<span class="tag">'.esc_html( $feature_subtitle ).'</span>'; }
		            	if( $feature_title ) { echo '<h2>'.$link_o.''.esc_html( $feature_title ).''.$link_c.'</h2>'; }
		            	if( $feature_content ) { echo '<p>'.esc_html( $feature_content ).'</p>'; }
		             ?>
	            </div>
	        </div>
		      <?php }
					} ?>
		  </div>
		</div>
		<?php
			// Return outbut buffer
			echo ob_get_clean();	
		}
	/**
	 * Render Feature widget output in the editor.
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	*/
	
	//protected function _content_template(){}
	
}
Plugin::instance()->widgets_manager->register_widget_type( new Arkito_Feature() );