<?php
/*
 * Elementor Arkito Project Widget
 * Author & Copyright: helloexpert
*/

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Arkito_Project extends Widget_Base{

	/**
	 * Retrieve the widget name.
	*/
	public function get_name(){
		return 'tmx-arkito_project';
	}

	/**
	 * Retrieve the widget title.
	*/
	public function get_title(){
		return esc_html__( 'Project', 'arkito-core' );
	}

	/**
	 * Retrieve the widget icon.
	*/
	public function get_icon() {
		return 'fa fa-briefcase';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	*/
	public function get_categories() {
		return ['helloexpert-category'];
	}

	/**
	 * Retrieve the list of scripts the Arkito Project widget depended on.
	 * Used to set scripts dependencies required to run the widget.
	*/
	public function get_script_depends() {
		return ['tmx-arkito_project'];
	}
	
	/**
	 * Register Arkito Project widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	*/
	protected function _register_controls(){


		$posts = get_posts( 'post_type="project"&numberposts=-1' );
    $PostID = array();
    if ( $posts ) {
      foreach ( $posts as $post ) {
        $PostID[ $post->ID ] = $post->ID;
      }
    } else {
      $PostID[ __( 'No ID\'s found', 'arkito' ) ] = 0;
    }
		
		
		$this->start_controls_section(
			'section_project',
			[
				'label' => esc_html__( 'Project Title', 'arkito-core' ),
			]
		);
		$this->add_control(
			'sec_project_subtitle',
			[
				'label' => esc_html__( 'Sub Title Text', 'arkito-core' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'About Our Company', 'arkito-core' ),
				'placeholder' => esc_html__( 'Sub Type title text here', 'arkito-core' ),
				'label_block' => true,
			]
		);
		$this->add_control(
			'sec_project_title',
			[
				'label' => esc_html__( 'Title Text', 'arkito-core' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Title Text', 'arkito-core' ),
				'placeholder' => esc_html__( 'Type title text here', 'arkito-core' ),
				'label_block' => true,
			]
		);
		$this->end_controls_section();// end: Section
		

		$this->start_controls_section(
			'section_project_listing',
			[
				'label' => esc_html__( 'Listing Options', 'arkito-core' ),
			]
		);
		$this->add_control(
			'project_limit',
			[
				'label' => esc_html__( 'Project Limit', 'arkito-core' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 100,
				'step' => 1,
				'default' => 3,
				'description' => esc_html__( 'Enter the number of items to show.', 'arkito-core' ),
			]
		);
		$this->add_control(
			'project_order',
			[
				'label' => __( 'Order', 'arkito-core' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'ASC' => esc_html__( 'Asending', 'arkito-core' ),
					'DESC' => esc_html__( 'Desending', 'arkito-core' ),
				],
				'default' => 'DESC',
			]
		);
		$this->add_control(
			'project_orderby',
			[
				'label' => __( 'Order By', 'arkito-core' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'none' => esc_html__( 'None', 'arkito-core' ),
					'ID' => esc_html__( 'ID', 'arkito-core' ),
					'author' => esc_html__( 'Author', 'arkito-core' ),
					'title' => esc_html__( 'Title', 'arkito-core' ),
					'date' => esc_html__( 'Date', 'arkito-core' ),
				],
				'default' => 'date',
			]
		);
		$this->add_control(
			'project_show_category',
			[
				'label' => __( 'Certain Categories?', 'arkito-core' ),
				'type' => Controls_Manager::SELECT2,
				'default' => [],
				'options' => Controls_Helper_Output::get_terms_names( 'project_category'),
				'multiple' => true,
			]
		);
		$this->add_control(
			'project_show_id',
			[
				'label' => __( 'Certain ID\'s?', 'arkito-core' ),
				'type' => Controls_Manager::SELECT2,
				'default' => [],
				'options' => $PostID,
				'multiple' => true,
			]
		);
		$this->add_control(
			'project_more',
			[
				'label' => esc_html__( 'Plus', 'arkito-core' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'arkito-core' ),
				'label_off' => esc_html__( 'Hide', 'arkito-core' ),
				'return_value' => 'true',
				'default' => 'true',
			]
		);
		$this->end_controls_section();// end: Section



		// Section SubTitle
		$this->start_controls_section(
			'portfolio_section_subtitle_style',
			[
				'label' => esc_html__( 'Section SubTitle', 'arkito-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__( 'Typography', 'arkito-core' ),
				'name' => 'arkito_section_subtitle_typography',
				'selector' => '{{WRAPPER}} .portfolio .section-title span',
			]
		);
		$this->add_control(
			'portfolio_subtitle_color',
			[
				'label' => esc_html__( 'Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .portfolio .section-title > span' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'portfolio_subtitle_padding',
			[
				'label' => esc_html__( 'Title Padding', 'arkito-core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .portfolio .section-title span' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();// end: Section

		// Section Title
		$this->start_controls_section(
			'portfolio_section_title_style',
			[
				'label' => esc_html__( 'Section Title', 'arkito-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__( 'Typography', 'arkito-core' ),
				'name' => 'arkito_section_title_typography',
				'selector' => '{{WRAPPER}} .portfolio .section-title h2',
			]
		);
		$this->add_control(
			'portfolio_title_color',
			[
				'label' => esc_html__( 'Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .portfolio .section-title h2, .portfolio .section-title h2 span' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'portfolio_title_padding',
			[
				'label' => esc_html__( 'Title Padding', 'arkito-core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .portfolio .section-title h2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();// end: Section

		// Subtitle
		$this->start_controls_section(
			'section_subtitle_style',
			[
				'label' => esc_html__( 'Subtitle', 'arkito-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__( 'Typography', 'arkito-core' ),
				'name' => 'arkito_subtitle_typography',
				'selector' => '{{WRAPPER}} .single-work .hover_layer .info p',
			]
		);
		$this->add_control(
			'subtitle_color',
			[
				'label' => esc_html__( 'Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .single-work .hover_layer .info p' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'subtitle_padding',
			[
				'label' => esc_html__( 'Subtitle Padding', 'arkito-core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .single-work .hover_layer .info p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();// end: Section

		// Title
		$this->start_controls_section(
			'section_title_style',
			[
				'label' => esc_html__( 'Title', 'arkito-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__( 'Typography', 'arkito-core' ),
				'name' => 'arkito_title_typography',
				'selector' => '{{WRAPPER}} .single-work .hover_layer .info h3',
			]
		);
		$this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .single-work .hover_layer .info h3 a' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'title_padding',
			[
				'label' => esc_html__( 'Title Padding', 'arkito-core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .single-work .hover_layer .info h3' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();// end: Section
		

		// Plus
		$this->start_controls_section(
			'section_overly_style',
			[
				'label' => esc_html__( 'Plus Btn', 'arkito-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'plus_br_color',
			[
				'label' => esc_html__( 'Border Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .single-work .hover_layer .details-btn .portfolio-btn' => 'border-color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'plus_color',
			[
				'label' => esc_html__( 'Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .single-work .hover_layer .details-btn .portfolio-btn' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'plus_hover_bg_color',
			[
				'label' => esc_html__( 'Hover BG Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .single-work .hover_layer .details-btn .portfolio-btn:hover' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'plus_hover_color',
			[
				'label' => esc_html__( 'Hover Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .single-work .hover_layer .details-btn .portfolio-btn:hover' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'plus_hover_br_color',
			[
				'label' => esc_html__( 'Hover Border Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .single-work .hover_layer .details-btn .portfolio-btn:hover' => 'border-color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section();// end: Section

		
		// Next Prev
		$this->start_controls_section(
			'section_nextprev_style',
			[
				'label' => esc_html__( 'NextPrev', 'arkito-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'nextprev_btn_color',
			[
				'label' => esc_html__( 'Next Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .owl-theme .owl-controls .owl-nav [class*=owl-]' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'nextprev_btn_bg_color',
			[
				'label' => esc_html__( 'Next Prev BG Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .owl-theme .owl-controls .owl-nav [class*=owl-]' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'nextprev_btn_br_color',
			[
				'label' => esc_html__( 'Next Border Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .owl-theme .owl-controls .owl-nav [class*=owl-]' => 'border-color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'nextprev_btn_over_color',
			[
				'label' => esc_html__( 'Next Hover Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .owl-theme .owl-controls .owl-nav [class*=owl-]:hover' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'nextprev_btn_over_bg_color',
			[
				'label' => esc_html__( 'Next Hover BG Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .owl-theme .owl-controls .owl-nav [class*=owl-]:hover' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'nextprev_btn_over_br_color',
			[
				'label' => esc_html__( 'Next Hover Border Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .owl-theme .owl-controls .owl-nav [class*=owl-]:hover' => 'border-color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section();// end: Section



	}

	/**
	 * Render Project widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	*/
	protected function render() {
		$settings = $this->get_settings_for_display();

		$sec_project_subtitle = !empty( $settings['sec_project_subtitle'] ) ? $settings['sec_project_subtitle'] : '';
		$sec_project_title = !empty( $settings['sec_project_title'] ) ? $settings['sec_project_title'] : '';

		$button_text = !empty( $settings['btn_txt'] ) ? $settings['btn_txt'] : '';
		$button_link = !empty( $settings['button_link']['url'] ) ? $settings['button_link']['url'] : '';
		$button_link_external = !empty( $settings['button_link']['is_external'] ) ? 'target="_blank"' : '';
		$button_link_nofollow = !empty( $settings['button_link']['nofollow'] ) ? 'rel="nofollow"' : '';
		$button_link_attr = !empty( $button_link ) ?  $button_link_external.' '.$button_link_nofollow : '';

		$button_one = $button_link ? '<a href="'.esc_url($button_link).'" '.$button_link_attr.' class="theme-btn" >'. $button_text .'</a>' : '';

		$project_limit = !empty( $settings['project_limit'] ) ? $settings['project_limit'] : '';
		$project_order = !empty( $settings['project_order'] ) ? $settings['project_order'] : '';
		$project_orderby = !empty( $settings['project_orderby'] ) ? $settings['project_orderby'] : '';
		$project_show_category = !empty( $settings['project_show_category'] ) ? $settings['project_show_category'] : [];
		$project_show_id = !empty( $settings['project_show_id'] ) ? $settings['project_show_id'] : [];

		$project_more = !empty( $settings['project_more'] ) ? $settings['project_more'] : [];


		// Turn output buffer on
		ob_start();

		// Pagination
		global $paged;
		if( get_query_var( 'paged' ) )
		  $my_page = get_query_var( 'paged' );
		else {
		  if( get_query_var( 'page' ) )
			$my_page = get_query_var( 'page' );
		  else
			$my_page = 1;
		  set_query_var( 'paged', $my_page );
		  $paged = $my_page;
		}

    if ($project_show_id) {
			$project_show_id = json_encode( $project_show_id );
			$project_show_id = str_replace(array( '[', ']' ), '', $project_show_id);
			$project_show_id = str_replace(array( '"', '"' ), '', $project_show_id);
      $project_show_id = explode(',',$project_show_id);
    } else {
      $project_show_id = '';
    }

		$args = array(
		  // other query params here,
		  'paged' => $my_page,
		  'post_type' => 'project',
		  'posts_per_page' => (int)$project_limit,
		  'project_category' => implode(',', $project_show_category),
		  'orderby' => $project_orderby,
		  'order' => $project_order,
      'post__in' => $project_show_id,
		);

		$arkito_project = new \WP_Query( $args );
		?>

		<div class="portfolio">
			<div class="container">
		    <div class="row display-flex-title">
		        <div class="col-lg-7 col-xs-12">
		            <div class="section-title text-center">
		            		<?php 
			            		if( $sec_project_subtitle) { echo '<span>'.esc_html( $sec_project_subtitle ).'</span>'; }
			            		if( $sec_project_title ) { echo '<h2>'.wp_kses_post( $sec_project_title ).'</h2>'; } 
			            	?>
		            </div>
		        </div>
		    </div>
	    </div>
	    <div class="owl-carousel owl-theme work-portfolio-slider">
	    	<?php 
						if ( $arkito_project->have_posts()) : while ( $arkito_project->have_posts()) : $arkito_project->the_post();
						
						$project_options = get_post_meta( get_the_ID(), 'project_options', true );
	          $project_subtitle = isset( $project_options['project_subtitle']) ? $project_options['project_subtitle'] : '';
	          $project_title = isset( $project_options['project_title']) ? $project_options['project_title'] : '';
	          $project_desc = isset( $project_options['project_desc']) ? $project_options['project_desc'] : '';
	          $project_image = isset( $project_options['project_image']) ? $project_options['project_image'] : '';

	          global $post;
	          $image_url = wp_get_attachment_url( $project_image );
	          $image_alt = get_post_meta( $project_image , '_wp_attachment_image_alt', true);

					?>
	        <div class="item">
	            <div class="single-work">
	            	<?php if( $image_url ) { echo '<img class="img-responsive"  src="'.esc_url( $image_url ).'" alt="'.esc_attr( $image_alt ).'">'; } ?>
	                <div class="hover_layer">
	                    <div class="info">
	                    	<?php 
                           if( $project_title ) { echo '<h3><a href="'.esc_url( get_permalink() ).'">'.esc_html( $project_title ).'</a></h3>'; } 
                           if( $project_subtitle) { echo '<p>'.esc_html( $project_subtitle ).'</p>'; }
                         ?>
	                    </div>
	                    <?php if ( $project_more ) { ?>
	                    <div class="details-btn">
	                        <a class="portfolio-btn" href="<?php echo esc_url( get_permalink() ); ?>">+</a>
	                    </div>
	                    <?php } ?>
	                </div>
	            </div>
	        </div>
	        <!--/item-->
	        <?php 
					  endwhile;
					  endif;
					  wp_reset_postdata();
					?>
	    </div>
		</div>
		<?php
			// Return outbut buffer
			echo ob_get_clean();	
		}
	/**
	 * Render Project widget output in the editor.
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	*/
	
	//protected function _content_template(){}
	
}
Plugin::instance()->widgets_manager->register_widget_type( new Arkito_Project() );