<?php
/*
 * Elementor Arkito Service Widget
 * Author & Copyright: helloexpert
*/

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Arkito_Service extends Widget_Base{

	/**
	 * Retrieve the widget name.
	*/
	public function get_name(){
		return 'tmx-arkito_service';
	}

	/**
	 * Retrieve the widget title.
	*/
	public function get_title(){
		return esc_html__( 'Service', 'arkito-core' );
	}

	/**
	 * Retrieve the widget icon.
	*/
	public function get_icon() {
		return 'fa fa-telegram';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	*/
	public function get_categories() {
		return ['helloexpert-category'];
	}

	/**
	 * Retrieve the list of scripts the Arkito Service widget depended on.
	 * Used to set scripts dependencies required to run the widget.
	*/
	public function get_script_depends() {
		return ['tmx-arkito_service'];
	}
	
	/**
	 * Register Arkito Service widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	*/
	protected function _register_controls(){


		$posts = get_posts( 'post_type="service"&numberposts=-1' );
    $PostID = array();
    if ( $posts ) {
      foreach ( $posts as $post ) {
        $PostID[ $post->ID ] = $post->ID;
      }
    } else {
      $PostID[ __( 'No ID\'s found', 'arkito' ) ] = 0;
    }
		
	
		$this->start_controls_section(
			'section_service_listing',
			[
				'label' => esc_html__( 'Listing Options', 'arkito-core' ),
			]
		);
		$this->add_control(
			'service_limit',
			[
				'label' => esc_html__( 'Service Limit', 'arkito-core' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 1,
				'max' => 100,
				'step' => 1,
				'default' => 3,
				'description' => esc_html__( 'Enter the number of items to show.', 'arkito-core' ),
			]
		);
		$this->add_control(
			'service_order',
			[
				'label' => __( 'Order', 'arkito-core' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'ASC' => esc_html__( 'Asending', 'arkito-core' ),
					'DESC' => esc_html__( 'Desending', 'arkito-core' ),
				],
				'default' => 'DESC',
			]
		);
		$this->add_control(
			'service_orderby',
			[
				'label' => __( 'Order By', 'arkito-core' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'none' => esc_html__( 'None', 'arkito-core' ),
					'ID' => esc_html__( 'ID', 'arkito-core' ),
					'author' => esc_html__( 'Author', 'arkito-core' ),
					'title' => esc_html__( 'Title', 'arkito-core' ),
					'date' => esc_html__( 'Date', 'arkito-core' ),
				],
				'default' => 'date',
			]
		);
		$this->add_control(
			'service_show_category',
			[
				'label' => __( 'Certain Categories?', 'arkito-core' ),
				'type' => Controls_Manager::SELECT2,
				'default' => [],
				'options' => Controls_Helper_Output::get_terms_names( 'service_category'),
				'multiple' => true,
			]
		);
		$this->add_control(
			'service_show_id',
			[
				'label' => __( 'Certain ID\'s?', 'arkito-core' ),
				'type' => Controls_Manager::SELECT2,
				'default' => [],
				'options' => $PostID,
				'multiple' => true,
			]
		);
		$this->add_control(
			'short_content',
			[
				'label' => esc_html__( 'Excerpt Length', 'arkito-core' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 1,
				'step' => 1,
				'default' => 16,
				'description' => esc_html__( 'How many words you want in short content paragraph.', 'arkito-core' ),
			]
		);
		$this->add_control(
			'service_more',
			[
				'label' => esc_html__( 'Read More', 'degit-core' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'degit-core' ),
				'label_off' => esc_html__( 'Hide', 'degit-core' ),
				'return_value' => 'true',
				'default' => 'true',
			]
		);
		$this->add_control(
			'read_more_txt',
			[
				'label' => esc_html__( 'Read More Text', 'arkito-core' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => 'Read More',
				'placeholder' => esc_html__( 'Type your Read More text here', 'arkito-core' ),
			]
		);
		$this->end_controls_section();// end: Section

	
		// Title
		$this->start_controls_section(
			'service_section_title_style',
			[
				'label' => esc_html__( 'Section Title', 'arkito-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__( 'Typography', 'arkito-core' ),
				'name' => 'service_arkito_title_typography',
				'selector' => '{{WRAPPER}} .arkit-single-service h3 a',
			]
		);
		$this->add_control(
			'service_section_title_color',
			[
				'label' => esc_html__( 'Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .arkit-single-service h3 a' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'service_section_title_padding',
			[
				'label' => esc_html__( 'Title Padding', 'arkito-core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .arkit-single-service h3 a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();// end: Section

		// Content
		$this->start_controls_section(
			'service_section_content_style',
			[
				'label' => esc_html__( 'Title Content', 'arkito-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__( 'Typography', 'arkito-core' ),
				'name' => 'service_section_content_typography',
				'selector' => '{{WRAPPER}} .arkit-service .arkit-single-service p',
			]
		);
		$this->add_control(
			'service_content_color',
			[
				'label' => esc_html__( 'Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .arkit-service .arkit-single-service p' => 'color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section();// end: Section

		// Service button
		$this->start_controls_section(
			'section_service_button_style',
			[
				'label' => esc_html__( 'Service button ', 'arkito-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'service_button_color',
			[
				'label' => esc_html__( 'Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .arkit-service .read-more-btn' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'service_button_br_color',
			[
				'label' => esc_html__( 'Border Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .arkit-service .read-more-btn' => 'border-color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'service_button_bg_color',
			[
				'label' => esc_html__( 'Background Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .arkit-service .read-more-btn' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section();// end: Section

		
	}

	/**
	 * Render Service widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	*/
	protected function render() {
		$settings = $this->get_settings_for_display();

		$service_limit = !empty( $settings['service_limit'] ) ? $settings['service_limit'] : '';
		$service_order = !empty( $settings['service_order'] ) ? $settings['service_order'] : '';
		$service_orderby = !empty( $settings['service_orderby'] ) ? $settings['service_orderby'] : '';
		$service_show_category = !empty( $settings['service_show_category'] ) ? $settings['service_show_category'] : [];
		$service_show_id = !empty( $settings['service_show_id'] ) ? $settings['service_show_id'] : [];
		$short_content = !empty( $settings['short_content'] ) ? $settings['short_content'] : '';
		$service_more = !empty( $settings['service_more'] ) ? $settings['service_more'] : '';
		$read_more_txt = !empty( $settings['read_more_txt'] ) ? $settings['read_more_txt'] : '';
	
		$excerpt_length = $short_content ? $short_content : '16';


		// Turn output buffer on
		ob_start();

		// Pagination
		global $paged;
		if( get_query_var( 'paged' ) )
		  $my_page = get_query_var( 'paged' );
		else {
		  if( get_query_var( 'page' ) )
			$my_page = get_query_var( 'page' );
		  else
			$my_page = 1;
		  set_query_var( 'paged', $my_page );
		  $paged = $my_page;
		}

    if ($service_show_id) {
			$service_show_id = json_encode( $service_show_id );
			$service_show_id = str_replace(array( '[', ']' ), '', $service_show_id);
			$service_show_id = str_replace(array( '"', '"' ), '', $service_show_id);
      $service_show_id = explode(',',$service_show_id);
    } else {
      $service_show_id = '';
    }

		$args = array(
		  // other query params here,
		  'paged' => $my_page,
		  'post_type' => 'service',
		  'posts_per_page' => (int)$service_limit,
		  'service_category' => implode(',', $service_show_category),
		  'orderby' => $service_orderby,
		  'order' => $service_order,
      'post__in' => $service_show_id,
		);

		$arkito_service = new \WP_Query( $args ); ?>

		<div class="arkit-service">
    	<div class="owl-carousel owl-theme service-slider">
    		<?php 
					if ( $arkito_service->have_posts()) : while ( $arkito_service->have_posts()) : $arkito_service->the_post();
					
					$service_options = get_post_meta( get_the_ID(), 'service_options', true );
	        $service_title = isset($service_options['service_title']) ? $service_options['service_title'] : '';
	        $service_image = isset($service_options['service_image']) ? $service_options['service_image'] : '';
	        $service_icon = isset($service_options['service_icon']) ? $service_options['service_icon'] : '';
  				global $post;
  				// service
          $image_url = wp_get_attachment_url( $service_image );
          $image_alt = get_post_meta( $service_image , '_wp_attachment_image_alt', true);

          $icon_url = wp_get_attachment_url( $service_icon );
          $icon_alt = get_post_meta( $service_icon , '_wp_attachment_image_alt', true);

				?>
        <div class="item">
            <div class="arkit-single-service">
            	 <?php if( $image_url ) { echo '<img class="img-responsive" src="'.esc_url( $image_url ).'" alt="'.esc_attr( $image_alt ).'">'; }	?>
                <div class="content-inner">
                	 <?php  
											if( $service_title ) { 
												echo '<h3><a href="'.esc_url( get_permalink() ).'">
												 <img alt="'.esc_attr( $icon_alt ).'" class="img-responsive home-icon" src="'.esc_url( $icon_url ).'">
												<span>'.esc_html( $service_title ).'</span></a></h3>'; 
											}
                   	?>
                    <p><?php echo wp_trim_words( get_the_content(), $excerpt_length, ' ' ); ?></p>
                    <?php if( $service_more ) { echo ' <a class="read-more-btn" href="'.esc_url( get_permalink() ).'">'.esc_html( $read_more_txt ).'<span>+</span></a>'; } ?>
                </div>
            </div>
        </div>
	      <?php 
				  endwhile;
				  endif;
				  wp_reset_postdata();
				 ?>
			  </div>
			</div>
			<?php
			// Return outbut buffer
			echo ob_get_clean();	
		}
	/**
	 * Render Service widget output in the editor.
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	*/
	
	//protected function _content_template(){}
	
}
Plugin::instance()->widgets_manager->register_widget_type( new Arkito_Service() );