<?php
/*
 * Elementor Arkito Team Widget
 * Author & Copyright: helloexpert
*/

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Arkito_Team extends Widget_Base{

	/**
	 * Retrieve the widget name.
	*/
	public function get_name(){
		return 'tmx-arkito_team';
	}

	/**
	 * Retrieve the widget title.
	*/
	public function get_title(){
		return esc_html__( 'Team', 'arkito-core' );
	}

	/**
	 * Retrieve the widget icon.
	*/
	public function get_icon() {
		return 'fa fa-users';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	*/
	public function get_categories() {
		return ['helloexpert-category'];
	}

	/**
	 * Retrieve the list of scripts the Arkito Team widget depended on.
	 * Used to set scripts dependencies required to run the widget.
	*/
	public function get_script_depends() {
		return ['tmx-arkito_team'];
	}
	
	/**
	 * Register Arkito Team widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	*/
	protected function _register_controls(){
		
		$this->start_controls_section(
			'section_team',
			[
				'label' => esc_html__( 'Team Options', 'arkito-core' ),
			]
		);
		$repeater = new Repeater();
		$repeater->add_control(
			'team_title',
			[
				'label' => esc_html__( 'Title Text', 'arkito-core' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Title Text', 'arkito-core' ),
				'placeholder' => esc_html__( 'Type title text here', 'arkito-core' ),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'team_subtitle',
			[
				'label' => esc_html__( 'Sub Title Text', 'arkito-core' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Sub Title Text', 'arkito-core' ),
				'placeholder' => esc_html__( 'Type sub title text here', 'arkito-core' ),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'bg_image',
			[
				'label' => esc_html__( 'Team Image', 'arkito-core' ),
				'type' => Controls_Manager::MEDIA,
				'frontend_available' => true,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
				'description' => esc_html__( 'Set your image.', 'arkito-core'),
			]
		);
		$this->add_control(
			'teamItems_groups',
			[
				'label' => esc_html__( 'Team Items', 'arkito-core' ),
				'type' => Controls_Manager::REPEATER,
				'default' => [
					[
						'team_title' => esc_html__( 'Team', 'arkito-core' ),
					],
					
				],
				'fields' =>  $repeater->get_controls(),
				'title_field' => '{{{ team_title }}}',
			]
		);

		$this->end_controls_section();// end: Section
		

		// Title
		$this->start_controls_section(
			'section_team_style',
			[
				'label' => esc_html__( 'Item', 'arkito-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'team_bg_color',
			[
				'label' => esc_html__( 'BG Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .arkit-member .team-info' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'team_br_color',
			[
				'label' => esc_html__( 'Border Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .arkit-member .team-info:before' => 'border-color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'team_hover_br_color',
			[
				'label' => esc_html__( 'Hover Border Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .arkit-member:hover .team-info:before' => 'border-color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'team_hover_bg_color',
			[
				'label' => esc_html__( 'Hover BG Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .arkit-member:hover .team-info' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'team_hover_text_color',
			[
				'label' => esc_html__( 'Hover Text Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .arkit-member:hover .team-info p, .arkit-member:hover .team-info h4' => 'color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section();// end: Section

		// Title
		$this->start_controls_section(
			'section_title_style',
			[
				'label' => esc_html__( 'Title', 'arkito-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__( 'Typography', 'arkito-core' ),
				'name' => 'arkito_title_typography',
				'selector' => '{{WRAPPER}} .arkit-member .team-info h4',
			]
		);
		$this->add_control(
			'title_color',
			[
				'label' => esc_html__( 'Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .arkit-member .team-info h4' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'title_padding',
			[
				'label' => __( 'Title Padding', 'arkito-core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .arkit-member .team-info h4' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();// end: Section

		// Sub Title
		$this->start_controls_section(
			'section_subtitle_style',
			[
				'label' => esc_html__( 'Sub Title', 'arkito-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__( 'Typography', 'arkito-core' ),
				'name' => 'arkito_subtitle_typography',
				'selector' => '{{WRAPPER}} .arkit-member .team-info p',
			]
		);
		$this->add_control(
			'subtitle_color',
			[
				'label' => esc_html__( 'Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .arkit-member .team-info p' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'subtitle_padding',
			[
				'label' => __( 'Title Padding', 'arkito-core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .arkit-member .team-info p' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();// end: Section
		

		
	}

	/**
	 * Render Team widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	*/
	protected function render() {
		$settings = $this->get_settings_for_display();
		$teamItems_groups = !empty( $settings['teamItems_groups'] ) ? $settings['teamItems_groups'] : [];

		// Turn output buffer on
		ob_start();
		?>
		<div class="arkit-team">
	    <!--/Row-->
	    <div class="row">
	        <?php 	// Group Param Output
					if( is_array( $teamItems_groups ) && !empty( $teamItems_groups ) ){
					foreach ( $teamItems_groups as $each_items) { 

					$team_title = !empty( $each_items['team_title'] ) ? $each_items['team_title'] : '';
					$team_subtitle = !empty( $each_items['team_subtitle'] ) ? $each_items['team_subtitle'] : '';
					$bg_image = !empty( $each_items['bg_image']['id'] ) ? $each_items['bg_image']['id'] : '';
					$image_url = wp_get_attachment_url( $each_items['bg_image']['id'] );
					$image_alt = get_post_meta( $each_items['bg_image']['id'], '_wp_attachment_image_alt', true);
					?>
	        <!--/col-->
	        <div class="col-lg-4 col-sm-6 col-xl-12">
	            <div class="arkit-member">
	            	<?php if( $image_url ) { echo '<img class="img-responlsive" src="'.esc_url( $image_url ).'" alt="'.esc_attr( $image_alt ).'">'; } ?>
	                <div class="team-info">
	                   <?php 
			              	if( $team_title ) { echo '<h4>'.esc_html( $team_title ).'</h4>'; } 
			              	if( $team_subtitle ) { echo '<p>'.esc_html( $team_subtitle ).'</p>'; }
			              ?>
	                </div>
	            </div>
	        </div>
	        <!--/col-->
	        <?php }
					} ?>
	    </div>
		</div>
		<?php
			// Return outbut buffer
			echo ob_get_clean();	
		}
	/**
	 * Render Team widget output in the editor.
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	*/
	
	//protected function _content_template(){}
	
}
Plugin::instance()->widgets_manager->register_widget_type( new Arkito_Team() );