<?php
/*
 * Elementor Arkito Testimonial Widget
 * Author & Copyright: helloexpert
*/

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Arkito_Testimonial extends Widget_Base{

	/**
	 * Retrieve the widget name.
	*/
	public function get_name(){
		return 'tmx-arkito_testimonial';
	}

	/**
	 * Retrieve the widget title.
	*/
	public function get_title(){
		return esc_html__( 'Testimonial', 'arkito-core' );
	}

	/**
	 * Retrieve the widget icon.
	*/
	public function get_icon() {
		return 'fa fa-quote-right';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	*/
	public function get_categories() {
		return ['helloexpert-category'];
	}

	/**
	 * Retrieve the list of scripts the Arkito Testimonial widget depended on.
	 * Used to set scripts dependencies required to run the widget.
	*/
	public function get_script_depends() {
		return ['tmx-arkito_testimonial'];
	}
	
	/**
	 * Register Arkito Testimonial widget controls.
	 * Adds different input fields to allow the user to change and customize the widget settings.
	*/
	protected function _register_controls(){
		
		$this->start_controls_section(
			'section_testimonial',
			[
				'label' => esc_html__( 'Testimonial Options', 'arkito-core' ),
			]
		);
		$this->add_control(
			'section_title',
			[
				'label' => esc_html__( 'Title Text', 'arkito-core' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Title Text', 'arkito-core' ),
				'placeholder' => esc_html__( 'Type title text here', 'arkito-core' ),
				'label_block' => true,
			]
		);
		$this->add_control(
			'section_content',
			[
				'label' => esc_html__( 'Content Text', 'arkito-core' ),
				'type' => Controls_Manager::WYSIWYG,
				'default' => esc_html__( 'Content Text', 'arkito-core' ),
				'placeholder' => esc_html__( 'Type Content text here', 'arkito-core' ),
				'label_block' => true,
			]
		);
		 $this->add_control(
			'testi_shape',
			[
				'label' => esc_html__( 'Testimonial Shape', 'arkito-core' ),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
				
			]
		);
		$repeater = new Repeater();
		$repeater->add_control(
			'testimonial_title',
			[
				'label' => esc_html__( 'Testimonial Title Text', 'arkito-core' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Title Text', 'arkito-core' ),
				'placeholder' => esc_html__( 'Type title text here', 'arkito-core' ),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'testimonial_subtitle',
			[
				'label' => esc_html__( 'Testimonial Sub Title', 'arkito-core' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Testimonial Sub Title', 'arkito-core' ),
				'placeholder' => esc_html__( 'Type testimonial Sub title here', 'arkito-core' ),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'testimonial_content',
			[
				'label' => esc_html__( 'Testimonial Content', 'arkito-core' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Testimonial Content', 'arkito-core' ),
				'placeholder' => esc_html__( 'Type testimonial Content here', 'arkito-core' ),
				'label_block' => true,
			]
		);
	  $repeater->add_control(
			'bg_image',
			[
				'label' => esc_html__( 'Testimonial Image', 'arkito-core' ),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
				
			]
		);
	  $repeater->add_control(
			'quote_image',
			[
				'label' => esc_html__( 'Quote Image', 'arkito-core' ),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
				
			]
		);
		$this->add_control(
			'testimonialItems_groups',
			[
				'label' => esc_html__( 'Testimonial Items', 'arkito-core' ),
				'type' => Controls_Manager::REPEATER,
				'default' => [
					[
						'testimonial_title' => esc_html__( 'Testimonial', 'arkito-core' ),
					],
					
				],
				'fields' =>  $repeater->get_controls(),
				'title_field' => '{{{ testimonial_title }}}',
			]
		);
		$this->end_controls_section();// end: Section
		

		// Testimonial Content Style 
		$this->start_controls_section(
			'testimonials_section_content_style',
			[
				'label' => esc_html__( 'Testimonial', 'arkito-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'testimonials_left_br_color',
			[
				'label' => esc_html__( 'left Border Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .testimonial-inner:before' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'testimonials_section_subtitle_color',
			[
				'label' => esc_html__( 'Subtitle Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .testimonial .section-title > span' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'testimonials_section_title_color',
			[
				'label' => esc_html__( 'Title Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .testimonial .section-title h2, .testimonial .section-title h2 span' => 'color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section();// end: Section

		// Testimonial Name Style 
		$this->start_controls_section(
			'testimonials_section_name_style',
			[
				'label' => esc_html__( 'Testimonial Name', 'arkito-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__( 'Typography', 'arkito-core' ),
				'name' => 'testimonials_arkito_name_typography',
				'selector' => '{{WRAPPER}} .single-testimonial .info h4',
			]
		);
		$this->add_control(
			'testimonials_name_color',
			[
				'label' => esc_html__( 'Name Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .single-testimonial .info h4' => 'color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section();// end: Section
		
		// Testimonial Title Style 
		$this->start_controls_section(
			'testimonials_section_title_style',
			[
				'label' => esc_html__( 'Testimonial Title', 'arkito-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__( 'Typography', 'arkito-core' ),
				'name' => 'testimonials_arkito_title_typography',
				'selector' => '{{WRAPPER}} .single-testimonial .info p',
			]
		);
		$this->add_control(
			'testimonials_title_color',
			[
				'label' => esc_html__( 'Name Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .single-testimonial .info p' => 'color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section();// end: Section

		// Content
		$this->start_controls_section(
			'section_content_style',
			[
				'label' => esc_html__( 'Content', 'arkito-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__( 'Typography', 'arkito-core' ),
				'name' => 'section_content_typography',
				'selector' => '{{WRAPPER}} .single-testimonial .feedback p',
			]
		);
		$this->add_control(
			'content_color',
			[
				'label' => esc_html__( 'Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .single-testimonial .feedback p' => 'color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section();// end: Section
		
		// Dot Color
		$this->start_controls_section(
			'section_quote_style',
			[
				'label' => esc_html__( 'Dot', 'arkito-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_control(
			'dot_color',
			[
				'label' => esc_html__( 'Background Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .testimonial-slider.owl-theme .owl-dots .owl-dot span' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'dot_active_color',
			[
				'label' => esc_html__( 'Active Color', 'arkito-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .testimonial-slider.owl-theme .owl-dots .owl-dot.active span, .owl-theme .owl-dots .owl-dot:hover span' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section();// end: Section
		
	}

	/**
	 * Render Testimonial widget output on the frontend.
	 * Written in PHP and used to generate the final HTML.
	*/
	protected function render() {
		$settings = $this->get_settings_for_display();
		$testimonialItems_groups = !empty( $settings['testimonialItems_groups'] ) ? $settings['testimonialItems_groups'] : [];
		$section_title = !empty( $settings['section_title'] ) ? $settings['section_title'] : '';
		$section_content = !empty( $settings['section_content'] ) ? $settings['section_content'] : '';

		$testi_image = !empty( $settings['testi_shape']['id'] ) ? $settings['testi_shape']['id'] : '';	
		// Image
		$shape_url = wp_get_attachment_url( $testi_image );

		if ( $shape_url ) {
			$bg_url = ' style="';
			$bg_url .= ( $shape_url ) ? 'background-image: url( '. esc_url( $shape_url ) .' );' : '';
			$bg_url .= '"';
		} else {
			$bg_url = '';
		}

		// Turn output buffer on
		ob_start(); ?>
		<div class="testimonial">
		    <div class="testimonial-inner">
		        <div class="row">
		            <div class="col-lg-9">
		                <div class="section-title">
		                    <?php 
		                    	if( $section_title ) { echo '<span>'.esc_html( $section_title ).'</span>'; } 
		                     	if( $section_content ) { echo wp_kses_post( $section_content ); }
		                     ?>
		                </div>
		            </div>
		        </div>
		        <div class="owl-carousel owl-theme testimonial-slider" <?php echo $bg_url; ?>>
		        	<?php 	// Group Param Output
								if( is_array( $testimonialItems_groups ) && !empty( $testimonialItems_groups ) ){
								foreach ( $testimonialItems_groups as $each_items ) { 

								$testimonial_title = !empty( $each_items['testimonial_title'] ) ? $each_items['testimonial_title'] : '';
								$testimonial_subtitle = !empty( $each_items['testimonial_subtitle'] ) ? $each_items['testimonial_subtitle'] : '';
								$testimonial_content = !empty( $each_items['testimonial_content'] ) ? $each_items['testimonial_content'] : '';

								$image_url = wp_get_attachment_url( $each_items['bg_image']['id'] );
								$image_alt = get_post_meta( $each_items['bg_image']['id'], '_wp_attachment_image_alt', true);

								$quote_url = wp_get_attachment_url( $each_items['quote_image']['id'] );
								$quote_alt = get_post_meta( $each_items['quote_image']['id'], '_wp_attachment_image_alt', true);
								?>
		            <div class="item">
		                <div class="single-testimonial">
		                    <div class="info">
		                        <?php 
					                    if( $image_url ) { echo '<img class="img-responsive" src="'.esc_url( $image_url ).'" alt="'.esc_attr( $image_alt ).'">'; }
															if( $testimonial_title ) { echo '<h4>'.esc_html( $testimonial_title ).'</h4>'; } 
                        			if( $testimonial_subtitle ) { echo '<p>'.esc_html( $testimonial_subtitle ).'</p>'; }
	                           ?>
		                    </div>
		                    <div class="feedback">
	                        <span class="quote">
	                        	<?php 
				                      if( $quote_url ) { echo '<img class="img-responsive" src="'.esc_url( $quote_url ).'" alt="'.esc_attr( $quote_alt ).'">'; }
				                     ?>
	                        </span>
	                        <?php if( $testimonial_content ) { echo '<p>'.esc_html( $testimonial_content ).'</p>'; } ?>
		                    </div>
		                </div>
		            </div><!-- /item -->
		          <?php }
							} ?>
		        </div>
		    </div>
		</div>
		<?php 
			// Return outbut buffer
			echo ob_get_clean();	
		}
	/**
	 * Render Testimonial widget output in the editor.
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	*/
	
	//protected function _content_template(){}
	
}
Plugin::instance()->widgets_manager->register_widget_type( new Arkito_Testimonial() );