<?php
/*
 * The main template file.
 * Author & Copyright: helloexpert
 * URL: http://themeforest.net/user/helloexpert
 */
get_header();
	// Metabox
	$arkito_id    = ( isset( $post ) ) ? $post->ID : 0;
	$arkito_id    = ( is_home() ) ? get_option( 'page_for_posts' ) : $arkito_id;
	$arkito_id    = ( is_woocommerce_shop() ) ? wc_get_page_id( 'shop' ) : $arkito_id;
	$arkito_meta  = get_post_meta( $arkito_id, 'page_type_metabox', true );
	if ( $arkito_meta ) {
		$arkito_content_padding = isset( $arkito_meta['content_spacings'] ) ? $arkito_meta['content_spacings'] : '';
	} else { $arkito_content_padding = ''; }
	// Padding - Metabox
	if ($arkito_content_padding && $arkito_content_padding !== 'padding-default') {
		$arkito_content_top_spacings = $arkito_meta['content_top_spacings'];
		$arkito_content_bottom_spacings = $arkito_meta['content_bottom_spacings'];
		if ($arkito_content_padding === 'padding-custom') {
			$arkito_content_top_spacings = $arkito_content_top_spacings ? 'padding-top:'. arkito_check_px($arkito_content_top_spacings) .';' : '';
			$arkito_content_bottom_spacings = $arkito_content_bottom_spacings ? 'padding-bottom:'. arkito_check_px($arkito_content_bottom_spacings) .';' : '';
			$arkito_custom_padding = $arkito_content_top_spacings . $arkito_content_bottom_spacings;
		} else {
			$arkito_custom_padding = '';
		}
	} else {
		$arkito_custom_padding = '';
	}
	// Theme Options
	$arkito_sidebar_position = cs_get_option( 'blog_sidebar_position' );
	$arkito_sidebar_position = $arkito_sidebar_position ?$arkito_sidebar_position : 'sidebar-right';
	$arkito_blog_widget = cs_get_option( 'blog_widget' );
	$arkito_blog_widget = $arkito_blog_widget ? $arkito_blog_widget : 'sidebar-1';

	if (isset($_GET['sidebar'])) {
	  $arkito_sidebar_position = $_GET['sidebar'];
	}

	$arkito_sidebar_position = $arkito_sidebar_position ? $arkito_sidebar_position : 'sidebar-right';

	// Sidebar Position
	if ( $arkito_sidebar_position === 'sidebar-hide' ) {
		$layout_class = 'col col col-md-10 col-md-offset-1';
		$arkito_sidebar_class = 'hide-sidebar';
	} elseif ( $arkito_sidebar_position === 'sidebar-left' && is_active_sidebar( $arkito_blog_widget ) ) {
		$layout_class = 'col col-md-8 col-md-push-4';
		$arkito_sidebar_class = 'left-sidebar';
	} elseif( is_active_sidebar( $arkito_blog_widget ) ) {
		$layout_class = 'col col-md-8';
		$arkito_sidebar_class = 'right-sidebar';
	} else {
		$layout_class = 'col col-md-12';
		$arkito_sidebar_class = 'hide-sidebar';
	}

	?>
<div class="blog-pg-section section-padding">
	<div class="container <?php echo esc_attr( $arkito_content_padding .' '. $arkito_sidebar_class ); ?>" style="<?php echo esc_attr( $arkito_custom_padding ); ?>">
		<div class="row">
			<div class="<?php echo esc_attr( $layout_class ); ?>">
				<div class="blog-content">
				<?php
				if ( have_posts() ) :
					/* Start the Loop */
					while ( have_posts() ) : the_post();
						get_template_part( 'theme-layouts/post/content' );
					endwhile;
				else :
					get_template_part( 'theme-layouts/post/content', 'none' );
				endif;
				arkito_posts_navigation();
		    wp_reset_postdata(); ?>
		    </div>
			</div><!-- Content Area -->
			<?php
			if ( $arkito_sidebar_position !== 'sidebar-hide' && is_active_sidebar( $arkito_blog_widget ) ) {
				get_sidebar(); // Sidebar
			} ?>
		</div>
	</div>
</div>
<?php
get_footer();