<?php
/*
 * The template for displaying the footer.
 * Author & Copyright:helloexpert
 * URL: http://themeforest.net/user/helloexpert
 */

$arkito_id    = ( isset( $post ) ) ? $post->ID : 0;
$arkito_id    = ( is_home() ) ? get_option( 'page_for_posts' ) : $arkito_id;
$arkito_id    = ( is_woocommerce_shop() ) ? wc_get_page_id( 'shop' ) : $arkito_id;
$arkito_meta  = get_post_meta( $arkito_id, 'page_type_metabox', true );
$arkito_ft_bg = cs_get_option('arkito_ft_bg');
$arkito_attachment = wp_get_attachment_image_src( $arkito_ft_bg , 'full' );
$arkito_attachment = $arkito_attachment ? $arkito_attachment[0] : '';

if ( $arkito_attachment ) {
	$bg_url = ' style="';
	$bg_url .= ( $arkito_attachment ) ? 'background-image: url( '. esc_url( $arkito_attachment ) .' );' : '';
	$bg_url .= '"';
} else {
	$bg_url = '';
}

if ( $arkito_meta ) {
	$arkito_hide_footer  = $arkito_meta['hide_footer'];
} else { $arkito_hide_footer = ''; }
if ( !$arkito_hide_footer ) { // Hide Footer Metabox
	$hide_copyright = cs_get_option('hide_copyright');
	
?>
	<!-- Footer -->
	<footer class="site-footer clearfix"  <?php echo wp_kses( $bg_url, array('img' => array('src' => array(), 'alt' => array()),) ); ?>>
		<?php
			$footer_widget_block = cs_get_option( 'footer_widget_block' );
			if ( $footer_widget_block ) {
	      get_template_part( 'theme-layouts/footer/footer', 'widgets' );
	    }
			if ( !$hide_copyright ) {
      	get_template_part( 'theme-layouts/footer/footer', 'copyright' );
	    }
    ?>
	</footer>
	<!-- Footer -->
<?php } // Hide Footer Metabox ?>
</div><!--arkito-theme-wrapper -->
<?php wp_footer(); ?>
</body>
</html>
