<?php
/*
 * All CSS and JS files are enqueued from this file
 * Author & Copyright:helloexpert
 * URL: http://themeforest.net/user/helloexpert
 */

/**
 * Enqueue Files for FrontEnd
 */
function arkito_google_font_url() {
    $font_url = '';
    if ( 'off' !== esc_html__( 'on', 'arkito' ) ) {
        $font_url = add_query_arg( 'family', urlencode( 'Barlow Condensed:wght@400,500,600,700&display=swap|Heebo:wght@300,400,500,600&display=swap' ), "//fonts.googleapis.com/css" );
    }
    return $font_url;
}

if ( ! function_exists( 'arkito_scripts_styles' ) ) {
  function arkito_scripts_styles() {

    // Styles
    wp_enqueue_style( 'themify-icons', ARKITO_CSS .'/themify-icons.css', array(), '4.6.3', 'all' );
    wp_enqueue_style( 'flaticon', ARKITO_CSS .'/flaticon.css', array(), '1.0.0', 'all' );
    wp_enqueue_style( 'bootstrap', ARKITO_CSS .'/bootstrap.min.css', array(), '3.3.7', 'all' );
    wp_enqueue_style( 'animate', ARKITO_CSS .'/animate.css', array(), '3.5.1', 'all' );
    wp_enqueue_style( 'odometer', ARKITO_CSS .'/odometer.css', array(), '0.4.8', 'all' );
    wp_enqueue_style( 'owl-carousel', ARKITO_CSS .'/owl.carousel.css', array(), '2.0.0', 'all' );
    wp_enqueue_style( 'owl-theme', ARKITO_CSS .'/owl.theme.css', array(), '2.0.0', 'all' );
    wp_enqueue_style( 'slick', ARKITO_CSS .'/slick.css', array(), '1.6.0', 'all' );
    wp_enqueue_style( 'swiper', ARKITO_CSS .'/swiper.min.css', array(), '4.0.7', 'all' );
    wp_enqueue_style( 'slick-theme', ARKITO_CSS .'/slick-theme.css', array(), '1.6.0', 'all' );
    wp_enqueue_style( 'owl-transitions', ARKITO_CSS .'/owl.transitions.css', array(), '2.0.0', 'all' );
    wp_enqueue_style( 'fancybox', ARKITO_CSS .'/fancybox.css', array(), '2.0.0', 'all' );
    wp_enqueue_style( 'arkito-style', ARKITO_CSS .'/styles.css', array(), ARKITO_VERSION, 'all' );
    wp_enqueue_style( 'element', ARKITO_CSS .'/elements.css', array(), ARKITO_VERSION, 'all' );
    if ( !function_exists('cs_framework_init') ) {
      wp_enqueue_style('arkito-default-style', get_template_directory_uri() . '/style.css', array(),  ARKITO_VERSION, 'all' );
    }
    wp_enqueue_style( 'arkito-default-google-fonts', esc_url( arkito_google_font_url() ), array(), ARKITO_VERSION, 'all' );
    // Scripts
    wp_enqueue_script( 'bootstrap', ARKITO_SCRIPTS . '/bootstrap.min.js', array( 'jquery' ), '3.3.7', true );
    wp_enqueue_script( 'imagesloaded');
    wp_enqueue_script( 'isotope', ARKITO_SCRIPTS . '/isotope.min.js', array( 'jquery' ), '2.2.2', true );
    wp_enqueue_script( 'fancybox', ARKITO_SCRIPTS . '/fancybox.min.js', array( 'jquery' ), '2.1.5', true );
    wp_enqueue_script( 'instafeed', ARKITO_SCRIPTS . '/instafeed.min.js', array( 'jquery' ), '2.1.5', true );
    wp_enqueue_script( 'circle-progress', ARKITO_SCRIPTS . '/circle-progress.min.js', array( 'jquery' ), '2.1.5', true );
    wp_enqueue_script( 'masonry');
    wp_enqueue_script( 'owl-carousel', ARKITO_SCRIPTS . '/owl-carousel.js', array( 'jquery' ), '2.0.0', true );
    wp_enqueue_script( 'jquery-easing', ARKITO_SCRIPTS . '/jquery-easing.js', array( 'jquery' ), '1.4.0', true );
    wp_enqueue_script( 'wow', ARKITO_SCRIPTS . '/wow.min.js', array( 'jquery' ), '1.4.0', true );
    wp_enqueue_script( 'odometer', ARKITO_SCRIPTS . '/odometer.min.js', array( 'jquery' ), '0.4.8', true );
    wp_enqueue_script( 'magnific-popup', ARKITO_SCRIPTS . '/magnific-popup.js', array( 'jquery' ), '1.1.0', true );
    wp_enqueue_script( 'slick-slider', ARKITO_SCRIPTS . '/slick-slider.js', array( 'jquery' ), '1.6.0', true );
    wp_enqueue_script( 'swiper', ARKITO_SCRIPTS . '/swiper.min.js', array( 'jquery' ), '4.0.7', true );
    wp_enqueue_script( 'wc-quantity-increment', ARKITO_SCRIPTS . '/wc-quantity-increment.js', array( 'jquery' ), '1.0.0', true );
    wp_enqueue_script( 'arkito-scripts', ARKITO_SCRIPTS . '/scripts.js', array( 'jquery' ), ARKITO_VERSION, true );
    // Comments
    wp_enqueue_script( 'arkito-inline-validate', ARKITO_SCRIPTS . '/jquery.validate.min.js', array( 'jquery' ), '1.9.0', true );
    wp_add_inline_script( 'arkito-validate', 'jQuery(document).ready(function($) {$("#commentform").validate({rules: {author: {required: true,minlength: 2},email: {required: true,email: true},comment: {required: true,minlength: 10}}});});' );

    // Responsive Active
    $arkito_viewport = cs_get_option('theme_responsive');
    if( !$arkito_viewport ) {
      wp_enqueue_style( 'arkito-responsive', ARKITO_CSS .'/responsive.css', array(), ARKITO_VERSION, 'all' );
    }

    // Adds support for pages with threaded comments
    if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
      wp_enqueue_script( 'comment-reply' );
    }

  }
  add_action( 'wp_enqueue_scripts', 'arkito_scripts_styles' );
}

/**
 * Enqueue Files for BackEnd
 */
if ( ! function_exists( 'arkito_admin_scripts_styles' ) ) {
  function arkito_admin_scripts_styles() {

    wp_enqueue_style( 'arkito-admin-main', ARKITO_CSS . '/admin-styles.css', true );
    wp_enqueue_style( 'flaticon', ARKITO_CSS . '/flaticon.css', true );
    wp_enqueue_style( 'themify-icons', ARKITO_CSS . '/themify-icons.css', true );
    wp_enqueue_script( 'arkito-admin-scripts', ARKITO_SCRIPTS . '/admin-scripts.js', true );

  }
  add_action( 'admin_enqueue_scripts', 'arkito_admin_scripts_styles' );
}
