<?php
/*
 * All Theme Options for Arkito theme.
 * Author & Copyright:helloexpert
 * URL: http://themeforest.net/user/helloexpert
 */

function arkito_settings( $settings ) {

  $settings           = array(
    'menu_title'      => ARKITO_NAME . esc_html__(' Options', 'arkito'),
    'menu_slug'       => sanitize_title(ARKITO_NAME) . '_options',
    'menu_type'       => 'theme',
    'menu_icon'       => 'dashicons-awards',
    'menu_position'   => '4',
    'ajax_save'       => false,
    'show_reset_all'  => true,
    'framework_title' => ARKITO_NAME .' <small>V-'. ARKITO_VERSION .' by <a href="'. ARKITO_BRAND_URL .'" target="_blank">'. ARKITO_BRAND_NAME .'</a></small>',
  );

  return $settings;

}
add_filter( 'cs_framework_settings', 'arkito_settings' );

// Theme Framework Options
function arkito_options( $options ) {

  $options      = array(); // remove old options

  // ------------------------------
  // Branding
  // ------------------------------
  $options[]   = array(
    'name'     => 'arkito_theme_branding',
    'title'    => esc_html__('Brand', 'arkito'),
    'icon'     => 'fa fa-trophy',
    'sections' => array(

      // brand logo tab
      array(
        'name'     => 'brand_logo',
        'title'    => esc_html__('Logo', 'arkito'),
        'icon'     => 'fa fa-star',
        'fields'   => array(

          // Site Logo
          array(
            'type'    => 'notice',
            'class'   => 'info cs-arkito-heading',
            'content' => esc_html__('Site Logo', 'arkito')
          ),
          array(
            'id'    => 'arkito_logo',
            'type'  => 'image',
            'title' => esc_html__('Default Logo', 'arkito'),
            'info'  => esc_html__('Upload your default logo here. If you not upload, then site title will load in this logo location.', 'arkito'),
            'add_title' => esc_html__('Add Logo', 'arkito'),
          ),
          array(
            'id'    => 'arkito_trlogo',
            'type'  => 'image',
            'title' => esc_html__('Transparent Logo', 'arkito'),
            'info'  => esc_html__('Upload your Transparent logo here. If you not upload, then site title will load in this logo location.', 'arkito'),
            'add_title' => esc_html__('Add Logo', 'arkito'),
          ),
          array(
            'id'          => 'arkito_logo_top',
            'type'        => 'number',
            'title'       => esc_html__('Logo Top Space', 'arkito'),
            'attributes'  => array( 'placeholder' => 5 ),
            'unit'        => 'px',
          ),
          array(
            'id'          => 'arkito_logo_bottom',
            'type'        => 'number',
            'title'       => esc_html__('Logo Bottom Space', 'arkito'),
            'attributes'  => array( 'placeholder' => 5 ),
            'unit'        => 'px',
          ),
          // WordPress Admin Logo
          array(
            'type'    => 'notice',
            'class'   => 'info cs-arkito-heading',
            'content' => esc_html__('WordPress Admin Logo', 'arkito')
          ),
          array(
            'id'    => 'brand_logo_wp',
            'type'  => 'image',
            'title' => esc_html__('Login logo', 'arkito'),
            'info'  => esc_html__('Upload your WordPress login page logo here.', 'arkito'),
            'add_title' => esc_html__('Add Login Logo', 'arkito'),
          ),
        ) // end: fields
      ), // end: section
    ),
  );

  // ------------------------------
  // Layout
  // ------------------------------
  $options[] = array(
    'name'   => 'theme_layout',
    'title'  => esc_html__('Layout', 'arkito'),
    'icon'   => 'fa fa-file-text'
  );

  $options[]      = array(
    'name'        => 'theme_general',
    'title'       => esc_html__('General', 'arkito'),
    'icon'        => 'fa fa-wrench',

    // begin: fields
    'fields'      => array(

      // -----------------------------
      // Begin: Responsive
      // -----------------------------
       array(
        'id'    => 'theme_responsive',
        'off_text'  => 'No',
        'on_text'  => 'Yes',
        'type'  => 'switcher',
        'title' => esc_html__('Responsive', 'arkito'),
        'info' => esc_html__('Turn on if you don\'t want your site to be responsive.', 'arkito'),
        'default' => false,
      ),
      array(
        'id'    => 'theme_preloder',
        'off_text'  => 'No',
        'on_text'  => 'Yes',
        'type'  => 'switcher',
        'title' => esc_html__('Preloder', 'arkito'),
        'info' => esc_html__('Turn off if you don\'t want your site to be Preloder.', 'arkito'),
        'default' => true,
      ),
      array(
        'id'    => 'theme_layout_width',
        'type'  => 'image_select',
        'title' => esc_html__('Full Width & Extra Width', 'arkito'),
        'info' => esc_html__('Boxed or Fullwidth? Choose your site layout width. Default : Full Width', 'arkito'),
        'options'      => array(
          'container'    => ARKITO_CS_IMAGES .'/boxed-width.jpg',
          'container-fluid'    => ARKITO_CS_IMAGES .'/full-width.jpg',
        ),
        'default'      => 'container-fluid',
        'radio'      => true,
      ),
       array(
        'id'    => 'theme_page_comments',
        'type'  => 'switcher',
        'title' => esc_html__('Hide Page Comments?', 'arkito'),
        'label' => esc_html__('Yes! Hide Page Comments.', 'arkito'),
        'on_text' => esc_html__('Yes', 'arkito'),
        'off_text' => esc_html__('No', 'arkito'),
        'default' => false,
      ),
      array(
        'type'    => 'notice',
        'class'   => 'info cs-arkito-heading',
        'content' => esc_html__('Background Options', 'arkito'),
        'dependency' => array( 'theme_layout_width_container', '==', 'true' ),
      ),
      array(
        'id'             => 'theme_layout_bg_type',
        'type'           => 'select',
        'title'          => esc_html__('Background Type', 'arkito'),
        'options'        => array(
          'bg-image' => esc_html__('Image', 'arkito'),
          'bg-pattern' => esc_html__('Pattern', 'arkito'),
        ),
        'dependency' => array( 'theme_layout_width_container', '==', 'true' ),
      ),
      array(
        'id'    => 'theme_layout_bg_pattern',
        'type'  => 'image_select',
        'title' => esc_html__('Background Pattern', 'arkito'),
        'info' => esc_html__('Select background pattern', 'arkito'),
        'options'      => array(
          'pattern-1'    => ARKITO_CS_IMAGES . '/pattern-1.png',
          'pattern-2'    => ARKITO_CS_IMAGES . '/pattern-2.png',
          'pattern-3'    => ARKITO_CS_IMAGES . '/pattern-3.png',
          'pattern-4'    => ARKITO_CS_IMAGES . '/pattern-4.png',
          'custom-pattern'  => ARKITO_CS_IMAGES . '/pattern-5.png',
        ),
        'default'      => 'pattern-1',
        'radio'      => true,
        'dependency' => array( 'theme_layout_width_container|theme_layout_bg_type', '==|==', 'true|bg-pattern' ),
      ),
      array(
        'id'      => 'custom_bg_pattern',
        'type'    => 'upload',
        'title'   => esc_html__('Custom Pattern', 'arkito'),
        'dependency' => array( 'theme_layout_width_container|theme_layout_bg_type|theme_layout_bg_pattern_custom-pattern', '==|==|==', 'true|bg-pattern|true' ),
        'info' => __('Select your custom background pattern. <br />Note, background pattern image will be repeat in all x and y axis. So, please consider all repeatable area will perfectly fit your custom patterns.', 'arkito'),
      ),
      array(
        'id'      => 'theme_layout_bg',
        'type'    => 'background',
        'title'   => esc_html__('Background', 'arkito'),
        'dependency' => array( 'theme_layout_width_container|theme_layout_bg_type', '==|==', 'true|bg-image' ),
      ),

    ), // end: fields

  );

  // ------------------------------
  // Header Sections
  // ------------------------------
  $options[]   = array(
    'name'     => 'theme_header_tab',
    'title'    => esc_html__('Header', 'arkito'),
    'icon'     => 'fa fa-bars',
    'sections' => array(

      // header design tab
      array(
        'name'     => 'header_design_tab',
        'title'    => esc_html__('Design', 'arkito'),
        'icon'     => 'fa fa-magic',
        'fields'   => array(

          // Header Select
          array(
            'id'           => 'select_header_design',
            'type'         => 'image_select',
            'title'        => esc_html__('Select Header Design', 'arkito'),
            'options'      => array(
              'style_one'    => ARKITO_CS_IMAGES .'/hs-1.png',
              'style_two'    => ARKITO_CS_IMAGES .'/hs-2.png',
            ),
            'attributes' => array(
              'data-depend-id' => 'header_design',
            ),
            'radio'        => true,
            'default'   => 'style_one',
            'info' => esc_html__('Select your header design, following options will may differ based on your selection of header design.', 'arkito'),
          ),
          // Header Select

          // Extra's
          array(
            'type'    => 'notice',
            'class'   => 'info cs-arkito-heading',
            'content' => esc_html__('Extra\'s', 'arkito'),
          ),
          array(
            'id'    => 'sticky_header',
            'type'  => 'switcher',
            'title' => esc_html__('Sticky Header', 'arkito'),
            'info' => esc_html__('Turn On if you want your naviagtion bar on sticky.', 'arkito'),
            'default' => true,
          ),
          array(
            'id'    => 'arkito_cart_widget',
            'type'  => 'switcher',
            'title' => esc_html__('Header Cart', 'arkito'),
            'info' => esc_html__('Turn On if you want to Show Header Cart .', 'arkito'),
            'default' => false,
          ),
          array(
            'id'    => 'arkito_header_search',
            'type'  => 'switcher',
            'title' => esc_html__('Header Search', 'arkito'),
            'info' => esc_html__('Turn On if you want to Show Header Search .', 'arkito'),
            'default' => false,
          ),
          array(
            'id'    => 'arkito_menu_social',
            'type'  => 'switcher',
            'title' => esc_html__('Header Social', 'arkito'),
            'info' => esc_html__('Turn On if you want to Show Header Social .', 'arkito'),
            'default' => false,
          ),
          array(
            'id'    => 'header_social',
            'type'  => 'text',
            'title' => esc_html__('Header Social', 'arkito'),
            'info' => esc_html__('Write Header Social here.', 'arkito'),
            'type'        => 'textarea',
            'shortcode'   => true,
            'dependency'  => array('arkito_menu_social', '==', true),
          ),
        )
      ),

      // header top bar
      array(
        'name'     => 'header_top_bar_tab',
        'title'    => esc_html__('Top Bar', 'arkito'),
        'icon'     => 'fa fa-minus',
        'fields'   => array(

          array(
            'id'          => 'top_bar',
            'type'        => 'switcher',
            'title'       => esc_html__('Hide Top Bar', 'arkito'),
            'on_text'     => esc_html__('Yes', 'arkito'),
            'off_text'    => esc_html__('No', 'arkito'),
            'default'     => true,
          ),
          array(
            'id'          => 'top_left',
            'title'       => esc_html__('Top left Block', 'arkito'),
            'desc'        => esc_html__('Top bar left block.', 'arkito'),
            'type'        => 'textarea',
            'shortcode'   => true,
            'dependency'  => array('top_bar', '==', false),
          ),
          array(
            'id'          => 'top_right',
            'title'       => esc_html__('Top Right Block', 'arkito'),
            'desc'        => esc_html__('Top bar right block.', 'arkito'),
            'type'        => 'textarea',
            'shortcode'   => true,
            'dependency'  => array('top_bar', '==', false),
          ),
        )
      ),

      // header banner
      array(
        'name'     => 'header_banner_tab',
        'title'    => esc_html__('Title Bar (or) Banner', 'arkito'),
        'icon'     => 'fa fa-bullhorn',
        'fields'   => array(

          // Title Area
          array(
            'type'    => 'notice',
            'class'   => 'info cs-arkito-heading',
            'content' => esc_html__('Title Area', 'arkito')
          ),
          array(
            'id'      => 'need_title_bar',
            'type'    => 'switcher',
            'title'   => esc_html__('Title Bar ?', 'arkito'),
            'label'   => esc_html__('If you want to Hide title bar in your sub-pages, please turn this ON.', 'arkito'),
            'default'    => false,
          ),
          array(
            'id'             => 'title_bar_padding',
            'type'           => 'select',
            'title'          => esc_html__('Padding Spaces Top & Bottom', 'arkito'),
            'options'        => array(
              'padding-default' => esc_html__('Default Spacing', 'arkito'),
              'padding-custom' => esc_html__('Custom Padding', 'arkito'),
            ),
            'dependency'   => array( 'need_title_bar', '==', 'false' ),
          ),
          array(
            'id'             => 'titlebar_top_padding',
            'type'           => 'text',
            'title'          => esc_html__('Padding Top', 'arkito'),
            'attributes' => array(
              'placeholder'     => '100px',
            ),
            'dependency'   => array( 'title_bar_padding', '==', 'padding-custom' ),
          ),
          array(
            'id'             => 'titlebar_bottom_padding',
            'type'           => 'text',
            'title'          => esc_html__('Padding Bottom', 'arkito'),
            'attributes' => array(
              'placeholder'     => '100px',
            ),
            'dependency'   => array( 'title_bar_padding', '==', 'padding-custom' ),
          ),

          array(
            'type'    => 'notice',
            'class'   => 'info cs-arkito-heading',
            'content' => esc_html__('Background Options', 'arkito'),
            'dependency' => array( 'need_title_bar', '==', 'false' ),
          ),
          array(
            'id'      => 'titlebar_bg_overlay_color',
            'type'    => 'color_picker',
            'title'   => esc_html__('Overlay Color', 'arkito'),
            'dependency' => array( 'need_title_bar', '==', 'false' ),
          ),
          array(
            'id'    => 'title_color',
            'type'  => 'color_picker',
            'title' => esc_html__('Title Color', 'arkito'),
            'dependency'   => array('banner_type', '==', 'default-title'),
          ),

          array(
            'type'    => 'notice',
            'class'   => 'info cs-arkito-heading',
            'content' => esc_html__('Breadcrumbs', 'arkito'),
          ),
         array(
            'id'      => 'need_breadcrumbs',
            'type'    => 'switcher',
            'title'   => esc_html__('Hide Breadcrumbs', 'arkito'),
            'label'   => esc_html__('If you want to hide breadcrumbs in your banner, please turn this ON.', 'arkito'),
            'default'    => false,
          ),
        )
      ),

    ),
  );

  // ------------------------------
  // Footer Section
  // ------------------------------
  $options[]   = array(
    'name'     => 'footer_section',
    'title'    => esc_html__('Footer', 'arkito'),
    'icon'     => 'fa fa-ellipsis-h',
    'sections' => array(

      // footer widgets
      array(
        'name'     => 'footer_widgets_tab',
        'title'    => esc_html__('Widget Area', 'arkito'),
        'icon'     => 'fa fa-th',
        'fields'   => array(

          // Footer Widget Block
          array(
            'type'    => 'notice',
            'class'   => 'info cs-arkito-heading',
            'content' => esc_html__('Footer Widget Block', 'arkito')
          ),
          array(
            'id'    => 'footer_widget_block',
            'type'  => 'switcher',
            'title' => esc_html__('Enable Widget Block', 'arkito'),
            'info' => __('If you turn this ON, then Goto : Appearance > Widgets. There you can see <strong>Footer Widget 1,2,3 or 4</strong> Widget Area, add your widgets there.', 'arkito'),
            'default' => true,
          ),
          array(
            'id'    => 'footer_widget_layout',
            'type'  => 'image_select',
            'title' => esc_html__('Widget Layouts', 'arkito'),
            'info' => esc_html__('Choose your footer widget theme-layouts.', 'arkito'),
            'default' => 4,
            'options' => array(
              1   => ARKITO_CS_IMAGES . '/footer/footer-1.png',
              2   => ARKITO_CS_IMAGES . '/footer/footer-2.png',
              3   => ARKITO_CS_IMAGES . '/footer/footer-3.png',
              4   => ARKITO_CS_IMAGES . '/footer/footer-4.png',
              5   => ARKITO_CS_IMAGES . '/footer/footer-5.png',
              6   => ARKITO_CS_IMAGES . '/footer/footer-6.png',
              7   => ARKITO_CS_IMAGES . '/footer/footer-7.png',
              8   => ARKITO_CS_IMAGES . '/footer/footer-8.png',
              9   => ARKITO_CS_IMAGES . '/footer/footer-9.png',
            ),
            'radio'       => true,
            'dependency'  => array('footer_widget_block', '==', true),
          ),
           array(
            'id'    => 'arkito_ft_bg',
            'type'  => 'image',
            'title' => esc_html__('Footer Background', 'arkito'),
            'info'  => esc_html__('Upload your footer background.', 'arkito'),
            'add_title' => esc_html__('footer background', 'arkito'),
            'dependency'  => array('footer_widget_block', '==', true),
          ),

        )
      ),

      // footer copyright
      array(
        'name'     => 'footer_copyright_tab',
        'title'    => esc_html__('Copyright Bar', 'arkito'),
        'icon'     => 'fa fa-copyright',
        'fields'   => array(

          // Copyright
          array(
            'type'    => 'notice',
            'class'   => 'info cs-arkito-heading',
            'content' => esc_html__('Copyright Layout', 'arkito'),
          ),
         array(
            'id'    => 'hide_copyright',
            'type'  => 'switcher',
            'title' => esc_html__('Hide Copyright?', 'arkito'),
            'default' => false,
            'on_text' => esc_html__('Yes', 'arkito'),
            'off_text' => esc_html__('No', 'arkito'),
            'label' => esc_html__('Yes, do it!', 'arkito'),
          ),
          array(
            'id'    => 'footer_copyright_layout',
            'type'  => 'image_select',
            'title' => esc_html__('Select Copyright Layout', 'arkito'),
            'info' => esc_html__('In above image, blue box is copyright text and yellow box is secondary text.', 'arkito'),
            'default'      => 'copyright-3',
            'options'      => array(
              'copyright-1'    => ARKITO_CS_IMAGES .'/footer/copyright-1.png',
              ),
            'radio'        => true,
            'dependency'     => array('hide_copyright', '!=', true),
          ),
          array(
            'id'    => 'copyright_text',
            'type'  => 'textarea',
            'title' => esc_html__('Copyright Text', 'arkito'),
            'shortcode' => true,
            'dependency' => array('hide_copyright', '!=', true),
            'after'       => 'Helpful shortcodes: [current_year] [home_url] or any shortcode.',
          ),

          // Copyright Another Text
          array(
            'type'    => 'notice',
            'class'   => 'warning cs-arkito-heading',
            'content' => esc_html__('Copyright Secondary Text', 'arkito'),
             'dependency'     => array('hide_copyright', '!=', true),
          ),
          array(
            'id'    => 'secondary_text',
            'type'  => 'textarea',
            'title' => esc_html__('Secondary Text', 'arkito'),
            'shortcode' => true,
            'dependency'     => array('hide_copyright', '!=', true),
          ),

        )
      ),

    ),
  );

  // ------------------------------
  // Design
  // ------------------------------
  $options[] = array(
    'name'   => 'theme_design',
    'title'  => esc_html__('Design', 'arkito'),
    'icon'   => 'fa fa-magic'
  );

  // ------------------------------
  // color section
  // ------------------------------
  $options[]   = array(
    'name'     => 'theme_color_section',
    'title'    => esc_html__('Colors', 'arkito'),
    'icon'     => 'fa fa-eyedropper',
    'fields' => array(

      array(
        'type'    => 'heading',
        'content' => esc_html__('Color Options', 'arkito'),
      ),
      array(
        'type'    => 'subheading',
        'wrap_class' => 'color-tab-content',
        'content' => esc_html__('All color options are available in our theme customizer. The reason of we used customizer options for color section is because, you can choose each part of color from there and see the changes instantly using customizer. Highly customizable colors are in Appearance > Customize', 'arkito'),
      ),

    ),
  );

  // ------------------------------
  // Typography section
  // ------------------------------
  $options[]   = array(
    'name'     => 'theme_typo_section',
    'title'    => esc_html__('Typography', 'arkito'),
    'icon'     => 'fa fa-header',
    'fields' => array(

      // Start fields
      array(
        'id'                  => 'typography',
        'type'                => 'group',
        'fields'              => array(
          array(
            'id'              => 'title',
            'type'            => 'text',
            'title'           => esc_html__('Title', 'arkito'),
          ),
          array(
            'id'              => 'selector',
            'type'            => 'textarea',
            'title'           => esc_html__('Selector', 'arkito'),
            'info'           => wp_kses( __('Enter css selectors like : <strong>body, .custom-class</strong>', 'arkito'), array( 'strong' => array() ) ),
          ),
          array(
            'id'              => 'font',
            'type'            => 'typography',
            'title'           => esc_html__('Font Family', 'arkito'),
          ),
          array(
            'id'              => 'size',
            'type'            => 'text',
            'title'           => esc_html__('Font Size', 'arkito'),
          ),
          array(
            'id'              => 'line_height',
            'type'            => 'text',
            'title'           => esc_html__('Line-Height', 'arkito'),
          ),
          array(
            'id'              => 'css',
            'type'            => 'textarea',
            'title'           => esc_html__('Custom CSS', 'arkito'),
          ),
        ),
        'button_title'        => esc_html__('Add New Typography', 'arkito'),
        'accordion_title'     => esc_html__('New Typography', 'arkito'),
      ),

      // Subset
      array(
        'id'                  => 'subsets',
        'type'                => 'select',
        'title'               => esc_html__('Subsets', 'arkito'),
        'class'               => 'chosen',
        'options'             => array(
          'latin'             => 'latin',
          'latin-ext'         => 'latin-ext',
          'cyrillic'          => 'cyrillic',
          'cyrillic-ext'      => 'cyrillic-ext',
          'greek'             => 'greek',
          'greek-ext'         => 'greek-ext',
          'vietnamese'        => 'vietnamese',
          'devanagari'        => 'devanagari',
          'khmer'             => 'khmer',
        ),
        'attributes'         => array(
          'data-placeholder' => 'Subsets',
          'multiple'         => 'multiple',
          'style'            => 'width: 200px;'
        ),
        'default'             => array( 'latin' ),
      ),

      array(
        'id'                  => 'font_weight',
        'type'                => 'select',
        'title'               => esc_html__('Font Weights', 'arkito'),
        'class'               => 'chosen',
        'options'             => array(
          '100'   => esc_html__('Thin 100', 'arkito'),
          '100i'  => esc_html__('Thin 100 Italic', 'arkito'),
          '200'   => esc_html__('Extra Light 200', 'arkito'),
          '200i'  => esc_html__('Extra Light 200 Italic', 'arkito'),
          '300'   => esc_html__('Light 300', 'arkito'),
          '300i'  => esc_html__('Light 300 Italic', 'arkito'),
          '400'   => esc_html__('Regular 400', 'arkito'),
          '400i'  => esc_html__('Regular 400 Italic', 'arkito'),
          '500'   => esc_html__('Medium 500', 'arkito'),
          '500i'  => esc_html__('Medium 500 Italic', 'arkito'),
          '600'   => esc_html__('Semi Bold 600', 'arkito'),
          '600i'  => esc_html__('Semi Bold 600 Italic', 'arkito'),
          '700'   => esc_html__('Bold 700', 'arkito'),
          '700i'  => esc_html__('Bold 700 Italic', 'arkito'),
          '800'   => esc_html__('Extra Bold 800', 'arkito'),
          '800i'  => esc_html__('Extra Bold 800 Italic', 'arkito'),
          '900'   => esc_html__('Black 900', 'arkito'),
          '900i'  => esc_html__('Black 900 Italic', 'arkito'),
        ),
        'attributes'         => array(
          'data-placeholder' => esc_html__('Font Weight', 'arkito'),
          'multiple'         => 'multiple',
          'style'            => 'width: 200px;'
        ),
        'default'             => array( '400' ),
      ),

      // Custom Fonts Upload
      array(
        'id'                 => 'font_family',
        'type'               => 'group',
        'title'              => esc_html__('Upload Custom Fonts', 'arkito'),
        'button_title'       => esc_html__('Add New Custom Font', 'arkito'),
        'accordion_title'    => esc_html__('Adding New Font', 'arkito'),
        'accordion'          => true,
        'desc'               => esc_html__('It is simple. Only add your custom fonts and click to save. After you can check "Font Family" selector. Do not forget to Save!', 'arkito'),
        'fields'             => array(

          array(
            'id'             => 'name',
            'type'           => 'text',
            'title'          => esc_html__('Font-Family Name', 'arkito'),
            'attributes'     => array(
              'placeholder'  => esc_html__('for eg. Arial', 'arkito')
            ),
          ),

          array(
            'id'             => 'ttf',
            'type'           => 'upload',
            'title'          => wp_kses(__('Upload .ttf <small><i>(optional)</i></small>', 'arkito'), array( 'small' => array(), 'i' => array() )),
            'settings'       => array(
              'upload_type'  => 'font',
              'insert_title' => esc_html__('Use this Font-Format', 'arkito'),
              'button_title' => wp_kses(__('Upload <i>.ttf</i>', 'arkito'), array( 'i' => array() )),
            ),
          ),

          array(
            'id'             => 'eot',
            'type'           => 'upload',
            'title'          => wp_kses(__('Upload .eot <small><i>(optional)</i></small>', 'arkito'), array( 'small' => array(), 'i' => array() )),
            'settings'       => array(
              'upload_type'  => 'font',
              'insert_title' => esc_html__('Use this Font-Format', 'arkito'),
              'button_title' => wp_kses(__('Upload <i>.eot</i>', 'arkito'), array( 'i' => array() )),
            ),
          ),

          array(
            'id'             => 'otf',
            'type'           => 'upload',
            'title'          => wp_kses(__('Upload .otf <small><i>(optional)</i></small>', 'arkito'), array( 'small' => array(), 'i' => array() )),
            'settings'       => array(
              'upload_type'  => 'font',
              'insert_title' => esc_html__('Use this Font-Format', 'arkito'),
              'button_title' => wp_kses(__('Upload <i>.otf</i>', 'arkito'), array( 'i' => array() )),
            ),
          ),

          array(
            'id'             => 'woff',
            'type'           => 'upload',
            'title'          => wp_kses(__('Upload .woff <small><i>(optional)</i></small>', 'arkito'), array( 'small' => array(), 'i' => array() )),
            'settings'       => array(
              'upload_type'  => 'font',
              'insert_title' => esc_html__('Use this Font-Format', 'arkito'),
              'button_title' =>wp_kses(__('Upload <i>.woff</i>', 'arkito'), array( 'i' => array() )),
            ),
          ),

          array(
            'id'             => 'css',
            'type'           => 'textarea',
            'title'          => wp_kses(__('Extra CSS Style <small><i>(optional)</i></small>', 'arkito'), array( 'small' => array(), 'i' => array() )),
            'attributes'     => array(
              'placeholder'  => esc_html__('for eg. font-weight: normal;', 'arkito'),
            ),
          ),

        ),
      ),
      // End All field

    ),
  );

  // ------------------------------
  // Pages
  // ------------------------------
  $options[] = array(
    'name'   => 'theme_pages',
    'title'  => esc_html__('Pages', 'arkito'),
    'icon'   => 'fa fa-files-o'
  );


  // ------------------------------
  // Service Section
  // ------------------------------
  $options[]   = array(
    'name'     => 'service_section',
    'title'    => esc_html__('Service', 'arkito'),
    'icon'     => 'fa fa-address-book-o',
    'fields' => array(

      // service name change
      array(
        'type'    => 'notice',
        'class'   => 'info cs-tmx-heading',
        'content' => esc_html__('Name Change', 'arkito')
      ),
      array(
        'id'      => 'theme_service_name',
        'type'    => 'text',
        'title'   => esc_html__('Service Name', 'arkito'),
        'attributes'     => array(
          'placeholder'  => 'Service'
        ),
      ),
      array(
        'id'      => 'theme_service_slug',
        'type'    => 'text',
        'title'   => esc_html__('Service Slug', 'arkito'),
        'attributes'     => array(
          'placeholder'  => 'service-item'
        ),
      ),
      array(
        'id'      => 'theme_service_cat_slug',
        'type'    => 'text',
        'title'   => esc_html__('Service Category Slug', 'arkito'),
        'attributes'     => array(
          'placeholder'  => 'service-category'
        ),
      ),
      array(
        'type'    => 'notice',
        'class'   => 'danger',
        'content' => __('<strong>Important</strong>: Please do not set service slug and page slug as same. It\'ll not work.', 'arkito')
      ),
      // Service Start
      array(
        'type'    => 'notice',
        'class'   => 'info cs-arkito-heading',
        'content' => esc_html__('Service Single', 'arkito')
      ),
      array(
          'id'             => 'service_sidebar_position',
          'type'           => 'select',
          'title'          => esc_html__('Sidebar Position', 'arkito'),
          'options'        => array(
            'sidebar-right' => esc_html__('Right', 'arkito'),
            'sidebar-left' => esc_html__('Left', 'arkito'),
            'sidebar-hide' => esc_html__('Hide', 'arkito'),
          ),
          'default_option' => 'Select sidebar position',
          'info'          => esc_html__('Default option : Right', 'arkito'),
        ),
        array(
          'id'             => 'single_service_widget',
          'type'           => 'select',
          'title'          => esc_html__('Sidebar Widget', 'arkito'),
          'options'        => arkito_registered_sidebars(),
          'default_option' => esc_html__('Select Widget', 'arkito'),
          'dependency'     => array('service_sidebar_position', '!=', 'sidebar-hide'),
          'info'          => esc_html__('Default option : Main Widget Area', 'arkito'),
        ),
        array(
          'id'    => 'service_comment_form',
          'type'  => 'switcher',
          'title' => esc_html__('Comment Area/Form', 'arkito'),
          'info' => esc_html__('If need to hide comment area and that form on single blog page, please turn this OFF.', 'arkito'),
          'default' => true,
        ),
    ),
  );

  
  // ------------------------------
  // Project Section
  // ------------------------------
  $options[]   = array(
    'name'     => 'project_section',
    'title'    => esc_html__('Project', 'arkito'),
    'icon'     => 'fa fa-medkit',
    'fields' => array(

      // project name change
      array(
        'type'    => 'notice',
        'class'   => 'info cs-tmx-heading',
        'content' => esc_html__('Name Change', 'arkito')
      ),
      array(
        'id'      => 'theme_project_name',
        'type'    => 'text',
        'title'   => esc_html__('Project Name', 'arkito'),
        'attributes'     => array(
          'placeholder'  => 'Project'
        ),
      ),
      array(
        'id'      => 'theme_project_slug',
        'type'    => 'text',
        'title'   => esc_html__('Project Slug', 'arkito'),
        'attributes'     => array(
          'placeholder'  => 'project-item'
        ),
      ),
      array(
        'id'      => 'theme_project_cat_slug',
        'type'    => 'text',
        'title'   => esc_html__('Project Category Slug', 'arkito'),
        'attributes'     => array(
          'placeholder'  => 'project-category'
        ),
      ),
      array(
        'type'    => 'notice',
        'class'   => 'danger',
        'content' => __('<strong>Important</strong>: Please do not set project slug and page slug as same. It\'ll not work.', 'arkito')
      ),

      // Project Start
      array(
        'type'    => 'notice',
        'class'   => 'info cs-arkito-heading',
        'content' => esc_html__('Project Single', 'arkito')
      ),
      array(
          'id'             => 'project_sidebar_position',
          'type'           => 'select',
          'title'          => esc_html__('Sidebar Position', 'arkito'),
          'options'        => array(
            'sidebar-right' => esc_html__('Right', 'arkito'),
            'sidebar-left' => esc_html__('Left', 'arkito'),
            'sidebar-hide' => esc_html__('Hide', 'arkito'),
          ),
          'default_option' => 'Select sidebar position',
          'info'          => esc_html__('Default option : Right', 'arkito'),
        ),
        array(
          'id'             => 'single_project_widget',
          'type'           => 'select',
          'title'          => esc_html__('Sidebar Widget', 'arkito'),
          'options'        => arkito_registered_sidebars(),
          'default_option' => esc_html__('Select Widget', 'arkito'),
          'dependency'     => array('project_sidebar_position', '!=', 'sidebar-hide'),
          'info'          => esc_html__('Default option : Main Widget Area', 'arkito'),
        ),
        array(
          'id'    => 'project_comment_form',
          'type'  => 'switcher',
          'title' => esc_html__('Comment Area/Form', 'arkito'),
          'info' => esc_html__('If need to hide comment area and that form on single blog page, please turn this OFF.', 'arkito'),
          'default' => true,
        ),
    ),
  );

  // ------------------------------
  // Blog Section
  // ------------------------------
  $options[]   = array(
    'name'     => 'blog_section',
    'title'    => esc_html__('Blog', 'arkito'),
    'icon'     => 'fa fa-edit',
    'sections' => array(

      // blog general section
      array(
        'name'     => 'blog_general_tab',
        'title'    => esc_html__('General', 'arkito'),
        'icon'     => 'fa fa-cog',
        'fields'   => array(

          // Layout
          array(
            'type'    => 'notice',
            'class'   => 'info cs-arkito-heading',
            'content' => esc_html__('Layout', 'arkito')
          ),
          array(
            'id'             => 'blog_sidebar_position',
            'type'           => 'select',
            'title'          => esc_html__('Sidebar Position', 'arkito'),
            'options'        => array(
              'sidebar-right' => esc_html__('Right', 'arkito'),
              'sidebar-left' => esc_html__('Left', 'arkito'),
              'sidebar-hide' => esc_html__('Hide', 'arkito'),
            ),
            'default_option' => 'Select sidebar position',
            'help'          => esc_html__('This style will apply, default blog pages - Like : Archive, Category, Tags, Search & Author.', 'arkito'),
            'info'          => esc_html__('Default option : Right', 'arkito'),
          ),
          array(
            'id'             => 'blog_widget',
            'type'           => 'select',
            'title'          => esc_html__('Sidebar Widget', 'arkito'),
            'options'        => arkito_registered_sidebars(),
            'default_option' => esc_html__('Select Widget', 'arkito'),
            'dependency'     => array('blog_sidebar_position', '!=', 'sidebar-hide'),
            'info'          => esc_html__('Default option : Main Widget Area', 'arkito'),
          ),
          // Layout
          // Global Options
          array(
            'type'    => 'notice',
            'class'   => 'info cs-arkito-heading',
            'content' => esc_html__('Global Options', 'arkito')
          ),
          array(
            'id'         => 'theme_exclude_categories',
            'type'       => 'checkbox',
            'title'      => esc_html__('Exclude Categories', 'arkito'),
            'info'      => esc_html__('Select categories you want to exclude from blog page.', 'arkito'),
            'options'    => 'categories',
          ),
          array(
            'id'      => 'theme_blog_excerpt',
            'type'    => 'text',
            'title'   => esc_html__('Excerpt Length', 'arkito'),
            'info'   => esc_html__('Blog short content length, in blog listing pages.', 'arkito'),
            'default' => '55',
          ),
          array(
            'id'      => 'theme_metas_hide',
            'type'    => 'checkbox',
            'title'   => esc_html__('Meta\'s to hide', 'arkito'),
            'info'    => esc_html__('Check items you want to hide from blog/post meta field.', 'arkito'),
            'class'      => 'horizontal',
            'options'    => array(
              'category'   => esc_html__('Category', 'arkito'),
              'date'    => esc_html__('Date', 'arkito'),
              'author'     => esc_html__('Author', 'arkito'),
              'comments'      => esc_html__('Comments', 'arkito'),
              'Tag'      => esc_html__('Tag', 'arkito'),
            ),
            // 'default' => '30',
          ),
          // End fields

        )
      ),

      // blog single section
      array(
        'name'     => 'blog_single_tab',
        'title'    => esc_html__('Single', 'arkito'),
        'icon'     => 'fa fa-sticky-note',
        'fields'   => array(

          // Start fields
          array(
            'type'    => 'notice',
            'class'   => 'info cs-arkito-heading',
            'content' => esc_html__('Enable / Disable', 'arkito')
          ),
          array(
            'id'    => 'single_featured_image',
            'type'  => 'switcher',
            'title' => esc_html__('Featured Image', 'arkito'),
            'info' => esc_html__('If need to hide featured image from single blog post page, please turn this OFF.', 'arkito'),
            'default' => true,
          ),
           array(
            'id'    => 'single_author_info',
            'type'  => 'switcher',
            'title' => esc_html__('Author Info', 'arkito'),
            'info' => esc_html__('If need to hide author info on single blog page, please turn this On.', 'arkito'),
            'default' => false,
          ),
          array(
            'id'    => 'single_share_option',
            'type'  => 'switcher',
            'title' => esc_html__('Share Option', 'arkito'),
            'info' => esc_html__('If need to hide share option on single blog page, please turn this OFF.', 'arkito'),
            'default' => true,
          ),
          array(
            'id'    => 'single_comment_form',
            'type'  => 'switcher',
            'title' => esc_html__('Comment Area/Form ?', 'arkito'),
            'info' => esc_html__('If need to hide comment area and that form on single blog page, please turn this On.', 'arkito'),
            'default' => false,
          ),
          array(
            'type'    => 'notice',
            'class'   => 'info cs-arkito-heading',
            'content' => esc_html__('Sidebar', 'arkito')
          ),
          array(
            'id'             => 'single_sidebar_position',
            'type'           => 'select',
            'title'          => esc_html__('Sidebar Position', 'arkito'),
            'options'        => array(
              'sidebar-right' => esc_html__('Right', 'arkito'),
              'sidebar-left' => esc_html__('Left', 'arkito'),
              'sidebar-hide' => esc_html__('Hide', 'arkito'),
            ),
            'default_option' => 'Select sidebar position',
            'info'          => esc_html__('Default option : Right', 'arkito'),
          ),
          array(
            'id'             => 'single_blog_widget',
            'type'           => 'select',
            'title'          => esc_html__('Sidebar Widget', 'arkito'),
            'options'        => arkito_registered_sidebars(),
            'default_option' => esc_html__('Select Widget', 'arkito'),
            'dependency'     => array('single_sidebar_position', '!=', 'sidebar-hide'),
            'info'          => esc_html__('Default option : Main Widget Area', 'arkito'),
          ),
          // End fields

        )
      ),

    ),
  );

if (class_exists( 'WooCommerce' )){
  // ------------------------------
  // WooCommerce Section
  // ------------------------------
  $options[]   = array(
    'name'     => 'woocommerce_section',
    'title'    => esc_html__('WooCommerce', 'arkito'),
    'icon'     => 'fa fa-shopping-cart',
    'fields' => array(

      // Start fields
      array(
        'type'    => 'notice',
        'class'   => 'info cs-arkito-heading',
        'content' => esc_html__('Layout', 'arkito')
      ),
     array(
        'id'             => 'woo_product_columns',
        'type'           => 'select',
        'title'          => esc_html__('Product Column', 'arkito'),
        'options'        => array(
          2 => esc_html__('Two Column', 'arkito'),
          3 => esc_html__('Three Column', 'arkito'),
          4 => esc_html__('Four Column', 'arkito'),
        ),
        'default_option' => esc_html__('Select Product Columns', 'arkito'),
        'help'          => esc_html__('This style will apply, default woocommerce shop and archive pages.', 'arkito'),
      ),
      array(
        'id'             => 'woo_sidebar_position',
        'type'           => 'select',
        'title'          => esc_html__('Sidebar Position', 'arkito'),
        'options'        => array(
          'right-sidebar' => esc_html__('Right', 'arkito'),
          'left-sidebar' => esc_html__('Left', 'arkito'),
          'sidebar-hide' => esc_html__('Hide', 'arkito'),
        ),
        'default_option' => esc_html__('Select sidebar position', 'arkito'),
        'info'          => esc_html__('Default option : Right', 'arkito'),
      ),
      array(
        'id'             => 'woo_widget',
        'type'           => 'select',
        'title'          => esc_html__('Sidebar Widget', 'arkito'),
        'options'        => arkito_registered_sidebars(),
        'default_option' => esc_html__('Select Widget', 'arkito'),
        'dependency'     => array('woo_sidebar_position', '!=', 'sidebar-hide'),
        'info'          => esc_html__('Default option : Shop Page', 'arkito'),
      ),

      array(
        'type'    => 'notice',
        'class'   => 'info cs-arkito-heading',
        'content' => esc_html__('Listing', 'arkito')
      ),
      array(
        'id'      => 'theme_woo_limit',
        'type'    => 'text',
        'title'   => esc_html__('Product Limit', 'arkito'),
        'info'   => esc_html__('Enter the number value for per page products limit.', 'arkito'),
      ),
      // End fields

      // Start fields
      array(
        'type'    => 'notice',
        'class'   => 'info cs-arkito-heading',
        'content' => esc_html__('Single Product', 'arkito')
      ),
      array(
        'id'             => 'woo_related_limit',
        'type'           => 'text',
        'title'          => esc_html__('Related Products Limit', 'arkito'),
      ),
      array(
        'id'    => 'woo_single_upsell',
        'type'  => 'switcher',
        'title' => esc_html__('You May Also Like', 'arkito'),
        'info' => esc_html__('If you don\'t want \'You May Also Like\' products in single product page, please turn this ON.', 'arkito'),
        'default' => false,
      ),
      array(
        'id'    => 'woo_single_related',
        'type'  => 'switcher',
        'title' => esc_html__('Related Products', 'arkito'),
        'info' => esc_html__('If you don\'t want \'Related Products\' in single product page, please turn this ON.', 'arkito'),
        'default' => false,
      ),
      // End fields

    ),
  );
}

  // ------------------------------
  // Extra Pages
  // ------------------------------
  $options[]   = array(
    'name'     => 'theme_extra_pages',
    'title'    => esc_html__('Extra Pages', 'arkito'),
    'icon'     => 'fa fa-clone',
    'sections' => array(

      // error 404 page
      array(
        'name'     => 'error_page_section',
        'title'    => esc_html__('404 Page', 'arkito'),
        'icon'     => 'fa fa-exclamation-triangle',
        'fields'   => array(

          // Start 404 Page
          array(
            'id'    => 'error_heading',
            'type'  => 'text',
            'title' => esc_html__('404 Page Heading', 'arkito'),
            'info'  => esc_html__('Enter 404 page heading.', 'arkito'),
          ),
          array(
            'id'    => 'error_subheading',
            'type'  => 'textarea',
            'title' => esc_html__('404 Page Sub Heading', 'arkito'),
            'info'  => esc_html__('Enter 404 page Sub heading.', 'arkito'),
          ),
          array(
            'id'    => 'error_page_content',
            'type'  => 'textarea',
            'title' => esc_html__('404 Page Content', 'arkito'),
            'info'  => esc_html__('Enter 404 page content.', 'arkito'),
            'shortcode' => true,
          ),
          array(
            'id'    => 'error_btn_text',
            'type'  => 'text',
            'title' => esc_html__('Button Text', 'arkito'),
            'info'  => esc_html__('Enter BACK TO HOME button text. If you want to change it.', 'arkito'),
          ),
          // End 404 Page

        ) // end: fields
      ), // end: fields section

      // maintenance mode page
      array(
        'name'     => 'maintenance_mode_section',
        'title'    => esc_html__('Maintenance Mode', 'arkito'),
        'icon'     => 'fa fa-hourglass-half',
        'fields'   => array(

          // Start Maintenance Mode
          array(
            'type'    => 'notice',
            'class'   => 'info cs-arkito-heading',
            'content' => esc_html__('If you turn this ON : Only Logged in users will see your pages. All other visiters will see, selected page of : <strong>Maintenance Mode Page</strong>', 'arkito')
          ),
          array(
            'id'             => 'enable_maintenance_mode',
            'type'           => 'switcher',
            'title'          => esc_html__('Maintenance Mode', 'arkito'),
            'default'        => false,
          ),
          array(
            'id'             => 'maintenance_mode_page',
            'type'           => 'select',
            'title'          => esc_html__('Maintenance Mode Page', 'arkito'),
            'options'        => 'pages',
            'default_option' => esc_html__('Select a page', 'arkito'),
            'dependency'   => array( 'enable_maintenance_mode', '==', 'true' ),
          ),
          array(
            'id'             => 'maintenance_mode_title',
            'type'           => 'text',
            'title'          => esc_html__('Maintenance Mode Text', 'arkito'),
            'dependency'   => array( 'enable_maintenance_mode', '==', 'true' ),
          ),
          array(
            'id'             => 'maintenance_mode_text',
            'type'           => 'textarea',
            'title'          => esc_html__('Maintenance Mode Text', 'arkito'),
            'dependency'   => array( 'enable_maintenance_mode', '==', 'true' ),
          ),
          array(
            'id'             => 'maintenance_mode_bg',
            'type'           => 'background',
            'title'          => esc_html__('Page Background', 'arkito'),
            'dependency'   => array( 'enable_maintenance_mode', '==', 'true' ),
          ),
          // End Maintenance Mode

        ) // end: fields
      ), // end: fields section

    )
  );

  // ------------------------------
  // Advanced
  // ------------------------------
  $options[] = array(
    'name'   => 'theme_advanced',
    'title'  => esc_html__('Advanced', 'arkito'),
    'icon'   => 'fa fa-cog'
  );

  // ------------------------------
  // Misc Section
  // ------------------------------
  $options[]   = array(
    'name'     => 'misc_section',
    'title'    => esc_html__('Misc', 'arkito'),
    'icon'     => 'fa fa-recycle',
    'sections' => array(

      // custom sidebar section
      array(
        'name'     => 'custom_sidebar_section',
        'title'    => esc_html__('Custom Sidebar', 'arkito'),
        'icon'     => 'fa fa-reorder',
        'fields'   => array(

          // start fields
          array(
            'id'              => 'custom_sidebar',
            'title'           => esc_html__('Sidebars', 'arkito'),
            'desc'            => esc_html__('Go to Appearance -> Widgets after create sidebars', 'arkito'),
            'type'            => 'group',
            'fields'          => array(
              array(
                'id'          => 'sidebar_name',
                'type'        => 'text',
                'title'       => esc_html__('Sidebar Name', 'arkito'),
              ),
              array(
                'id'          => 'sidebar_desc',
                'type'        => 'text',
                'title'       => esc_html__('Custom Description', 'arkito'),
              )
            ),
            'accordion'       => true,
            'button_title'    => esc_html__('Add New Sidebar', 'arkito'),
            'accordion_title' => esc_html__('New Sidebar', 'arkito'),
          ),
          // end fields

        )
      ),
      // custom sidebar section

      // Custom CSS/JS
      array(
        'name'        => 'custom_css_js_section',
        'title'       => esc_html__('Custom Codes', 'arkito'),
        'icon'        => 'fa fa-code',

        // begin: fields
        'fields'      => array(
          // Start Custom CSS/JS
          array(
            'type'    => 'notice',
            'class'   => 'info cs-arkito-heading',
            'content' => esc_html__('Custom JS', 'arkito')
          ),
          array(
            'id'             => 'theme_custom_js',
            'type'           => 'textarea',
            'attributes' => array(
              'rows'     => 10,
              'placeholder'     => esc_html__('Enter your JS code here...', 'arkito'),
            ),
          ),
          // End Custom CSS/JS

        ) // end: fields
      ),

      // Translation
      array(
        'name'        => 'theme_translation_section',
        'title'       => esc_html__('Translation', 'arkito'),
        'icon'        => 'fa fa-language',

        // begin: fields
        'fields'      => array(

          // Start Translation
          array(
            'type'    => 'notice',
            'class'   => 'info cs-arkito-heading',
            'content' => esc_html__('Common Texts', 'arkito')
          ),
          array(
            'id'          => 'read_more_text',
            'type'        => 'text',
            'title'       => esc_html__('Read More Text', 'arkito'),
          ),
          array(
            'id'          => 'view_more_text',
            'type'        => 'text',
            'title'       => esc_html__('View More Text', 'arkito'),
          ),
          array(
            'id'          => 'share_text',
            'type'        => 'text',
            'title'       => esc_html__('Share Text', 'arkito'),
          ),
          array(
            'id'          => 'share_on_text',
            'type'        => 'text',
            'title'       => esc_html__('Share On Tooltip Text', 'arkito'),
          ),
          array(
            'id'          => 'author_text',
            'type'        => 'text',
            'title'       => esc_html__('Author Text', 'arkito'),
          ),
          array(
            'id'          => 'post_comment_text',
            'type'        => 'text',
            'title'       => esc_html__('Post Comment Text [Submit Button]', 'arkito'),
          ),
          array(
            'type'    => 'notice',
            'class'   => 'info cs-arkito-heading',
            'content' => esc_html__('WooCommerce', 'arkito')
          ),
          array(
            'id'          => 'add_to_cart_text',
            'type'        => 'text',
            'title'       => esc_html__('Add to Cart Text', 'arkito'),
          ),
          array(
            'id'          => 'details_text',
            'type'        => 'text',
            'title'       => esc_html__('Details Text', 'arkito'),
          ),

          array(
            'type'    => 'notice',
            'class'   => 'info cs-arkito-heading',
            'content' => esc_html__('Pagination', 'arkito')
          ),
          array(
            'id'          => 'older_post',
            'type'        => 'text',
            'title'       => esc_html__('Older Posts Text', 'arkito'),
          ),
          array(
            'id'          => 'newer_post',
            'type'        => 'text',
            'title'       => esc_html__('Newer Posts Text', 'arkito'),
          ),

          array(
            'type'    => 'notice',
            'class'   => 'info cs-arkito-heading',
            'content' => esc_html__('Single Portfolio Pagination', 'arkito')
          ),
          array(
            'id'          => 'prev_port',
            'type'        => 'text',
            'title'       => esc_html__('Prev Case Text', 'arkito'),
          ),
          array(
            'id'          => 'next_port',
            'type'        => 'text',
            'title'       => esc_html__('Next Case Text', 'arkito'),
          ),
          // End Translation

        ) // end: fields
      ),

    ),
  );

  
  // ------------------------------
  // backup                       -
  // ------------------------------
  $options[]   = array(
    'name'     => 'backup_section',
    'title'    => 'Backup',
    'icon'     => 'fa fa-shield',
    'fields'   => array(

      array(
        'type'    => 'notice',
        'class'   => 'warning',
        'content' => esc_html__('You can save your current options. Download a Backup and Import.', 'arkito'),
      ),

      array(
        'type'    => 'backup',
      ),

    )
  );

  return $options;

}
add_filter( 'cs_framework_options', 'arkito_options' );