<?php
	// Metabox
	$arkito_id    = ( isset( $post ) ) ? $post->ID : 0;
	$arkito_id    = ( is_home() ) ? get_option( 'page_for_posts' ) : $arkito_id;
	$arkito_id    = ( is_woocommerce_shop() ) ? wc_get_page_id( 'shop' ) : $arkito_id;
	$arkito_meta  = get_post_meta( $arkito_id, 'page_type_metabox', true );
	if ($arkito_meta && is_page()) {
		$arkito_title_bar_padding = $arkito_meta['title_area_spacings'];
	} else { $arkito_title_bar_padding = ''; }
	// Padding - Theme Options
	if ($arkito_title_bar_padding && $arkito_title_bar_padding !== 'padding-default') {
		$arkito_title_top_spacings = $arkito_meta['title_top_spacings'];
		$arkito_title_bottom_spacings = $arkito_meta['title_bottom_spacings'];
		if ($arkito_title_bar_padding === 'padding-custom') {
			$arkito_title_top_spacings = $arkito_title_top_spacings ? 'padding-top:'. arkito_check_px($arkito_title_top_spacings) .';' : '';
			$arkito_title_bottom_spacings = $arkito_title_bottom_spacings ? 'padding-bottom:'. arkito_check_px($arkito_title_bottom_spacings) .';' : '';
			$arkito_custom_padding = $arkito_title_top_spacings . $arkito_title_bottom_spacings;
		} else {
			$arkito_custom_padding = '';
		}
	} else {
		$arkito_title_bar_padding = cs_get_option('title_bar_padding');
		$arkito_titlebar_top_padding = cs_get_option('titlebar_top_padding');
		$arkito_titlebar_bottom_padding = cs_get_option('titlebar_bottom_padding');
		if ($arkito_title_bar_padding === 'padding-custom') {
			$arkito_titlebar_top_padding = $arkito_titlebar_top_padding ? 'padding-top:'. arkito_check_px($arkito_titlebar_top_padding) .';' : '';
			$arkito_titlebar_bottom_padding = $arkito_titlebar_bottom_padding ? 'padding-bottom:'. arkito_check_px($arkito_titlebar_bottom_padding) .';' : '';
			$arkito_custom_padding = $arkito_titlebar_top_padding . $arkito_titlebar_bottom_padding;
		} else {
			$arkito_custom_padding = '';
		}
	}
	// Banner Type - Meta Box
	if ($arkito_meta && is_page()) {
		$arkito_banner_type = $arkito_meta['banner_type'];
	} else { $arkito_banner_type = ''; }
	// Header Style
	if ($arkito_meta) {
	  $arkito_header_design  = $arkito_meta['select_header_design'];
	  $arkito_hide_breadcrumbs  = $arkito_meta['hide_breadcrumbs'];
	} else {
	  $arkito_header_design  = cs_get_option('select_header_design');
	  $arkito_hide_breadcrumbs = cs_get_option('need_breadcrumbs');
	}
	if ( $arkito_header_design === 'default') {
	  $arkito_header_design_actual  = cs_get_option('select_header_design');
	} else {
	  $arkito_header_design_actual = ( $arkito_header_design ) ? $arkito_header_design : cs_get_option('select_header_design');
	}
	if ( $arkito_header_design_actual == 'style_two') {
		$overly_class = ' overly';
	} else {
		$overly_class = ' ';
	}
	// Overlay Color - Theme Options
		if ($arkito_meta && is_page()) {
			$arkito_bg_overlay_color = $arkito_meta['titlebar_bg_overlay_color'];
			$title_color = isset($arkito_meta['title_color']) ? $arkito_meta['title_color'] : '';
		} else { $arkito_bg_overlay_color = ''; }
		if (!empty($arkito_bg_overlay_color)) {
			$arkito_bg_overlay_color = $arkito_bg_overlay_color;
			$title_color = $title_color;
		} else {
			$arkito_bg_overlay_color = cs_get_option('titlebar_bg_overlay_color');
			$title_color = cs_get_option('title_color');
		}
		$e_uniqid        = uniqid();
		$inline_style  = '';
		if ( $arkito_bg_overlay_color ) {
		 $inline_style .= '.page-title-'.$e_uniqid .'.page-title {';
		 $inline_style .= ( $arkito_bg_overlay_color ) ? 'background-color:'. $arkito_bg_overlay_color.';' : '';
		 $inline_style .= '}';
		}
		if ( $title_color ) {
		 $inline_style .= '.page-title-'.$e_uniqid .'.page-title h2, .page-title-'.$e_uniqid .'.page-title .breadcrumb li, .page-title-'.$e_uniqid .'.page-title .breadcrumbs ul li a {';
		 $inline_style .= ( $title_color ) ? 'color:'. $title_color.';' : '';
		 $inline_style .= '}';
		}
		// add inline style
		add_inline_style( $inline_style );
		$styled_class  = ' page-title-'.$e_uniqid;
	// Background - Type
	if( $arkito_meta ) {
		$title_bar_bg = $arkito_meta['title_area_bg'];
	} else {
		$title_bar_bg = '';
	}
	$arkito_custom_header = get_custom_header();
	$header_text_color = get_theme_mod( 'header_textcolor' );
	$background_color = get_theme_mod( 'background_color' );
	if( isset( $title_bar_bg['image'] ) && ( $title_bar_bg['image'] ||  $title_bar_bg['color'] ) ) {
	  extract( $title_bar_bg );
	  $arkito_background_image       = ( ! empty( $image ) ) ? 'background-image: url(' . esc_url($image) . ');' : '';
	  $arkito_background_repeat      = ( ! empty( $image ) && ! empty( $repeat ) ) ? ' background-repeat: ' . esc_attr( $repeat) . ';' : '';
	  $arkito_background_position    = ( ! empty( $image ) && ! empty( $position ) ) ? ' background-position: ' . esc_attr($position) . ';' : '';
	  $arkito_background_size    = ( ! empty( $image ) && ! empty( $size ) ) ? ' background-size: ' . esc_attr($size) . ';' : '';
	  $arkito_background_attachment    = ( ! empty( $image ) && ! empty( $size ) ) ? ' background-attachment: ' . esc_attr( $attachment ) . ';' : '';
	  $arkito_background_color       = ( ! empty( $color ) ) ? ' background-color: ' . esc_attr( $color ) . ';' : '';
	  $arkito_background_style       = ( ! empty( $image ) ) ? $arkito_background_image . $arkito_background_repeat . $arkito_background_position . $arkito_background_size . $arkito_background_attachment : '';
	  $arkito_title_bg = ( ! empty( $arkito_background_style ) || ! empty( $arkito_background_color ) ) ? $arkito_background_style . $arkito_background_color : '';
	} elseif( $arkito_custom_header->url ) {
		$arkito_title_bg = 'background-image:  url('. esc_url( $arkito_custom_header->url ) .');';
	} else {
		$arkito_title_bg = '';
	}
	if($arkito_banner_type === 'hide-title-area') { // Hide Title Area
	} elseif($arkito_meta && $arkito_banner_type === 'revolution-slider') { // Hide Title Area
		echo do_shortcode($arkito_meta['page_revslider']);
	} else {
	?>
 <!-- start page-title -->
  <section class="page-title <?php echo esc_attr( $overly_class.$styled_class.' '.$arkito_banner_type ); ?>" style="<?php echo esc_attr( $arkito_title_bg ); ?>">
  	<div class="page-title-container">
      <div class="page-title-wrapper">
	  		<div class="container">
	      	<div class="row">
	          <div class="col col-xs-12" style="<?php echo esc_attr( $arkito_custom_padding ); ?>" >
	              <div class="title">
	                <h2><?php echo arkito_title_area(); ?></h2>
	            	</div>
	           </div>
	      	</div> <!-- end row -->
	  		</div> <!-- end container -->
  		</div>
  	</div>
  </section>
  <!-- end page-title -->
<?php } ?>