<?php
// Metabox
global $post;
$arkito_id    = ( isset( $post ) ) ? $post->ID : false;
$arkito_id    = ( is_home() ) ? get_option( 'page_for_posts' ) : $arkito_id;
$arkito_id    = ( is_woocommerce_shop() ) ? wc_get_page_id( 'shop' ) : $arkito_id;
$arkito_id    = ( ! is_tag() && ! is_archive() && ! is_search() && ! is_404() && ! is_singular('testimonial') ) ? $arkito_id : false;
$arkito_meta  = get_post_meta( $arkito_id, 'page_type_metabox', true );
  if ($arkito_meta) {
    $arkito_topbar_options = $arkito_meta['topbar_options'];
  } else {
    $arkito_topbar_options = '';
  }

  if ( $arkito_meta ) {
    $arkito_header_design  = $arkito_meta['select_header_design'];
  } else {
    $arkito_header_design  = cs_get_option( 'select_header_design' );
  }

 if ( $arkito_header_design === 'default' ) {
    $arkito_header_design_actual  = cs_get_option( 'select_header_design' );
  } else {
    $arkito_header_design_actual = ( $arkito_header_design ) ? $arkito_header_design : cs_get_option('select_header_design');
  }
  
$arkito_header_design_actual = $arkito_header_design_actual ? $arkito_header_design_actual : 'style_two';

// Define Theme Options and Metabox varials in right way!
if ($arkito_meta) {
  if ($arkito_topbar_options === 'custom' && $arkito_topbar_options !== 'default') {
    $arkito_top_left          = $arkito_meta['top_left'];
    $arkito_top_right          = $arkito_meta['top_right'];
    $arkito_hide_topbar        = $arkito_topbar_options;
    $arkito_topbar_bg          = $arkito_meta['topbar_bg'];
    if ($arkito_topbar_bg) {
      $arkito_topbar_bg = 'background-color: '. $arkito_topbar_bg .';';
    } else {$arkito_topbar_bg = '';}
  } else {
    $arkito_top_left          = cs_get_option('top_left');
    $arkito_top_right          = cs_get_option('top_right');
    $arkito_hide_topbar        = cs_get_option('top_bar');
    $arkito_topbar_bg          = '';
  }
} else {
  // Theme Options fields
  $arkito_top_left         = cs_get_option('top_left');
  $arkito_top_right          = cs_get_option('top_right');
  $arkito_hide_topbar        = cs_get_option('top_bar');
  $arkito_topbar_bg          = '';
}
// All options
if ( $arkito_meta && $arkito_topbar_options === 'custom' && $arkito_topbar_options !== 'default' ) {
  $arkito_top_right = ( $arkito_top_right ) ? $arkito_meta['top_right'] : cs_get_option('top_right');
  $arkito_top_left = ( $arkito_top_left ) ? $arkito_meta['top_left'] : cs_get_option('top_left');
} else {
  $arkito_top_right = cs_get_option('top_right');
  $arkito_top_left = cs_get_option('top_left');
}
if ( $arkito_meta && $arkito_topbar_options !== 'default' ) {
  if ( $arkito_topbar_options === 'hide_topbar' ) {
    $arkito_hide_topbar = 'hide';
  } else {
    $arkito_hide_topbar = 'show';
  }
} else {
  $arkito_hide_topbar_check = cs_get_option( 'top_bar' );
  if ( $arkito_hide_topbar_check === true ) {
     $arkito_hide_topbar = 'hide';
  } else {
     $arkito_hide_topbar = 'show';
  }
}
if ( $arkito_meta ) {
  $arkito_topbar_bg = ( $arkito_topbar_bg ) ? $arkito_meta['topbar_bg'] : '';
} else {
  $arkito_topbar_bg = '';
}
if ( $arkito_topbar_bg ) {
  $arkito_topbar_bg = 'background-color: '. $arkito_topbar_bg .';';
} else { $arkito_topbar_bg = ''; }


if ( $arkito_header_design_actual == 'style_two' ) { 
  $top_container = 'container';
  $top_column_left = 'col col-md-6 col-sm-7 col-12';
  $top_column_right = 'col col-md-6 col-sm-5 col-12';
} else {
  $top_container = 'container-fluid';
  $top_column_left = 'col col-md-6 col-sm-8 col-12';
  $top_column_right = 'col col-md-6 col-sm-4 col-12';
}


if( $arkito_hide_topbar === 'show' && ( $arkito_top_left || $arkito_top_right ) ) {
?>
 <div class="topbar" style="<?php echo esc_attr( $arkito_topbar_bg ); ?>">
    <div class="<?php echo esc_attr( $top_container ); ?>">
        <div class="row">
            <div class="<?php echo esc_attr( $top_column_left ); ?>">
               <?php echo do_shortcode( $arkito_top_left ); ?>
            </div>
            <div class="<?php echo esc_attr( $top_column_right ); ?>">
                <?php echo do_shortcode( $arkito_top_right ); ?>
            </div>
        </div>
    </div>
</div> <!-- end topbar -->
<?php } // Hide Topbar - From Metabox