<?php
/**
 * Single Post.
 */
$arkito_large_image =  wp_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'fullsize', false, '' );
$arkito_large_image = $arkito_large_image ? $arkito_large_image[0] : '';
$image_alt = get_post_meta( get_post_thumbnail_id(), '_wp_attachment_image_alt', true);
$arkito_post_type = get_post_meta( get_the_ID(), 'post_type_metabox', true );
// Single Theme Option
$arkito_post_pagination_option = cs_get_option('single_post_pagination');
$arkito_single_featured_image = cs_get_option('single_featured_image');
$arkito_single_author_info = cs_get_option('single_author_info');
$arkito_single_share_option = cs_get_option('single_share_option');
$arkito_metas_hide = (array) cs_get_option( 'theme_metas_hide' );
?>
  <div <?php post_class('post clearfix'); ?>>
  	<?php if ( $arkito_large_image ) { ?>
  	  <div class="entry-media">
        <img src="<?php echo esc_url( $arkito_large_image ); ?>" alt="<?php echo esc_attr( $image_alt ); ?>">
   		</div>
  	<?php	} ?>
    <div class="date-entry-meta">
        <ul class="entry-meta">
          <li>
             <?php if ( !in_array( 'author', $arkito_metas_hide ) ) { // Author Hide
                printf(
                '<span><i class="ti-user author"></i><a href="%1$s" rel="author">%2$s</a></span>',
                esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ), get_the_author()
                );
            } ?>
          </li>
          <li><i class="ti-calendar"></i>
            <a href="<?php echo esc_url( get_permalink() ); ?>"><?php echo esc_html( get_the_date() );  ?></a></li>
          <li>
        <i class="ti-comment"></i>
             <a class="arkito-comment" href="<?php echo esc_url( get_comments_link() ); ?>">
              <?php printf( esc_html( _nx( 'Comments (%1$s)', 'Comments (%1$s)', get_comments_number(), 'comments title', 'arkito' ) ), '<span class="comment">'.number_format_i18n( get_comments_number() ).'</span>','<span>' . get_the_title() . '</span>' ); ?>
            </a>
          </li>
      </ul>
    </div>
    <div class="entry-details">
	     <?php
				the_content();
				echo arkito_wp_link_pages();
			 ?>
    </div>
</div>
<?php if( has_tag() || ( $arkito_single_share_option && function_exists('arkito_wp_share_option') ) ) { ?>
<div class="tag-share clearfix">
  <?php if( has_tag() ) { ?>
     <div class="tag">
          <?php
            echo '<span>'.esc_html__('Tags:','arkito').'</span>';
            $tag_list = get_the_tags();
            if($tag_list) {
              echo the_tags( ' <ul><li>', '</li><li>', '</li></ul>' );
           } ?>
      </div>
    <?php } 
  		if ( $arkito_single_share_option && function_exists('arkito_wp_share_option') ) {
  					echo arkito_wp_share_option();
  			}
  	 ?>
</div>
<?php
}
if( !$arkito_single_author_info ) {
	arkito_author_info();
	}
?>

