

import { Suspense } from "react";
import { createBrowserRouter, RouterProvider } from "react-router-dom";
import HomeOne from "./components/homes/home-1";  
import HomeTwo from "./components/homes/home-2";
import HomeThree from "./components/homes/home-3";
import HomeFour from "./components/homes/home-4";
import HomeFive from "./components/homes/home-5";
import HomeOnePage from "./components/one-page/home-one-page";
import HomeTwoOnePage from "./components/one-page/home-2-one-page";
import HomeThreeOnePage from "./components/one-page/home-3-one-page";
import HomeFourOnePage from "./components/one-page/home-4-one-page";
import HomeFiveOnePage from "./components/one-page/home-5-one-page";
import About from "./components/about";
import Services from "./components/services";
import ServiceDetails from "./components/service-details";
import Portfolio from "./components/portfolio";
import PortfolioDetails from "./components/portfolio-details";
import Pricing from "./components/pricing";
import Testimonial from "./components/testimonial";
import Faq from "./components/faq";
import Team from "./components/team";
import TeamDetails from "./components/team-details";
import Contact from "./components/contact";
import Blog from "./components/blog";
import BlogGrid from "./components/blog-grid";
import BlogList from "./components/blog-list";
import BlogDetails from "./components/blog-details";
import BlogDetailsNoSidebar from "./components/blog-details-no-sidebar";
import NotFound from "./components/error";

// import NotFound from "./error";




const router = createBrowserRouter([ 
  
  { path: "/", element: <HomeOne /> }, 
  { path: "/home-2", element: <HomeTwo /> }, 
  { path: "/home-3", element: <HomeThree /> }, 
  { path: "/home-4", element: <HomeFour /> }, 
  { path: "/home-5", element: <HomeFive /> }, 
  { path: "/home-one-page", element: <HomeOnePage /> }, 
  { path: "/home-2-one-page", element: <HomeTwoOnePage /> }, 
  { path: "/home-3-one-page", element: <HomeThreeOnePage /> }, 
  { path: "/home-4-one-page", element: <HomeFourOnePage /> }, 
  { path: "/home-5-one-page", element: <HomeFiveOnePage /> }, 

  { path: "/about", element: <About /> }, 
  { path: "/services", element: <Services /> }, 
  { path: "/service-details", element: <ServiceDetails /> }, 

  { path: "/portfolio", element: <Portfolio /> }, 
  { path: "/portfolio-details", element: <PortfolioDetails /> }, 

  { path: "/pricing", element: <Pricing /> }, 
  { path: "/testimonial", element: <Testimonial /> }, 
  { path: "/faq", element: <Faq /> }, 


  { path: "/team", element: <Team /> }, 
  { path: "/team-details", element: <TeamDetails /> }, 
  { path: "/contact", element: <Contact /> },
  
  
  { path: "/blog", element: <Blog /> }, 
  { path: "/blog-grid", element: <BlogGrid /> }, 
  { path: "/blog-list", element: <BlogList /> }, 
  { path: "/blog-details", element: <BlogDetails /> }, 
  { path: "/blog-details-no-sidebar", element: <BlogDetailsNoSidebar /> }, 


  { path: "*", element: <NotFound /> },
]);


 


function App() {
  return (
    <> 
      <Suspense>
        <RouterProvider router={router} />
      </Suspense>
    </>

  );
}

export default App;
