import { useEffect } from "react";
import { useLocation } from "react-router-dom";

const BackToTop = () => {
  const { pathname } = useLocation();

  useEffect(() => {
    const scrollToTop = () => { 
      if (window.scrollY > 0) {
        window.scrollTo({ top: 0, behavior: "smooth" });
      }
    }; 
    const timer = setTimeout(scrollToTop, 100);
    
    return () => clearTimeout(timer);
  }, [pathname]);

  return null;
};

export default BackToTop;