import { Link } from "react-router-dom";

interface BreadcrumbProps {
  title: string;
  subtitle: string;
}

export default function Breadcrumb({title, subtitle} : BreadcrumbProps) {
  return (
    <section className="mt-breadcrumb-area mt-breadcrumb-bg mt-breadcrumb-space p-relative fix"
       style={{backgroundImage: `url(/assets/img/breadcrumb/breadcrumb-bg.jpg)`}}>
      <div className="mt-breadcrumb-shape">
        <img className="mt-breadcrumb-shape-1 p-absolute" src="assets/img/breadcrumb/shape.png" alt="" />
      </div>
      <div className="container">
        <div className="row align-items-center">
          <div className="col-lg-12 mb-30">
            <div className="mt-breadcrumb z-index-2 text-center">
              <h1 className="mt-breadcrumb-title mb-10">{title}</h1>
              <div className="mt-breadcrumb-list">
                <span className="active"><Link to="/">Home</Link></span>
                <span className="dvir">-</span>
                <span>{subtitle}</span>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  )
}
