
import { Link } from "react-router-dom";
import { useState } from "react";
import MobileMenu from "../layouts/headers/MobileMenu";
import ImageLightbox from "../modal/ImageLightbox";

interface OffCanvasProps {
  setMenuOpen: Function,
  menuOpen: boolean
}


export default function OffCanvas({ setMenuOpen, menuOpen }: OffCanvasProps) {
    const [lightboxOpen, setLightboxOpen] = useState(false)
    const [currentImageIndex, setCurrentImageIndex] = useState(0)
  
    const images = [
      "/assets/img/project/project-1-1.jpg",
      "/assets/img/project/project-1-2.jpg",
      "/assets/img/project/project-1-3.jpg",
      "/assets/img/project/project-1-4.jpg"
    ]
  
    const openLightbox = (index: number) => {
      setCurrentImageIndex(index)
      setLightboxOpen(true)
    }
  return (
    <>
      <div className={`mt-offcanvas ${menuOpen ? "mt-offcanvas-open" : ""}`}>
        <div className="mt-offcanvas-wrapper">
          <div className="mt-offcanvas-header d-flex justify-content-between align-items-center mb-90">
            <div className="mt-offcanvas-logo">
              <Link to="/"><img src="/assets/img/logo/white-logo.png" alt="" /></Link>
            </div>
            <div className="mt-offcanvas-close">
              <button className="mt-offcanvas-close-toggle" onClick={() => setMenuOpen(false)}><i className="fal fa-times"></i></button>
            </div>
          </div>
          <div className="mt-offcanvas-menu d-xl-none mb-50">
            <nav>
              <MobileMenu />
            </nav>
          </div>
          <div className="mt-offcanvas-content mb-50 d-none d-xl-block">
            <h2 className="mt-offcanvas-title">Hello There!</h2>
            <p>Lorem ipsum dolor sit amet, consect etur adipiscing elit. </p>
          </div>
          <div className="mt-offcanvas-gallery mb-50">
              {images.map((src, index) => (
              <a
                key={index}
                className="popup-image"
                onClick={() => openLightbox(index)}
                style={{
                  background: 'none',
                  border: 'none',
                  padding: 0,
                  cursor: 'pointer',
                  width: '100%',
                  maxWidth: '100px',
                  margin: '0 5px 5px 0'
                }}
                aria-label={`View project image ${index + 1}`}
              >
                <img
                  src={src}
                  alt={`Project ${index + 1}`}
                  style={{ width: '100%', height: 'auto', borderRadius: '4px' }}
                />
              </a>
            ))} 
          </div>
          <div className="mt-offcanvas-info mb-50">
            <h3 className="mt-offcanvas-sm-title">Information</h3>
            <span><a href="#">+ 4 20 7700 1007</a></span>
            <span><a href="#">hello@a.interon.com</a></span>
            <span><a href="#">Avenue de Roma 158b, Lisboa</a></span>
          </div>
          <div className="mt-offcanvas-social mb-50">
            <h3 className="mt-offcanvas-sm-title">Follow Us</h3>
            <a href="#"><i className="fab fa-facebook-f"></i></a>
            <a href="#"><i className="fab fa-twitter"></i></a>
            <a href="#"><i className="fab fa-linkedin-in"></i></a>
            <a href="#"><i className="fab fa-instagram"></i></a>
          </div>
        </div>
      </div>
      <div className={`mt-offcanvas-overlay ${menuOpen ? "mt-offcanvas-overlay-open" : ""}`} onClick={() => setMenuOpen(false)}></div>

       {/* Using the separate Lightbox component */}
            <ImageLightbox
              images={images}
              isOpen={lightboxOpen}
              initialIndex={currentImageIndex}
              onClose={() => setLightboxOpen(false)} 
            />


    </>
  )
}
