
import  { useState, useEffect } from "react"; 
import UseSticky from "../hooks/UseSticky";

 
const ScrollToTop = () => {
  const { sticky }: { sticky: boolean } = UseSticky();

  const [showScroll, setShowScroll] = useState(false);

  const checkScrollTop = () => {
    if (!showScroll && window.pageYOffset > 400) {
      setShowScroll(true);
    } else if (showScroll && window.pageYOffset <= 400) {
      setShowScroll(false);
    }
  };

  const scrollTop = () => {
    window.scrollTo({ top: 0, behavior: "smooth" });
  };

  useEffect(() => {
    window.addEventListener("scroll", checkScrollTop);
    return () => window.removeEventListener("scroll", checkScrollTop);
  }, []);

  return (
    <>
    <button onClick={scrollTop} className={`${sticky ? 'show' : ''}`} id="back-to-top">
      <i className="far fa-arrow-up"></i>
      </button> 
    </>
  );
};

export default ScrollToTop;
