

interface SearchAreaProps {
  setSearchOpen: Function,
  searchOpen: boolean
}

export default function SearchArea({ setSearchOpen, searchOpen }: SearchAreaProps) {
  return (
    <>
      <div className={`mt-header-search-bar d-flex align-items-center ${searchOpen ? "mt-search-open" : ""}`}>
        <button className="mt-search-close" onClick={() => setSearchOpen(false)}>×</button>
        <div className="container">
          <div className="row justify-content-center">
            <div className="col-lg-6">
              <div className="mt-search-bar text-center">
                <h2 className="mt-search-bar-title mb-30">What are you looking for?</h2>
                <div className="contact-form-box contact-search-form-box">
                  <form action="#">
                    <input type="email" placeholder="Search Here" />
                    <button type="submit"><i className="far fa-search"></i></button>
                  </form>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
      <div className={`mt-offcanvas-overlay ${searchOpen ? "mt-offcanvas-overlay-open" : ""}`} onClick={() => setSearchOpen(false)}></div>
    </>
  )
}
