import { Link } from "react-router-dom";


export default function BlogDetailsArea() {
  return (
    <section className="mt-blogpost-area pt-130 pb-70" data-bg-color="#F8F8F8" style={{backgroundColor: `#F8F8F8`}}>
      <div className="container">
        <div className="row">
          <div className="col-xl-8 col-lg-8">
            <article className="mt-postbox mb-60">
              <div className="mt-postbox-thumb">
                <img src="assets/img/blog/blog-lg-1-1.jpg" alt="" />
              </div>
              <div className="mt-postbox-content mb-50">
                <div className="mt-postbox-meta mb-15">
                  <span><a href="#"><i className="fal fa-user"></i> a.laxfy</a></span>
                  <span><a href="#"><i className="fal fa-calendar-alt"></i> 20 Sep. 2025</a></span>
                  <span><a href="#"><i className="fal fa-certificate"></i> Creative</a></span>
                </div>
                <h3 className="mt-postbox-title mt-fs-40 mb-30">Potent be interdum ipsum pellentes code primis
                  laoreet diam per established</h3>
                <div className="mt-postbox-details">
                  <p>Dictum veledo lorem hendrerit habitasse curabitur purus tacitian pellentesque facilisi
                    ligula maecenas sodales imperdiet lorem at ligula massa lorem elit morbi pede aptent
                    vestibulum taciti curae tortor duila nisiddo cum accumsan donec ad. Laoreet dolor tempor
                    cursus aptent eu hymenaeos vestibulum. Viverra. Semper phasellus sapien. At varius
                    vehicula volutpat a nunc integer tortor risus massa ante.</p>
                  <p>Purus tacitian pellentesque facilisi ligula maecenas sodales imperdiet lorem at ligula
                    massa lorem elit morbi pede aptent vestibulum taciti beg curae tortor duila nisiddo cum
                    accumsan donec ad. Laoreet dolor tempor cursus aptent eu hymenaeos vestibulum viverra.
                    semper phasellus</p>

                  <div className="mt-section-title-wrapper mb-10 mt-30">
                    <h2 className="mt-section-title mb-20 mt-fs-24">Our supporters and beneficiaries are at the
                      heart of everything
                      we do. Their experiences and words inspire us and remind.</h2>
                  </div>
                  <div className="row g-3">
                    <div className="col-md-6 mb-20">
                      <img src="assets/img/blog/blog-sm-1.jpg" alt="" />
                    </div>
                    <div className="col-md-6 mb-20">
                      <img src="assets/img/blog/blog-sm-2.jpg" alt="" />
                    </div>
                  </div>
                  <div className="mt-section-title-wrapper mb-20">
                    <p>Every individual we serve has a unique story—a journey marked by resilience, hope, and
                      transformation.
                      Through our charity’s support, countless individuals and communities have overcome
                      challenges and
                      found new paths toward a brighter future. From gaining access to clean water and
                      education to
                      rebuilding lives after a crisis, these stories remind us of the profound impact that
                      compassionate aid
                      can bring.</p>
                  </div>
                  <div className="row g-3">
                    <div className="col-md-12 mb-20">
                      <img src="assets/img/blog/blog-sm-3.jpg" alt="" />
                    </div>

                  </div>
                  <div className="mt-section-title-wrapper mb-50">
                    <p>Every individual we serve has a unique story—a journey marked by resilience, hope, and
                      transformation.
                      Through our charity’s support, countless individuals and communities have overcome
                      challenges and
                      found new paths toward a brighter future. From gaining access to clean water and
                      education to
                      rebuilding lives after a crisis, these stories remind us of the profound impact that
                      compassionate aid
                      can bring.</p>
                  </div>
                  <div className="mt-postbox-tag-wrapper">
                    <div className="row align-items-center">
                      <div className="col-lg-7">
                        <div className="mt-postbox-tag mb-30">
                          <span>Tags:</span>
                          <Link to="/blog">Creative</Link>
                          <Link to="/blog">Consultant</Link>
                          <Link to="/blog">Business</Link>
                        </div>
                      </div>
                      <div className="col-lg-5">
                        <div className="mt-postbox-social mb-30 text-start text-lg-end">
                          <a href="#"><i className="fab fa-facebook-f"></i></a>
                          <a href="#"><i className="fab fa-twitter"></i></a>
                          <a href="#"><i className="fab fa-linkedin-in"></i></a>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
              <div className="postbox__author d-flex align-items-center p-relative mb-50">
                <div className="postbox__author-thumb">
                  <a href="#">
                    <img src="assets/img/blog/author-1-3.jpg" alt="" />
                  </a>
                </div>
                <div className="postbox__author-content ">
                  <h3 className="postbox__author-title">
                    <a href="#">Jo Markless</a>
                  </h3>
                  <div className="postbox__author-social">
                    <a href="#"><i className="fa-brands fa-facebook-f"></i></a>
                    <a href="#"><i className="fa-brands fa-linkedin-in"></i></a>
                    <a href="#"><i className="fa-brands fa-twitter"></i></a>
                  </div>
                  <p>Interior design is more than just aesthetics—it's about creating a <br /> functional,
                    comfortable, and visually stunning space that enhances <br /> everyday living. Whether
                    designing
                    a home,</p>
                </div>
              </div>
              <div className="postbox__pagination mb-90 d-flex justify-content-center">
                <button><span><i className="fal fa-long-arrow-left"></i></span> Prev</button>
                <button className="active">Next <span><i className="fal fa-long-arrow-right"></i></span> </button>
              </div>
            </article>
            <div className="mt-postbox-comments-wrapper mb-30">
              <div className="mt-section-title-wrapper mb-40 mt-30">
                <h2 className="mt-section-title mb-20 mt-fs-40">Comments (03)</h2>
              </div>
              <div className="mt-postbox-comments ">
                <ul>
                  <li>
                    <div className="mt-postbox-comments-thumb br-50">
                      <img src="assets/img/blog/author/author-2-1.jpg" alt="" />
                    </div>
                    <div className="mt-postbox-comments-text">
                      <h5 className="mt-postbox-comments-author mb-25">Jkma puithon</h5>
                      <a href="#" className="reply"> Reply</a>

                      <p>We value your thoughts and feedback! Your insights help us improve and inspire our
                        creative
                        community. Share your experiences, ask questions, or discuss ideas related to
                        AI-powered
                        creativity and design.</p>
                      <span><cite></cite></span>
                      <span>Digital Studio</span>
                      <span><i></i></span>
                      <span>26 sep 2025</span>
                    </div>
                  </li>
                  <li className="children">
                    <div className="mt-postbox-comments-thumb br-50">
                      <img src="assets/img/blog/author/author-2-2.jpg" alt="" />
                    </div>
                    <div className="mt-postbox-comments-text">
                      <h5 className="mt-postbox-comments-author mb-25">Jesika brown</h5>
                      <a href="#" className="reply"> Reply</a>
                      <p>Conubia non viverra malesuada aenean per odio magna hymenaeos, cubilia euducate
                        class bulputate aenean laoreet nam ipsum mus neko porttitor.</p>
                      <span><cite></cite></span>
                      <span>Digital Studio</span>
                      <span><i></i></span>
                      <span>26 sep 2025</span>
                    </div>
                  </li>
                  <li>
                    <div className="mt-postbox-comments-thumb br-50">
                      <img src="assets/img/blog/author/author-2-1.jpg" alt="" />
                    </div>
                    <div className="mt-postbox-comments-text">
                      <h5 className="mt-postbox-comments-author mb-25">Kathryn Murphy</h5>
                      <a href="#" className="reply"> Reply</a>
                      <p>We value your thoughts and feedback! Your insights help us improve and inspire our
                        creative
                        community. Share your experiences, ask questions, or discuss ideas related to
                        AI-powered
                        creativity and design.</p>
                      <span><cite></cite></span>
                      <span>Digital Studio</span>
                      <span><i></i></span>
                      <span>26 sep 2025</span>
                    </div>
                  </li>
                </ul>
              </div>
            </div>
            <div className="contact-form-box mb-50">
              <div className="mt-section-title-wrapper mb-30 mt-30">
                <h2 className="mt-section-title mb-20 mt-fs-40">Leave a Comment</h2>
              </div>
              <div className="mtcontact__forms mb-50">
                <form action="#">
                  <div className="row">
                    <div className="col-xl-6 col-lg-6 col-md-6 col-12 mb-20">
                      <div className="mtcontact__form-inputbox">
                        <input type="text" placeholder="Enter your name" />
                      </div>
                    </div>
                    <div className="col-xl-6 col-lg- col-md-6 col-12 mb-20">
                      <div className="mtcontact__form-inputbox">
                        <input type="text" placeholder="Enter your email" />
                      </div>
                    </div>
                    <div className="col-12 mb-20">
                      <div className="mtcontact__form-inputbox">
                        <input type="text" placeholder="Your subject" />
                      </div>
                    </div>
                    <div className="col-12 mb-20">
                      <div className="mtcontact__form-inputbox">
                        <textarea placeholder="Write your message"></textarea>
                      </div>
                    </div>
                  </div>
                  <button type="submit">
                    <span className="mt-btn">Post Comment</span>
                    <span className="mt-btn mt-btn-icon"><i className="fa-solid fa-arrow-right"></i></span>
                  </button>
                </form>
              </div>
            </div>
          </div>
          <div className="col-xl-4 col-lg-4">
            <div className="mt-blog-sidebar-widget mb-50">
              <h3 className="mt-blog-sidebar-title mt-fs-24 mb-25"> Search here</h3>
              <form className="mt-blog-form position-relative" action="#">
                <input type="text" placeholder="Search hare" />
                <button type="submit"><i className="fa-regular fa-magnifying-glass"></i></button>
              </form>
            </div>
            <div className="mt-blog-sidebar-widget mb-50">
              <h3 className="mt-blog-sidebar-title mt-fs-24 mb-25"> Category</h3>
              <div className="mt-blog-sidebar-cat">
                <ul>
                  <li><Link to="/blog">Product design</Link></li>
                  <li><Link to="/blog">Visual identity</Link></li>
                  <li><Link to="/blog">Branding design</Link></li>
                  <li><Link to="/blog">Web design</Link></li>
                  <li><Link to="/blog">Content writing</Link></li>
                  <li><Link to="/blog">Creative solution</Link></li>
                </ul>
              </div>
            </div>
            <div className="mt-blog-sidebar-widget mb-50">
              <h3 className="mt-blog-sidebar-title mt-fs-24 mb-25"> Recent post</h3>
              <div className="mt-blog-sidebar-post">
                <div className="mt-blog-sidebar-post-item mb-15 d-flex align-items-center">
                  <div className="mt-blog-sidebar-post-thumb mr-20">
                    <a href="blog-details.html" className="br-5"><img src="assets/img/instagram/thumb-1.jpg"
                      alt="" /></a>
                  </div>
                  <div className="mt-blog-sidebar-post-content">
                    <div className="mt-postbox-meta mb-7">
                      <span><a href="#">Technology</a></span>
                    </div>
                    <h5 className="mt-blog-sidebar-post-title mt-fs-20">
                      <a href="blog-details.html">personal stories from
                        individuals.</a>
                    </h5>
                  </div>
                </div>
                <div className="mt-blog-sidebar-post-item mb-15 d-flex align-items-center">
                  <div className="mt-blog-sidebar-post-thumb mr-20">
                    <a href="blog-details.html" className="br-5"><img src="assets/img/instagram/thumb-2.jpg"
                      alt="" /></a>
                  </div>
                  <div className="mt-blog-sidebar-post-content">
                    <div className="mt-postbox-meta mb-7">
                      <span><a href="#">Technology</a></span>
                    </div>
                    <h5 className="mt-blog-sidebar-post-title mt-fs-20">
                      <a href="blog-details.html">personal stories from
                        individuals.</a>
                    </h5>
                  </div>
                </div>
                <div className="mt-blog-sidebar-post-item d-flex align-items-center">
                  <div className="mt-blog-sidebar-post-thumb mr-20">
                    <a href="blog-details.html" className="br-5"><img src="assets/img/instagram/thumb-3.jpg"
                      alt="" /></a>
                  </div>
                  <div className="mt-blog-sidebar-post-content">
                    <div className="mt-postbox-meta mb-7">
                      <span><a href="#">Technology</a></span>
                    </div>
                    <h5 className="mt-blog-sidebar-post-title mt-fs-20">
                      <a href="blog-details.html">personal stories from
                        individuals.</a>
                    </h5>
                  </div>
                </div>
              </div>
            </div>
            <div className="mt-blog-sidebar-widget mb-50">
              <h3 className="mt-blog-sidebar-title mt-fs-24 mb-25"> Tags cloud</h3>
              <div className="tagcloud">
                <Link to="/blog">Data-Driven</Link>
                <Link to="/blog">Proven Success</Link>
                <Link to="/blog">Customer</Link>
                <Link to="/blog">Strategies</Link>
                <Link to="/blog">Technology</Link>
                <Link to="/blog">Efficiency</Link>
              </div>
            </div>
            <div className="mt-blog-sidebar-widget mb-50">
              <h3 className="mt-blog-sidebar-title mt-fs-24 mb-25"> Social media</h3>
              <div className="mt-blog-sidebar-social">
                <a href="#"><i className="fab fa-facebook-f"></i></a>
                <a href="#"><i className="fab fa-twitter"></i></a>
                <a href="#"><i className="fab fa-instagram"></i></a>
                <a href="#"><i className="fab fa-linkedin-in"></i></a>
              </div>
            </div>
            <div className="mt-blog-sidebar-widget mb-50">
              <h3 className="mt-blog-sidebar-title mt-fs-24 mb-25">Instagram Follow</h3>
              <div className="mt-blog-sidebar-gallery mb-20">
                <a className="popup-image" href="assets/img/instagram/thumb-1.jpg"><img
                  src="assets/img/instagram/thumb-1.jpg" alt="" /></a>
                <a className="popup-image" href="assets/img/instagram/thumb-2.jpg"><img
                  src="assets/img/instagram/thumb-2.jpg" alt="" /></a>
                <a className="popup-image" href="assets/img/instagram/thumb-3.jpg"><img
                  src="assets/img/instagram/thumb-3.jpg" alt="" /></a>
                <a className="popup-image" href="assets/img/instagram/thumb-4.jpg"><img
                  src="assets/img/instagram/thumb-4.jpg" alt="" /></a>
                <a className="popup-image" href="assets/img/instagram/thumb-4.jpg"><img
                  src="assets/img/instagram/thumb-4.jpg" alt="" /></a>
                <a className="popup-image" href="assets/img/instagram/thumb-5.jpg"><img
                  src="assets/img/instagram/thumb-5.jpg" alt="" /></a>
              </div>
              <div className="mt-blog-sidebar-gallery-btn">
                <a href="#"><span><i className="fab fa-instagram"></i></span>Follow Us Instagram</a>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  )
}
