import { Link } from "react-router-dom";



export default function BlogListArea() {
  return (
    <section className="mt-blogpost-area pt-130 pb-80" data-bg-color="#F8F8F8" style={{ backgroundColor: `#F8F8F8` }}>
      <div className="container">
        <div className="row">
          <div className="col-xl-8 col-lg-8">
            <div className="row">
              <div className="col-lg-6 col-md-6">
                <div className="mtblog__item mb-50">
                  <div className="mtblog__thumb p-relative mb-24">
                    <Link to="/blog-details"><img src="assets/img/blog/blog-1-1.jpg" alt="" /></Link>
                    <div className="mtblog__category">
                      <span><a href="#">Architecture</a></span>
                    </div>
                  </div>
                  <div className="mtblog__content">
                    <div className="mtblog__meta mb-15">
                      <span><a href="#">February 25,2025</a></span>
                      <cite></cite>
                      <span><a href="#">Leslie Alexander</a></span>
                    </div>
                    <h3 className="mtblog__title mb-15"><Link to="/blog-details">Beyond Aesthetics Smart &
                      Stylish <br />
                      Aesthetics Smart Interiors</Link></h3>
                    <div className="mtblog__btn">
                      <Link to="/blog-details">Read More</Link>
                    </div>
                  </div>
                </div>
              </div>
              <div className="col-lg-6 col-md-6">
                <div className="mtblog__item mb-50">
                  <div className="mtblog__thumb p-relative mb-24">
                    <Link to="/blog-details"><img src="assets/img/blog/blog-1-2.jpg" alt="" /></Link>
                    <div className="mtblog__category">
                      <span><a href="#">Architecture</a></span>
                    </div>
                  </div>
                  <div className="mtblog__content">
                    <div className="mtblog__meta mb-15">
                      <span><a href="#">February 25,2025</a></span>
                      <cite></cite>
                      <span><a href="#">Leslie Alexander</a></span>
                    </div>
                    <h3 className="mtblog__title mb-15"><Link to="/blog-details">Art of Mixing Textures Elevate
                      Your Interior Style</Link></h3>
                    <div className="mtblog__btn">
                      <Link to="/blog-details">Read More</Link>
                    </div>
                  </div>
                </div>
              </div>
              <div className="col-lg-6 col-md-6">
                <div className="mtblog__item mb-50">
                  <div className="mtblog__thumb p-relative mb-24">
                    <a href="#"><img src="assets/img/blog/blog-1-3.jpg" alt="" /></a>
                    <div className="mtblog__category">
                      <span><Link to="/blog-details">Architecture</Link></span>
                    </div>
                  </div>
                  <div className="mtblog__content">
                    <div className="mtblog__meta mb-15">
                      <span><a href="#">February 25,2025</a></span>
                      <cite></cite>
                      <span><a href="#">Leslie Alexander</a></span>
                    </div>
                    <h3 className="mtblog__title mb-15"><Link to="/blog-details">x pert Advice for Timeless
                      Interiors Mixing Textures Elevate</Link></h3>
                    <div className="mtblog__btn">
                      <Link to="/blog-details">Read More</Link>
                    </div>
                  </div>
                </div>
              </div>
              <div className="col-lg-6 col-md-6">
                <div className="mtblog__item mb-50">
                  <div className="mtblog__thumb p-relative mb-24">
                    <Link to="/blog-details"><img src="assets/img/blog/blog-1-4.jpg" alt="" /></Link>
                    <div className="mtblog__category">
                      <span><a href="#">Architecture</a></span>
                    </div>
                  </div>
                  <div className="mtblog__content">
                    <div className="mtblog__meta mb-15">
                      <span><a href="#">February 25,2025</a></span>
                      <cite></cite>
                      <span><a href="#">Leslie Alexander</a></span>
                    </div>
                    <h3 className="mtblog__title mb-15"><Link to="/blog-details">Your Guide to Stylish Spaces
                      Elevate Your Space.</Link></h3>
                    <div className="mtblog__btn">
                      <Link to="/blog-details">Read More</Link>
                    </div>
                  </div>
                </div>
              </div>
              <div className="col-lg-6 col-md-6">
                <div className="mtblog__item mb-50">
                  <div className="mtblog__thumb p-relative mb-24">
                    <Link to="/blog-details"><img src="assets/img/blog/blog-1-5.jpg" alt="" /></Link>
                    <div className="mtblog__category">
                      <span><a href="#">Architecture</a></span>
                    </div>
                  </div>
                  <div className="mtblog__content">
                    <div className="mtblog__meta mb-15">
                      <span><a href="#">February 25,2025</a></span>
                      <cite></cite>
                      <span><a href="#">Leslie Alexander</a></span>
                    </div>
                    <h3 className="mtblog__title mb-15"><Link to="/blog-details">Innovate, Inspire, Interior
                      Trends
                      Tips & Transformations</Link></h3>
                    <div className="mtblog__btn">
                      <Link to="/blog-details">Read More</Link>
                    </div>
                  </div>
                </div>
              </div>
              <div className="col-lg-6 col-md-6">
                <div className="mtblog__item mb-50">
                  <div className="mtblog__thumb p-relative mb-24">
                    <Link to="/blog-details"><img src="assets/img/blog/blog-1-6.jpg" alt="" /></Link>
                    <div className="mtblog__category">
                      <span><a href="#">Architecture</a></span>
                    </div>
                  </div>
                  <div className="mtblog__content">
                    <div className="mtblog__meta mb-15">
                      <span><a href="#">February 25,2025</a></span>
                      <cite></cite>
                      <span><a href="#">Leslie Alexander</a></span>
                    </div>
                    <h3 className="mtblog__title mb-15"><Link to="/blog-details">Luxury on a Budget Affordable
                      Modern Design Hacks</Link></h3>
                    <div className="mtblog__btn">
                      <Link to="/blog-details">Read More</Link>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <div className="mt-pagination mt-30 mb-40 ">
              <ul>
                <li><a href="#"><i className="fal fa-long-arrow-left"></i></a></li>
                <li><a className="active" href="#">01</a></li>
                <li><a href="#">02</a></li>
                <li><a href="#">03</a></li>
                <li><a href="#"><i className="fal fa-long-arrow-right"></i></a></li>
              </ul>
            </div>
          </div>
          <div className="col-xl-4 col-lg-4">
            <div className="mt-blog-sidebar-widget mb-50">
              <h3 className="mt-blog-sidebar-title mt-fs-24 mb-25"> Search here</h3>
              <form className="mt-blog-form position-relative" action="#">
                <input type="text" placeholder="Search hare" />
                <button type="submit"><i className="fa-regular fa-magnifying-glass"></i></button>
              </form>
            </div>
            <div className="mt-blog-sidebar-widget mb-50">
              <h3 className="mt-blog-sidebar-title mt-fs-24 mb-25"> Category</h3>
              <div className="mt-blog-sidebar-cat">
                <ul>
                  <li><Link to="/blog">Product design</Link></li>
                  <li><Link to="/blog">Visual identity</Link></li>
                  <li><Link to="/blog">Branding design</Link></li>
                  <li><Link to="/blog">Web design</Link></li>
                  <li><Link to="/blog">Content writing</Link></li>
                  <li><Link to="/blog">Creative solution</Link></li>
                </ul>
              </div>
            </div>
            <div className="mt-blog-sidebar-widget mb-50">
              <h3 className="mt-blog-sidebar-title mt-fs-24 mb-25"> Recent post</h3>
              <div className="mt-blog-sidebar-post">
                <div className="mt-blog-sidebar-post-item mb-15 d-flex align-items-center">
                  <div className="mt-blog-sidebar-post-thumb mr-20">
                    <Link to="/blog-details" className="br-5"><img src="assets/img/instagram/thumb-1.jpg"
                      alt="" /></Link>
                  </div>
                  <div className="mt-blog-sidebar-post-content">
                    <div className="mt-postbox-meta mb-7">
                      <span><a href="#">Technology</a></span>
                    </div>
                    <h5 className="mt-blog-sidebar-post-title mt-fs-20">
                      <Link to="/blog-details">personal stories from
                        individuals.</Link>
                    </h5>
                  </div>
                </div>
                <div className="mt-blog-sidebar-post-item mb-15 d-flex align-items-center">
                  <div className="mt-blog-sidebar-post-thumb mr-20">
                    <Link to="/blog-details" className="br-5"><img src="assets/img/instagram/thumb-2.jpg"
                      alt="" /></Link>
                  </div>
                  <div className="mt-blog-sidebar-post-content">
                    <div className="mt-postbox-meta mb-7">
                      <span><a href="#">Technology</a></span>
                    </div>
                    <h5 className="mt-blog-sidebar-post-title mt-fs-20">
                      <Link to="/blog-details">personal stories from
                        individuals.</Link>
                    </h5>
                  </div>
                </div>
                <div className="mt-blog-sidebar-post-item d-flex align-items-center">
                  <div className="mt-blog-sidebar-post-thumb mr-20">
                    <Link to="/blog-details" className="br-5"><img src="assets/img/instagram/thumb-3.jpg"
                      alt="" /></Link>
                  </div>
                  <div className="mt-blog-sidebar-post-content">
                    <div className="mt-postbox-meta mb-7">
                      <span><a href="#">Technology</a></span>
                    </div>
                    <h5 className="mt-blog-sidebar-post-title mt-fs-20">
                      <Link to="/blog-details">personal stories from
                        individuals.</Link>
                    </h5>
                  </div>
                </div>
              </div>
            </div>
            <div className="mt-blog-sidebar-widget mb-50">
              <h3 className="mt-blog-sidebar-title mt-fs-24 mb-25"> Tags cloud</h3>
              <div className="tagcloud">
                <Link to="/blog">Data-Driven</Link>
                <Link to="/blog">Proven Success</Link>
                <Link to="/blog">Customer</Link>
                <Link to="/blog">Strategies</Link>
                <Link to="/blog">Technology</Link>
                <Link to="/blog">Efficiency</Link>
              </div>
            </div>
            <div className="mt-blog-sidebar-widget mb-50">
              <h3 className="mt-blog-sidebar-title mt-fs-24 mb-25"> Social media</h3>
              <div className="mt-blog-sidebar-social">
                <a href="#"><i className="fab fa-facebook-f"></i></a>
                <a href="#"><i className="fab fa-twitter"></i></a>
                <a href="#"><i className="fab fa-instagram"></i></a>
                <a href="#"><i className="fab fa-linkedin-in"></i></a>
              </div>
            </div>
            <div className="mt-blog-sidebar-widget mb-50">
              <h3 className="mt-blog-sidebar-title mt-fs-24 mb-25">Instagram Follow</h3>
              <div className="mt-blog-sidebar-gallery mb-20">
                <a className="popup-image" href="assets/img/instagram/thumb-1.jpg"><img
                  src="assets/img/instagram/thumb-1.jpg" alt="" /></a>
                <a className="popup-image" href="assets/img/instagram/thumb-2.jpg"><img
                  src="assets/img/instagram/thumb-2.jpg" alt="" /></a>
                <a className="popup-image" href="assets/img/instagram/thumb-3.jpg"><img
                  src="assets/img/instagram/thumb-3.jpg" alt="" /></a>
                <a className="popup-image" href="assets/img/instagram/thumb-4.jpg"><img
                  src="assets/img/instagram/thumb-4.jpg" alt="" /></a>
                <a className="popup-image" href="assets/img/instagram/thumb-4.jpg"><img
                  src="assets/img/instagram/thumb-4.jpg" alt="" /></a>
                <a className="popup-image" href="assets/img/instagram/thumb-5.jpg"><img
                  src="assets/img/instagram/thumb-5.jpg" alt="" /></a>
              </div>
              <div className="mt-blog-sidebar-gallery-btn">
                <a href="#"><span><i className="fab fa-instagram"></i></span>Follow Us Instagram</a>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  )
}
