
import { Link } from "react-router-dom";
import { Navigation, Pagination } from "swiper/modules";
import { Swiper, SwiperSlide } from "swiper/react"; 

// import Swiper css
import "swiper/css";
import "swiper/css/navigation";
import "swiper/css/pagination";
import VideoPopup from "../../modal/VideoPopup";

 


export default function BlogArea() {
  return (
    <section className="mt-blogpost-area pt-130 pb-70" data-bg-color="#F8F8F8" style={{ backgroundColor: `#F8F8F8` }}>
      <div className="container">
        <div className="row">
          <div className="col-xl-8 col-lg-8">
            <article className="mt-postbox mb-60">
              <div className="mt-postbox-thumb">
                <Link to="/blog-details"><img src="assets/img/blog/blog-lg-1-1.jpg" alt="" /></Link>
              </div>
              <div className="mt-postbox-content">
                <div className="mt-postbox-meta mb-15">
                  <span><a href="#"><i className="fal fa-user"></i> Arsha</a></span>
                  <span><a href="#"><i className="fal fa-calendar-alt"></i> 20 Sep. 2025</a></span>
                  <span><a href="#"><i className="fal fa-certificate"></i> Technology</a></span>
                </div>
                <h3 className="mt-postbox-title mb-20"><Link to="/blog-details">Beyond Aesthetics Smart & Stylish
                  Aesthetics Smart Interiors</Link></h3>
                <p className="mb-25">Purus tacitian pellentesque facilisi ligula maecenas sodales imperdiet lorem at
                  ligula massa
                  lorem elit morbi pede aptent vestibulum taciti beg curae tortor duila nisiddo cum accumsan
                  donec ad. Laoreet dolor tempor cursus aptent eu hymenaeos vestibulum viverra. semper
                  phasellus</p>
                <div className="mt-postbox-btn">
                  <Link to="/blog-details">
                    <span className="mt-btn">Read More</span>
                    <span className="mt-btn mt-btn-icon"><i className="fa-solid fa-arrow-right"></i></span>
                  </Link>
                </div>
              </div>
            </article>
            <article className="mt-postbox mb-60">
              <div className="mt-postbox-thumb p-relative">
                <Swiper
                slidesPerView={1}
                spaceBetween={0}
                keyboard={{
                  enabled: true,
                }}
                pagination={{
                  el: ".swiper-pagination",
                  clickable: true,
                }}
                navigation={{
                  nextEl: ".mt-swiper-blog-button-next",
                  prevEl: ".mt-swiper-blog-button-prev",
                }}
                modules={[Navigation, Pagination]}
                 className="swiper mt-blog-active">
                   
                    <SwiperSlide className="swiper-slide">
                      <img src="assets/img/blog/blog-lg-1-6.jpg" alt="" />
                    </SwiperSlide>
                    <SwiperSlide className="swiper-slide ">
                      <img src="assets/img/blog/blog-lg-1-1.jpg" alt="" />
                    </SwiperSlide>
                    <SwiperSlide className="swiper-slide">
                      <img src="assets/img/blog/blog-lg-1-4.jpg" alt="" />
                    </SwiperSlide>
                  
                </Swiper>
                <div className="mt-blog-slider-arrow">
                  <div style={{cursor: "pointer"}} className="mt-swiper-blog-button-prev mt-swiper-blog-button">
                    <i className="fa-regular fa-arrow-left-long"></i>
                  </div>
                  <div style={{cursor: "pointer"}} className="mt-swiper-blog-button-next mt-swiper-blog-button">
                    <i className="fa-regular fa-arrow-right-long"></i>
                  </div>
                </div>
              </div>
              <div className="mt-postbox-content">
                <div className="mt-postbox-meta mb-15">
                  <span><a href="#"><i className="fal fa-user"></i> A.laxfy</a></span>
                  <span><a href="#"><i className="fal fa-calendar-alt"></i> 20 Sep. 2025</a></span>
                  <span><a href="#"><i className="fal fa-certificate"></i> Technology</a></span>
                </div>
                <h3 className="mt-postbox-title mb-20"><Link to="/blog-details">Potent be interdum ipsum
                  pellentes code primis laoreet diam per established</Link></h3>
                <p className="mb-25">Purus tacitian pellentesque facilisi ligula maecenas sodales imperdiet lorem at
                  ligula massa
                  lorem elit morbi pede aptent vestibulum taciti beg curae tortor duila nisiddo cum accumsan
                  donec ad. Laoreet dolor tempor cursus aptent eu hymenaeos vestibulum viverra. semper
                  phasellus</p>
                <div className="mt-postbox-btn">
                  <Link to="/blog-details">
                    <span className="mt-btn">Read More</span>
                    <span className="mt-btn mt-btn-icon"><i className="fa-solid fa-arrow-right"></i></span>
                  </Link>
                </div>
              </div>
            </article>
            <article className="mt-postbox mb-60">
              <div className="mt-postbox-thumb p-relative">
                <img src="assets/img/blog/blog-lg-1-4.jpg" alt="" />
                <div className="mt-blog-video">
                  <VideoPopup>
                  <a className="popup-video" href="#"><i
                    className="fal fa-play"></i></a>
                  </VideoPopup>
                </div>
              </div>
              <div className="mt-postbox-content">
                <div className="mt-postbox-meta mb-15">
                  <span><a href="#"><i className="fal fa-user"></i> A.laxfy</a></span>
                  <span><a href="#"><i className="fal fa-calendar-alt"></i> 20 Sep. 2025</a></span>
                  <span><a href="#"><i className="fal fa-certificate"></i> Technology</a></span>
                </div>
                <h3 className="mt-postbox-title mb-20"><Link to="/blog-details">Potent be interdum ipsum
                  pellentes code primis laoreet diam per established</Link></h3>
                <p className="mb-25">Purus tacitian pellentesque facilisi ligula maecenas sodales imperdiet lorem at
                  ligula massa
                  lorem elit morbi pede aptent vestibulum taciti beg curae tortor duila nisiddo cum accumsan
                  donec ad. Laoreet dolor tempor cursus aptent eu hymenaeos vestibulum viverra. semper
                  phasellus</p>
                <div className="mt-postbox-btn">
                  <Link to="/blog-details">
                    <span className="mt-btn">Read More</span>
                    <span className="mt-btn mt-btn-icon"><i className="fa-solid fa-arrow-right"></i></span>
                  </Link>
                </div>
              </div>
            </article>
            <article className="mt-postbox mb-60">
              <div className="mt-postbox-thumb ratio ratio-16x9">
                <iframe height="300" allow="autoplay"
                  src="https://w.soundcloud.com/player/?url=https%3A//api.soundcloud.com/tracks/1851673326&color=%23ff5500&auto_play=false&hide_related=false&show_comments=true&show_user=true&show_reposts=false&show_teaser=true&visual=true"></iframe>
              </div>
              <div className="mt-postbox-content">
                <div className="mt-postbox-meta mb-15">
                  <span><a href="#"><i className="fal fa-user"></i> A.laxfy</a></span>
                  <span><a href="#"><i className="fal fa-calendar-alt"></i> 20 Sep. 2025</a></span>
                  <span><a href="#"><i className="fal fa-certificate"></i> Technology</a></span>
                </div>
                <h3 className="mt-postbox-title mb-20"><Link to="/blog-details">Potent be interdum ipsum
                  pellentes code primis laoreet diam per established</Link></h3>
                <p className="mb-25">Purus tacitian pellentesque facilisi ligula maecenas sodales imperdiet lorem at
                  ligula massa
                  lorem elit morbi pede aptent vestibulum taciti beg curae tortor duila nisiddo cum accumsan
                  donec ad. Laoreet dolor tempor cursus aptent eu hymenaeos vestibulum viverra. semper
                  phasellus</p>
                <div className="mt-postbox-btn">
                  <a href="#">
                    <span className="mt-btn">Read More</span>
                    <span className="mt-btn mt-btn-icon"><i className="fa-solid fa-arrow-right"></i></span>
                  </a>
                </div>
              </div>
            </article>
            <article className="mt-postbox mb-60">
              <div className="mt-postbox-thumb">
                <Link to="/blog-details"><img src="assets/img/blog/blog-lg-1-6.jpg" alt="" /></Link>
              </div>
              <div className="mt-postbox-content">
                <div className="mt-postbox-meta mb-15">
                  <span><a href="#"><i className="fal fa-user"></i> A.laxfy</a></span>
                  <span><a href="#"><i className="fal fa-calendar-alt"></i> 20 Sep. 2025</a></span>
                  <span><a href="#"><i className="fal fa-certificate"></i> Technology</a></span>
                </div>
                <h3 className="mt-postbox-title mb-20"><Link to="/blog-details">Potent be interdum ipsum
                  pellentes code primis laoreet diam per established</Link></h3>
                <p className="mb-25">Purus tacitian pellentesque facilisi ligula maecenas sodales imperdiet lorem at
                  ligula massa
                  lorem elit morbi pede aptent vestibulum taciti beg curae tortor duila nisiddo cum accumsan
                  donec ad. Laoreet dolor tempor cursus aptent eu hymenaeos vestibulum viverra. semper
                  phasellus</p>
                <div className="mt-postbox-btn">
                  <Link to="/blog-details">
                    <span className="mt-btn">Read More</span>
                    <span className="mt-btn mt-btn-icon"><i className="fa-solid fa-arrow-right"></i></span>
                  </Link>
                </div>
              </div>
            </article>
            <div className="mt-pagination mb-60">
              <ul>
                <li><a href="#"><i className="fal fa-long-arrow-left"></i></a></li>
                <li><a className="active" href="#">01</a></li>
                <li><a href="#">02</a></li>
                <li><a href="#">03</a></li>
                <li><a href="#"><i className="fal fa-long-arrow-right"></i></a></li>
              </ul>
            </div>
          </div>
          <div className="col-xl-4 col-lg-4">
            <div className="mt-blog-sidebar-widget mb-50">
              <h3 className="mt-blog-sidebar-title mt-fs-24 mb-25"> Search here</h3>
              <form className="mt-blog-form position-relative" action="#">
                <input type="text" placeholder="Search hare" />
                  <button type="submit"><i className="fa-regular fa-magnifying-glass"></i></button>
              </form>
            </div>
            <div className="mt-blog-sidebar-widget mb-50">
              <h3 className="mt-blog-sidebar-title mt-fs-24 mb-25"> Category</h3>
              <div className="mt-blog-sidebar-cat">
                <ul>
                  <li><Link to="/blog">Product design</Link></li>
                  <li><Link to="/blog">Visual identity</Link></li>
                  <li><Link to="/blog">Branding design</Link></li>
                  <li><Link to="/blog">Web design</Link></li>
                  <li><Link to="/blog">Content writing</Link></li>
                  <li><Link to="/blog">Creative solution</Link></li>
                </ul>
              </div>
            </div>
            <div className="mt-blog-sidebar-widget mb-50">
              <h3 className="mt-blog-sidebar-title mt-fs-24 mb-25"> Recent post</h3>
              <div className="mt-blog-sidebar-post">
                <div className="mt-blog-sidebar-post-item mb-15 d-flex align-items-center">
                  <div className="mt-blog-sidebar-post-thumb mr-20">
                    <Link to="/blog-details" className="br-5"><img src="assets/img/instagram/thumb-1.jpg"
                      alt="" /></Link>
                  </div>
                  <div className="mt-blog-sidebar-post-content">
                    <div className="mt-postbox-meta mb-7">
                      <span><a href="#">Technology</a></span>
                    </div>
                    <h5 className="mt-blog-sidebar-post-title mt-fs-20">
                      <Link to="/blog-details">personal stories from
                        individuals.</Link>
                    </h5>
                  </div>
                </div>
                <div className="mt-blog-sidebar-post-item mb-15 d-flex align-items-center">
                  <div className="mt-blog-sidebar-post-thumb mr-20">
                    <Link to="/blog-details" className="br-5"><img src="assets/img/instagram/thumb-2.jpg"
                      alt="" /></Link>
                  </div>
                  <div className="mt-blog-sidebar-post-content">
                    <div className="mt-postbox-meta mb-7">
                      <span><a href="#">Technology</a></span>
                    </div>
                    <h5 className="mt-blog-sidebar-post-title mt-fs-20">
                      <Link to="/blog-details">personal stories from
                        individuals.</Link>
                    </h5>
                  </div>
                </div>
                <div className="mt-blog-sidebar-post-item d-flex align-items-center">
                  <div className="mt-blog-sidebar-post-thumb mr-20">
                    <Link to="/blog-details" className="br-5"><img src="assets/img/instagram/thumb-3.jpg"
                      alt="" /></Link>
                  </div>
                  <div className="mt-blog-sidebar-post-content">
                    <div className="mt-postbox-meta mb-7">
                      <span><a href="#">Technology</a></span>
                    </div>
                    <h5 className="mt-blog-sidebar-post-title mt-fs-20">
                      <Link to="/blog-details">personal stories from
                        individuals.</Link>
                    </h5>
                  </div>
                </div>
              </div>
            </div>
            <div className="mt-blog-sidebar-widget mb-50">
              <h3 className="mt-blog-sidebar-title mt-fs-24 mb-25"> Tags cloud</h3>
              <div className="tagcloud">
                <Link to="/blog">Data-Driven</Link>
                <Link to="/blog">Proven Success</Link>
                <Link to="/blog">Customer</Link>
                <Link to="/blog">Strategies</Link>
                <Link to="/blog">Technology</Link>
                <Link to="/blog">Efficiency</Link>
              </div>
            </div>
            <div className="mt-blog-sidebar-widget mb-50">
              <h3 className="mt-blog-sidebar-title mt-fs-24 mb-25"> Social media</h3>
              <div className="mt-blog-sidebar-social">
                <a href="#"><i className="fab fa-facebook-f"></i></a>
                <a href="#"><i className="fab fa-twitter"></i></a>
                <a href="#"><i className="fab fa-instagram"></i></a>
                <a href="#"><i className="fab fa-linkedin-in"></i></a>
              </div>
            </div>
            <div className="mt-blog-sidebar-widget mb-50">
              <h3 className="mt-blog-sidebar-title mt-fs-24 mb-25">Instagram Follow</h3>
              <div className="mt-blog-sidebar-gallery mb-20">
                <a className="popup-image" href="assets/img/instagram/thumb-1.jpg"><img
                  src="assets/img/instagram/thumb-1.jpg" alt="" /></a>
                <a className="popup-image" href="assets/img/instagram/thumb-2.jpg"><img
                  src="assets/img/instagram/thumb-2.jpg" alt="" /></a>
                <a className="popup-image" href="assets/img/instagram/thumb-3.jpg"><img
                  src="assets/img/instagram/thumb-3.jpg" alt="" /></a>
                <a className="popup-image" href="assets/img/instagram/thumb-4.jpg"><img
                  src="assets/img/instagram/thumb-4.jpg" alt="" /></a>
                <a className="popup-image" href="assets/img/instagram/thumb-4.jpg"><img
                  src="assets/img/instagram/thumb-4.jpg" alt="" /></a>
                <a className="popup-image" href="assets/img/instagram/thumb-5.jpg"><img
                  src="assets/img/instagram/thumb-5.jpg" alt="" /></a>
              </div>
              <div className="mt-blog-sidebar-gallery-btn">
                <a href="#"><span><i className="fab fa-instagram"></i></span>Follow Us Instagram</a>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  )
}
