
import { Link } from "react-router-dom";
import Breadcrumb from "../../common/Breadcrumb";
import FooterOne from "../../layouts/footers/FooterOne";
import HeaderOne from "../../layouts/headers/HeaderOne";

export default function NotFound() {
  return (
    <>
    <HeaderOne />        
      <Breadcrumb title="404" subtitle="404" />
      <div className="mt-error-area pt-130 pb-130">
        <div className="container">
          <div className="row">
            <div className="col-xl-12">
              <div className="mt-error-content-box text-center">
                <div className="mt-error-thumb-box pb-75 wow img-custom-anim-top" data-wow-duration="1.5s"
                  data-wow-delay="0.3s">
                  <img src="assets/img/error/thumb-1.png" alt="" />
                </div>
                <div className="mt-error-content">
                  <h4 className="mt-error-title mt-upper">looks like you're lost</h4>
                  <p className="mb-40">Sorry, I couldn't find the page you were looking for. The suggestion is that
                    you <br />
                    return it to Homepage.</p>
                  <Link to="/">
                    <span className="mt-btn">BACK TO HOME</span>
                    <span className="mt-btn mt-btn-icon"><i className="fa-solid fa-arrow-right"></i></span>
                  </Link>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
      <FooterOne />
    </>
  )
}
