
import { Link } from "react-router-dom";
import Count from "../../../common/count";
import VideoPopup from "../../../modal/VideoPopup";



export default function AboutHomeOne() {
  return (
    <section className="mtabout__area pt-125 pb-100 p-relative " id="mtabout__onepage">
      <div className="container">
        <div className="mtabout__section-border mb-60">
          <div className="row align-items-end">
            <div className="col-lg-7">
              <div className="mt-section-content mb-50">
                <h5 className="mt-section-subtitle mb-20"><cite></cite><i></i>About Us</h5>
                <h2 className="mt-section-title">Where vision meets <br />
                  craftsmanship</h2>
              </div>
            </div>
            <div className="col-lg-5">
              <div className="mtabout__thumb-wrap mb-50">
                <div className="mtabout__thumb">
                  <img src="assets/img/about/shape-1-1.png" alt="" />
                </div>
                <div className="mt-section-content ">
                  <p className="ml-140">Every project we undertake is a testament to
                    dedication precision and unwavering commitment
                    to excellence.</p>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div className="row">
          <div className="col-lg-3">
            <div className="mtabout__exper-wrap mb-30 p-relative">
              <h3 className="mtabout__exper-number"> 
                <i className="purecounter" data-purecounter-duration="1"
                data-purecounter-end="12">
                  <Count number={12} /> </i><cite>+</cite>
                  </h3>
              <span className="mtabout__exper-title">Years of <br /> Experience</span>
            </div>
          </div>
          <div className="col-lg-6">
            <div className="mtabout__thumb-wrapper mb-30 d-flex">
              <div className="mtabout__thumb mr-24 wow img-custom-anim-top" data-wow-duration="1.5s"
                data-wow-delay="0.4s">
                <img src="assets/img/about/thumb-sm-1-1.jpg" alt="" />
              </div>
              <div className="mtabout__thumb-large p-relative wow img-custom-anim-top" data-wow-duration="1.5s"
                data-wow-delay="0.6s">
                <img src="assets/img/about/thumb-1-1.jpg" alt="" />
                <VideoPopup>
                  <div className="mtabout__thumb-play">
                    <a className="popup-video" href="#"><i
                      className="fa-solid fa-play"></i></a>
                  </div>
                </VideoPopup>
              </div>
            </div>
          </div>
          <div className="col-lg-3">
            <div className="mtabout__btn-wrap mb-30 text-end">
              <div className="mtabout__btn">
                <Link to="/about">
                  <span><svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" viewBox="0 0 22 22"
                    fill="none">
                    <path
                      d="M3.79394 5.19011C9.389 4.80644 16.6718 2.44475 22 0C19.5543 5.32713 17.1916 12.6089 16.8089 18.2039L13.1332 10.3608L1.80329 21.6914C1.605 21.8892 1.33631 22.0002 1.05626 22C0.847324 22 0.643097 21.938 0.469395 21.8219C0.295693 21.7058 0.160314 21.5408 0.0803792 21.3478C0.000444954 21.1548 -0.0204592 20.9424 0.0203078 20.7375C0.0610748 20.5325 0.161685 20.3443 0.309417 20.1965L11.6393 8.8668L3.79394 5.19011Z"
                      fill="#111111" />
                  </svg></span>
                  <span>
                    About Us
                  </span></Link>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  )
}
