 
import { Link } from "react-router-dom";
import { Swiper, SwiperSlide } from "swiper/react";
import { Navigation } from "swiper/modules";

// import Swiper css
import "swiper/css";
import "swiper/css/navigation";
import "swiper/css/pagination";


export default function BlogHomeOne() {
  return (
    <section className="mtblog__area pt-130 pb-120 p-relative fix" id="mtblog__onepage">
      <div className="container">
        <div className="row">
          <div className="col-lg-4">
            <div className="mtblog__section mr-60">
              <div className="mt-section-content mb-60">
                <h5 className="mt-section-subtitle mb-20"><cite></cite><i></i>Our Latest News</h5>
                <h2 className="mt-section-title mb-20">Our latest <br /> news</h2>
                <p>Every project we undertake is a testament
                  dedication precision unwavering commitment
                  to excellence.</p>
              </div>
              <div className="mtblog__arrow d-flex align-items-center justify-content-between z-index-4">
                <div style={{cursor: 'pointer'}} className="mtblog__button-next mtblog__button">
                  <span>
                    <svg xmlns="http://www.w3.org/2000/svg" width="23" height="14" viewBox="0 0 23 14"
                      fill="none">
                      <path
                        d="M12.4042 0C9.23442 2.80302 4.12106 5.44991 0 7.00078C4.12106 8.55061 9.23442 11.1965 12.4037 14L10.1942 7.80443L22.2084 7.80487C22.4184 7.8046 22.6197 7.71978 22.7681 7.56905C22.8788 7.45665 22.9542 7.31347 22.9848 7.15761C23.0153 7.00174 22.9996 6.84018 22.9397 6.69337C22.8797 6.54655 22.7782 6.42106 22.6479 6.33276C22.5177 6.24447 22.3645 6.19733 22.2078 6.1973L10.1941 6.1973L12.4042 0Z"
                        fill="#111111" />
                    </svg>
                  </span>
                </div>
                <div style={{cursor: 'pointer'}} className="mtblog__button-prev mtblog__button">
                  <span>
                    <svg xmlns="http://www.w3.org/2000/svg" width="23" height="14" viewBox="0 0 23 14"
                      fill="none">
                      <path
                        d="M10.5958 0C13.7656 2.80302 18.8789 5.44991 23 7.00078C18.8789 8.55061 13.7656 11.1965 10.5963 14L12.8058 7.80443L0.791596 7.80487C0.581603 7.8046 0.380306 7.71978 0.231934 7.56905C0.121174 7.45665 0.0457526 7.31347 0.0152059 7.15761C-0.0153409 7.00174 0.000354817 6.84018 0.0603161 6.69337C0.120277 6.54655 0.221807 6.42106 0.352071 6.33276C0.482334 6.24447 0.635485 6.19733 0.792157 6.1973L12.8059 6.1973L10.5958 0Z"
                        fill="#fff" />
                    </svg>
                  </span>
                </div>
              </div>
            </div>
          </div>
          <div className="col-lg-8">
            <div className="mtblog p-relative">
              <Swiper
                slidesPerView={2}
                spaceBetween={23}
                loop={true}
                navigation={
                  { nextEl: ".mtblog__button-next", prevEl: ".mtblog__button-prev" }
                }
                modules={[Navigation]}
                breakpoints={{
                  1200: {
                    slidesPerView: 2,
                  },
                  992: {
                    slidesPerView: 2,
                  },
                  768: {
                    slidesPerView: 2,
                  },
                  550: {
                    slidesPerView: 1,
                  },
                  0: {
                    slidesPerView: 1,
                  },
                }}
                className="swiper mt-blog-slider-active">

                <SwiperSlide className="swiper-slide">
                  <div className="mtblog__item">
                    <div className="mtblog__thumb p-relative mb-24 wow img-custom-anim-top"
                      data-wow-duration="1.5s" data-wow-delay="0.2s">
                      <Link to="/blog-details"><img src="assets/img/blog/blog-1-1.jpg" alt="" /></Link>
                      <div className="mtblog__category">
                        <span><Link to="/blog-details">Architecture</Link></span>
                      </div>
                    </div>
                    <div className="mtblog__content">
                      <div className="mtblog__meta mb-15">
                        <span><a href="#">February 25,2025</a></span>
                        <cite></cite>
                        <span><a href="#">Leslie Alexander</a></span>
                      </div>
                      <h3 className="mtblog__title mb-15"><Link to="/blog-details">Art of Mixing Textures
                        Elevate <br />
                        Your Interior Style</Link></h3>
                      <div className="mtblog__btn">
                        <Link to="/blog-details">Read More</Link>
                      </div>
                    </div>
                  </div>
                </SwiperSlide>
                <SwiperSlide className="swiper-slide">
                  <div className="mtblog__item">
                    <div className="mtblog__thumb p-relative mb-24 wow img-custom-anim-top"
                      data-wow-duration="1.5s" data-wow-delay="0.2s">
                      <Link to="/blog-details"><img src="assets/img/blog/blog-1-2.jpg" alt="" /></Link>
                      <div className="mtblog__category">
                        <span><Link to="/blog-details">Affordable</Link></span>
                      </div>
                    </div>
                    <div className="mtblog__content">
                      <div className="mtblog__meta mb-15">
                        <span><a href="#">February 25,2025</a></span>
                        <cite></cite>
                        <span><a href="#">Leslie Alexander</a></span>
                      </div>
                      <h3 className="mtblog__title mb-15"><Link to="/blog-details">Luxury on a Budget
                        Affordable <br />
                        Modern Design Hacks</Link></h3>
                      <div className="mtblog__btn">
                        <Link to="/blog-details">Read More</Link>
                      </div>
                    </div>
                  </div>
                </SwiperSlide>
                <SwiperSlide className="swiper-slide">
                  <div className="mtblog__item">
                    <div className="mtblog__thumb p-relative mb-24 wow img-custom-anim-top"
                      data-wow-duration="1.5s" data-wow-delay="0.2s">
                      <Link to="/blog-details"><img src="assets/img/blog/blog-1-1.jpg" alt="" /></Link>
                      <div className="mtblog__category">
                        <span><Link to="/blog-details">Textures</Link></span>
                      </div>
                    </div>
                    <div className="mtblog__content">
                      <div className="mtblog__meta mb-15">
                        <span><a href="#">February 25,2025</a></span>
                        <cite></cite>
                        <span><a href="#">Leslie Alexander</a></span>
                      </div>
                      <h3 className="mtblog__title mb-15"><Link to="/blog-details">Art of Mixing Textures
                        Elevate <br />
                        Your Interior Style</Link></h3>
                      <div className="mtblog__btn">
                        <Link to="/blog-details">Read More</Link>
                      </div>
                    </div>
                  </div>
                </SwiperSlide>

              </Swiper>
            </div>
          </div>
        </div>
      </div>
    </section>
  )
}
