
 
 

import { Swiper, SwiperSlide } from "swiper/react";
import { Autoplay, FreeMode } from "swiper/modules";

// Swiper CSS MUST be imported
import "swiper/css";
import "swiper/css/free-mode";
import "swiper/css/navigation";
import "swiper/css/pagination";

export default function BrandHomeOne() {
  const brandItems = ["Architect", "Quality", "Production", "Quality", "Production"];

  return (
    <>
      {/* LEFT ➝ RIGHT slider */}
      <section className="mtbrand__area p-relative">
        <Swiper
          modules={[Autoplay, FreeMode]}
          slidesPerView={4}
          spaceBetween={20}
          loop={true}
          freeMode={{ enabled: true }}
          speed={3000}
          allowTouchMove={false}
          autoplay={{
            delay: 0,
            disableOnInteraction: false,
          }}
          breakpoints={{
            1781: { slidesPerView: 4 },
            1199: { slidesPerView: 4 },
            991: { slidesPerView: 3 },
            767: { slidesPerView: 2 },
            0: { slidesPerView: 2 },
          }}
          className="mt-brand-title-active"
        >
          {brandItems.map((item, i) => (
            <SwiperSlide key={i} className="mt-brand-slide-element">
              <div className="mtbrand__wrapper">
                <h5 className="mtbrand__title" style={{display: 'flex', marginRight: '5px'}}>
                  {item} <span> </span>
                </h5>
              </div>
            </SwiperSlide>
          ))}
        </Swiper>
      </section>

      {/* RIGHT ➝ LEFT slider */}
      <section className="mtbrand__area p-relative pb-120">
        <Swiper
          modules={[Autoplay, FreeMode]}
          slidesPerView={4}
          spaceBetween={20}
          loop={true}
          freeMode={{ enabled: true }}
          speed={3000}
          allowTouchMove={false} 
          autoplay={{
            delay: 0,
            reverseDirection: true, // Right to Left
            disableOnInteraction: false,
          }}
          breakpoints={{
            1781: { slidesPerView: 4 },
            1199: { slidesPerView: 4 },
            991: { slidesPerView: 3 },
            767: { slidesPerView: 2 },
            0: { slidesPerView: 2 },
          }}
          className="mt-brand-title-active"
        >
          {brandItems.map((item, i) => (
            <SwiperSlide key={i} className="mt-brand-slide-element">
              <div className="mtbrand__wrapper">
                <h5 className="mtbrand__title" style={{display: 'flex', marginRight: '50px'}}>
                  {item} <span> </span>
                </h5>
              </div>
            </SwiperSlide>
          ))}
        </Swiper>
      </section>
    </>
  );
}
