 
import { Link } from "react-router-dom";
import { useJarallax } from "../../../hooks/useJarallax";
import VideoPopup from "../../../modal/VideoPopup";

export default function HeroHomeOne() { 
  const heroSectionRef = useJarallax(0.3);
  const backgroundRef = useJarallax(0.4);

  return (
    <section
      ref={heroSectionRef}
      className="mthero__area mthero__bg mthero__space fix"
      style={{ backgroundImage: `url(/assets/img/hero/hero-bg-1.jpg)` }}
    >
      <div className="container">
        <div className="row">
          <div className="col-xl-8">
            <div className="mthero__wrapper mb-50">
              <div className="mthero__section-title mb-60">
                <h2
                  className="mthero__title wow img-custom-anim-left"
                  data-wow-duration="1.5s"
                  data-wow-delay="0.2s"
                >
                  Classic <br />
                  Architecture
                </h2>
              </div>

              <div className="row">
                <div className="col-xl-6">
                  <div
                    className="mthero__content-wrap"
                    style={{
                      backgroundImage: `url(/assets/img/hero/shape-1-2.png)`
                    }}
                  >
                    <div className="mthero__content">
                      <div
                        className="mthero__text mthero__text-border pb-20 mb-35 wow img-custom-anim-right"
                        data-wow-duration="1.5s"
                        data-wow-delay="0.4s"
                      >
                        <p>
                          Classic architecture is a timeless blend of elegance,
                          symmetry and proportion.
                        </p>
                      </div>

                      <div
                        className="mthero__btnn pl-10 wow img-custom-anim-top"
                        data-wow-duration="1.5s"
                        data-wow-delay="0.9s"
                      >
                        <Link to="/about">
                          <span className="mt-btn">Get Started</span>
                          <span className="mt-btn mt-btn-icon">
                            <i className="fa-solid fa-arrow-right"></i>
                          </span>
                        </Link>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>

          {/* RIGHT CONTENT */}
          <div className="col-xl-4">
            <div className="mthero__video-wrapper mb-50 p-relative text-end">
              <div className="mthero__shape br-12">
                <img 
                  src="assets/img/hero/shape-1-1.png" 
                  alt="Decorative shape" 
                />
              </div>

              <div
                className="mthero__video-thumb wow img-custom-anim-top"
                data-wow-duration="1.5s"
                data-wow-delay="0.4s"
              >
                <img 
                  src="assets/img/hero/hero-sm-1-1.jpg" 
                  alt="Video thumbnail" 
                />

                <VideoPopup>
                  <div className="mthero__video-play">
                    <a className="popup-video" href="#">
                      <i className="fa-solid fa-play"></i>
                    </a>
                  </div>
                </VideoPopup>
              </div>
            </div>
          </div>
        </div>
      </div>

      {/* PARALLAX BACKGROUND */}
      <div
        ref={backgroundRef}
        className="mthero-bg-wrap mthero__bg p-relative"
        style={{ backgroundImage: `url(/assets/img/hero/hero-bg-1-2.jpg)` }}
      ></div>
    </section>
  );
}