 
import { useEffect, useRef } from "react";
import VideoPopup from "../../../modal/VideoPopup";

export default function VideoHomeOne() {

  const bgRef = useRef(null);

  useEffect(() => {
    import("jarallax").then(({ jarallax }) => {


      if (bgRef.current) {
        jarallax(bgRef.current, {
          speed: 0.4,
        });
      }
    });
  }, []);


  return (
    <div className="mtvideo__area mtvideo__space mtvideo__bg jarallax"
      ref={bgRef}
      style={{ backgroundImage: `url(/assets/img/video/video-bg-1.jpg)` }} >
      <div className="container">
        <div className="row">
          <div className="col-xl-12">
            <div className="mtvideo__play text-center">
              <VideoPopup>
                <a className="popup-video" href="#"><span> PLAY VIDEO</span></a>               
              </VideoPopup>
            </div>
          </div>
        </div>
      </div>
    </div>
  )
}
