 

import { useState } from "react"; 

interface AboutHomeTwoProps {
  style_2?: boolean
}

export default function AboutHomeTwo({style_2} : AboutHomeTwoProps) {
  const [open, setOpen] = useState(true); // default opened

  const toggleFAQ = () => {
    setOpen(!open);
  };
 

  return (
    <section
      id="mtabout__onepage"
      className={`mtabout__area mtabout__22  p-relative ${style_2 ? 'pt-130 pb-40' : 'pt-85 pb-50'}`}
    >
      <div className="container">
        <div className="row">
          {/* LEFT */}
          <div className="col-lg-6">
            <div className="mtabout__wrapper mb-60">
              <div className="mt-section-content mb-60">
                <h2 className="mt-section-title mb-20">
                  Inspired Design
                  Exceptional.
                </h2>
                <p>
                  At the core of everything we do is a commitment to integrity, <br />
                  quality, and innovation. With every project,
                </p>
              </div>

              {/* FAQ */}
              <div className="mtabout__skill-info mr-140">
                <div className="mt-faq-item mb-20 mr-40">
                  <h2 className="mt-faq-header">
                    <button
                      className={`mt-faq-button ${open ? "active" : ""}`}
                      type="button"
                      onClick={toggleFAQ}
                    >
                      <span>
                        <i className="fa-solid fa-angle-up"></i>
                      </span>
                      Unmatched Expertise
                    </button>
                  </h2>

                  {/* FAQ body */}
                  {open && (
                    <div className="mt-faq-collapse show">
                      <div className="mt-faq-body ml-30">
                        <p>
                          At the core of everything we do is a commitment to
                          integrity, quality and innovation.
                        </p>

                        {/* Progress Section */}
                        <div className="mtabout__progress">
                          <div className="mtabout__progress-item">
                            <h6>Design</h6>
                            <span className="progress-count">90%</span>
                            <div className="fix">
                              <div className="progress">
                                <div
                                  className="progress-bar"
                                  role="progressbar"
                                  style={{
                                    width: "90%",
                                    visibility: "visible",
                                    animationDuration: "1s",
                                    animationDelay: "0.3s",
                                    animationName: "slideInLeft",
                                  }}
                                ></div>
                              </div>
                            </div>
                          </div>
                        </div>
                        {/* End Progress */}
                      </div>
                    </div>
                  )}
                </div>
              </div>
              {/* End FAQ */}
            </div>
          </div>

          {/* RIGHT */}
          <div className="col-lg-6">
            <div
              className="mtabout__thumb-wrap mb-60 text-center text-lg-end wow img-custom-anim-top"
              data-wow-duration="1.5s"
              data-wow-delay="0.3s"
            >
              <div className="mtabout__thumb">
                <img
                  src="/assets/img/about/thumb-2-1.png"
                  width={500}
                  height={500}
                  alt="about-thumb"
                />
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  );
}
