  
import { useState } from "react";
import { faqDataLeft, faqDataRight } from "../../../data/faq-data";

export default function FaqHomeTwo() {
  const [activeLeft, setActiveLeft] = useState<number | null>(faqDataLeft[0]?.id);
  const [activeRight, setActiveRight] = useState<number | null>(faqDataRight[1]?.id);

  const toggleLeft = (id: number) => {
    setActiveLeft(activeLeft === id ? null : id);
  };

  const toggleRight = (id: number) => {
    setActiveRight(activeRight === id ? null : id);
  };

  const renderFAQ = (
    faqList: any[],
    activeId: number | null,
    toggleFn: (id: number) => void
  ) =>
    faqList.map((item) => (
      <div className="mt-accordion-item mb-20" key={item.id}>
        <h2 className="accordion-header mb-6">
          <button
            className={`mt-accordion-button ${activeId === item.id ? "" : "collapsed"}`}
            type="button"
            onClick={() => toggleFn(item.id)}
          >
            {item.question}
          </button>
        </h2>

        <div
          className={`mt-accordion-collapse collapse ${activeId === item.id ? "show" : ""
            }`}
        >
          <div className="mt-accordion-body pr-50">
            <p>{item.answer}</p>
          </div>
        </div>
      </div>
    ));

  return (
    <section className="mtfaq__area pt-130 pb-120 p-relative">
      <div className="container">
        <div className="row align-items-end mb-60">
          <div className="col-lg-7">
            <div className="mt-section-content mr-20">
              <h2 className="mt-section-title mb-20 mt-upper">
                Frequently <br /> Asked Questions
              </h2>
            </div>
          </div>

          <div className="col-lg-5">
            <div className="mt-section-content ml-130">
              <p>
                Every project we undertake is a testament to dedication,
                precision and unwavering commitment to excellence.
              </p>
            </div>
          </div>
        </div>

        <div className="row">
          {/* LEFT FAQ */}
          <div className="col-lg-6">
            <div className="mtfaq">
              {renderFAQ(faqDataLeft, activeLeft, toggleLeft)}
            </div>
          </div>

          {/* RIGHT FAQ */}
          <div className="col-lg-6">
            <div className="mtfaq">
              {renderFAQ(faqDataRight, activeRight, toggleRight)}
            </div>
          </div>
        </div>
      </div>
    </section>
  );
}

