 

import { useState } from "react"; 
import { Link } from "react-router-dom";

// Portfolio items data
const portfolioItems = [
  {
    id: 1,
    categories: ["cat1", "cat3"],
    img: "/assets/img/project/project-2-1.jpg",
    title: "Innovative UI/UX Design",
    date: "Jan 06.2026",
    delay: "0.2s",
  },
  {
    id: 2,
    categories: ["cat2", "cat3"],
    img: "/assets/img/project/project-2-2.jpg",
    title: "Crafting Iconic Spaces",
    date: "Jan 06.2026",
    delay: "0.4s",
  },
  {
    id: 3,
    categories: ["cat1", "cat2"],
    img: "/assets/img/project/project-2-3.jpg",
    title: "Innovative Designs",
    date: "Jan 06.2026",
    delay: "0.6s",
  },
  {
    id: 4,
    categories: ["cat3", "cat1"],
    img: "/assets/img/project/project-2-4.jpg",
    title: "Architectural Excellence",
    date: "Jan 06.2026",
    delay: "0.3s",
  },
  {
    id: 5,
    categories: ["cat2", "cat3"],
    img: "/assets/img/project/project-2-5.jpg",
    title: "Pushing Boundaries",
    date: "Jan 06.2026",
    delay: "0.5s",
  },
  {
    id: 6,
    categories: ["cat2", "cat1"],
    img: "/assets/img/project/project-2-6.jpg",
    title: "Quality Craftsmanship",
    date: "Jan 06.2026",
    delay: "0.7s",
  },
];

export default function PortfolioHomeTwo() {
  const [activeFilter, setActiveFilter] = useState("*");

  const handleFilter = (filter: string) => {
    setActiveFilter(filter);
  };

  const filteredItems =
    activeFilter === "*"
      ? portfolioItems
      : portfolioItems.filter((item) =>
          item.categories.includes(activeFilter)
        );

  return (
    <section className="mt-portfolio-area pt-10 pb-50 black-bg-1 p-relative fix" id="mtproject__onepage">
      <div className="container">
        <div className="row align-items-end">
          <div className="col-xl-6">
            <div className="mt-section-content mb-50">
              <h2 className="mt-section-title mt-upper">Feature project</h2>
            </div>
          </div>

          <div className="col-xl-6">
            <div className="mt-portfolio-filter portfolio-filter  text-lg-end mb-60 p-relative z-index-3">
              <button
                className={activeFilter === "*" ? "active" : ""}
                onClick={() => handleFilter("*")}
              >
                Show all /
              </button>

              <button
                className={activeFilter === "cat1" ? "active" : ""}
                onClick={() => handleFilter("cat1")}
              >
                Building /
              </button>

              <button
                className={activeFilter === "cat2" ? "active" : ""}
                onClick={() => handleFilter("cat2")}
              >
                Interior /
              </button>

              <button
                className={activeFilter === "cat3" ? "active" : ""}
                onClick={() => handleFilter("cat3")}
              >
                Residence
              </button>
            </div>
          </div>
        </div>
      </div>

      {/* Portfolio Items */}
      <div className="mt-portfolio-showcase">
        <div className="container-fluid px-0">
          <div className="row grid align-items-center g-4">

            {filteredItems.map((item) => (
              <div
                key={item.id}
                className="col-xl-4 col-lg-6 col-md-6 grid-item"
              >
                <div
                  className="mt-portfolio-item portfolio-item p-relative wow img-custom-anim-top"
                  data-wow-duration="1.5s"
                  data-wow-delay={item.delay}
                >
                  <div className="mt-portfolio-thumb portfolio-thumb w-img">
                    <div className="mt-portfolio-btnview">
                      <Link to="/portfolio-details" className="mt-btn view">
                        <span>View</span>
                      </Link>
                    </div>

                    <img
                      src={item.img}
                      width={600}
                      height={500}
                      alt={item.title}
                    />

                    <div className="mt-portfolio-content">
                      <span>{item.date}</span>
                      <h4 className="mt-portfolio-title mb-10">
                        <Link to="/portfolio-details">{item.title}</Link>
                      </h4>
                    </div>
                  </div>
                </div>
              </div>
            ))}

          </div>
        </div>
      </div>
    </section>
  );
}
