 
import { Link } from "react-router-dom";
import { team_data } from "../../../data/team-data";


export default function TeamHomeTwo() {
  return (
    <section className="mtteam__area mtteam__2-area mtteam__bg pt-120 pb-125 p-palette " id="mtteam__onepage">
      <div className="container">
        <div className="mt-section-content mb-50 text-center">
          <h2 className="mt-section-title mt-upper">Our Latest Team</h2>
        </div>
        <div className="mtteam__wrap">
          <div className="row">
             {team_data.map((item) => (
              <div className="col-lg-3 col-md-6" key={item.id}>
                <div
                  className="mtteam mtteam__2 p-relative mb-24 wow img-custom-anim-top"
                  data-wow-duration="1.5s"
                  data-wow-delay={item.delay}
                >
                  <div className="mtteam__thumb text-center">
                    <div className="mtteam__social">
                      <a target="_blank" href="https://www.facebook.com"><i className="fa-brands fa-facebook-f"></i></a>
                      <a target="_blank" href="https://www.x.com"><i className="fa-brands fa-twitter"></i></a>
                      <a target="_blank" href="https://www.instagram.com"><i className="fa-brands fa-instagram"></i></a>
                      <a target="_blank" href="https://www.youtube.com"><i className="fa-brands fa-youtube"></i></a>
                    </div>

                    <img src={item.img} alt={item.name} />

                    <div className="mtteam__content">
                      <span>{item.title}</span>
                      <h3 className="mtteam__title">
                        <Link to="/team-details">{item.name}</Link>
                      </h3>
                    </div>
                  </div>
                </div>
              </div>
            ))} 
          </div>
          <div className="mtteam__btn text-center mt-30">
            <Link to="/team" className="mt-btn big">
              <span>Join <br />
                Our team</span>
            </Link>
          </div>
        </div>
      </div>
    </section>
  )
}
