import { Link } from "react-router-dom";

export default function BlogHomeThree() {
  return (
    <section id="mtblog__onepage" className="mtblog__area mtblog__3 pt-120 pb-40 p-relative fix" data-bg-color="#0e1112" style={{ backgroundColor: `#0e1112` }}>
      <div className="container">
        <div className="row align-items-center">
          <div className="col-lg-7">
            <div className="mt-section-content mb-50 mr-20">
              <h2 className="mt-section-title mtwhite mb-20">Exploring <br />
                Timeless Designs.</h2>
              <h5 className="mt-section-subtitle mtwhite "><span></span>Our Blog</h5>
            </div>
          </div>
          <div className="col-lg-5">
            <div className="mt-section-content mb-50 ml-130">
              <p className="mtwhite">Every project we undertake is a testament to
                dedication precision and unwavering.</p>
            </div>
          </div>
        </div>
        <div className="mtblog__main-wrapper">
          <div className="row">
            <div className="col-lg-12">
              <div className="mtblog__wrapper">
                <div className="mtblog__item d-flex align-items-center justify-content-between">
                  <div className="mtblog__thumb p-relative br-5 pl-90 mr-50 wow img-custom-anim-top"
                    data-wow-duration="1.5s" data-wow-delay="0.2s">
                    <Link to="/blog-details"><img src="assets/img/blog/blog-3-1.jpg" alt="" /></Link>
                    <div className="mtblog__date">
                      <strong>23 </strong>
                      <span> August 2025 </span>
                    </div>
                  </div>
                  <div className="mtblog__content mr-140">
                    <h3 className="mtblog__title mt-fs-28 mb-15"><Link to="/blog-details">Timeless Designs
                      Blending Classic
                      <br />
                      & Modern Styles</Link></h3>
                  </div>
                  <div className="mtblog__btn-wrap">
                    <Link to="/blog-details" className="mt-btn-wrap">
                      <span className="mt-btn-border">Read More</span>
                      <span className="mt-btn-border mt-btn-border-icon rotate">
                        <i className="fa-solid fa-arrow-right"></i>
                      </span>
                    </Link>
                  </div>
                </div>
                <div className="mtblog__item d-flex align-items-center justify-content-between">
                  <div className="mtblog__thumb p-relative br-5 pl-90 mr-50 wow img-custom-anim-top"
                    data-wow-duration="1.5s" data-wow-delay="0.3s">
                    <Link to="/blog-details"><img src="assets/img/blog/blog-3-2.jpg" alt="" /></Link>
                    <div className="mtblog__date">
                      <strong>23 </strong>
                      <span> August 2025 </span>
                    </div>
                  </div>
                  <div className="mtblog__content mr-140">
                    <h3 className="mtblog__title mt-fs-28 mb-15"><Link to="/blog-details">The Importance of
                      Space Planning <br />
                      in Interior Design</Link></h3>
                  </div>
                  <div className="mtblog__btn-wrap">
                    <Link to="/blog-details" className="mt-btn-wrap">
                      <span className="mt-btn-border">Read More</span>
                      <span className="mt-btn-border mt-btn-border-icon rotate">
                        <i className="fa-solid fa-arrow-right"></i>
                      </span>
                    </Link>
                  </div>
                </div>
                <div className="mtblog__item d-flex align-items-center justify-content-between">
                  <div className="mtblog__thumb p-relative br-5 pl-90 mr-50 wow img-custom-anim-top"
                    data-wow-duration="1.5s" data-wow-delay="0.4s">
                    <Link to="/blog-details"><img src="assets/img/blog/blog-3-3.jpg" alt="" /></Link>
                    <div className="mtblog__date">
                      <strong>23 </strong>
                      <span> August 2025 </span>
                    </div>
                  </div>
                  <div className="mtblog__content mr-140">
                    <h3 className="mtblog__title mt-fs-28 mb-15"><Link to="/blog-details">Smart Home
                      Integration: The Future
                      <br />
                      of Living Spaces</Link></h3>
                  </div>
                  <div className="mtblog__btn-wrap">
                    <Link to="/blog-details" className="mt-btn-wrap">
                      <span className="mt-btn-border">Read More</span>
                      <span className="mt-btn-border mt-btn-border-icon rotate">
                        <i className="fa-solid fa-arrow-right"></i>
                      </span>
                    </Link>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  )
}
